/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class CMAC
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = -2204223714265387148L;
    private String a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private CryptoTransform e;
    private byte[] f;
    private byte[] k;
    private byte[] l;
    private byte[] m;
    private byte[] n;
    private byte[] o;
    private Integer p;
    private int q;
    private int r;
    private Random s;

    public void reset() {
        this.c = null;
        this.d = null;
        this.k = null;
        this.l = null;
        this.o = null;
        this.n = null;
        this.s = null;
    }

    public CMAC() {
        super("CMAC");
    }

    public void init(int n2, Object[] objectArray, Random random) {
        if (n2 != 5) {
            throw new IllegalArgumentException("wrong mode");
        }
        this.a = (String)objectArray[0];
        this.p = (Integer)objectArray[1];
        int n3 = this.p;
        this.q = n3 / 8;
        this.b = (byte[])objectArray[2];
        this.s = random;
        this.r = (Integer)objectArray[3];
        if (this.r < 8 || this.r > this.q) {
            throw new IllegalArgumentException("wrong size of TLen");
        }
        this.f = new byte[this.q];
        this.o = new byte[this.q];
        this.l = new byte[this.q];
        this.e = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, this.a);
        this.e.init(3, new Object[]{"CBC", this.p, this.b, this.f}, random);
        this.k = new byte[this.q];
        Arrays.fill(this.k, (byte)0);
        switch (n3) {
            case 128: {
                this.k[this.q - 1] = -121;
                break;
            }
            case 64: {
                this.k[this.q - 1] = 27;
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong block size");
            }
        }
        System.arraycopy(this.f, 0, this.l, 0, this.f.length);
        this.a(this.b);
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        int n5;
        int n6 = n5 = this.n == null ? 0 : this.n.length;
        if (n5 > 0) {
            this.e.init(3, new Object[]{"CBC", this.p, this.b, this.f}, this.s);
            if (n3 + n5 < this.q) {
                if (n3 > 0) {
                    byte[] byArray3 = this.n;
                    this.n = new byte[n5 + n3];
                    System.arraycopy(byArray3, 0, this.n, 0, n5);
                    System.arraycopy(byArray, n2, this.n, n5, n3);
                }
            } else if (n3 + n5 == this.q) {
                System.arraycopy(this.n, 0, this.o, 0, n5);
                System.arraycopy(byArray, n2, this.o, n5, this.q - n5);
                System.arraycopy(this.l, 0, this.m, 0, this.q);
                this.l = this.e.transform(this.a(this.l, this.o), 0, this.q, true);
                this.n = null;
            } else {
                System.arraycopy(this.n, 0, this.o, 0, n5);
                System.arraycopy(byArray, n2, this.o, n5, this.q - n5);
                n2 += this.q - n5;
                n3 -= this.q - n5;
                this.n = null;
                System.arraycopy(this.l, 0, this.m, 0, this.q);
                this.l = this.e.transform(this.a(this.l, this.o), 0, this.q, true);
            }
        }
        while (n3 > this.q) {
            this.a(byArray, n2);
            n2 += this.q;
            n3 -= this.q;
        }
        if (bl) {
            if (this.n != null) {
                this.a(this.n, 0, this.n.length);
            } else if (n3 == 0) {
                if (this.m == null) {
                    this.a(null, 0, 0);
                } else {
                    this.l = this.m;
                    this.a(this.c, 0, this.o, 0, this.q, this.o, 0);
                    this.e.init(3, new Object[]{"CBC", this.p, this.b, this.f}, this.s);
                    this.l = this.e.transform(this.o, 0, this.q, true);
                }
            } else if (n3 == this.q) {
                this.a(this.c, 0, byArray, n2, this.q, this.o, 0);
                this.a(this.o, 0);
            } else {
                this.a(byArray, n2, n3);
            }
        } else if (n3 == this.q) {
            this.a(byArray, n2);
        } else {
            this.n = new byte[n3];
            System.arraycopy(byArray, n2, this.n, 0, n3);
        }
        if (bl) {
            System.arraycopy(this.l, 0, byArray2, n4, this.r);
            return this.r;
        }
        return 0;
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = byArray == null ? 0 : n3;
        byte[] byArray2 = new byte[this.q - n4];
        byArray2[0] = -128;
        this.a(this.d, 0, byArray, n2, n4, this.o, 0);
        this.a(this.d, n4, byArray2, 0, this.q - n4, this.o, n4);
        this.e.init(3, new Object[]{"CBC", this.p, this.b, this.f}, this.s);
        this.l = this.e.transform(this.a(this.l, this.o), 0, this.q, true);
    }

    private void a(byte[] byArray, int n2) {
        this.e.init(3, new Object[]{"CBC", this.p, this.b, this.f}, this.s);
        this.a(this.l, 0, byArray, n2, this.q, this.o, 0);
        if (this.m == null) {
            this.m = new byte[this.q];
        }
        System.arraycopy(this.l, 0, this.m, 0, this.q);
        this.l = this.e.transform(this.o, 0, this.q, true);
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        if (bl) {
            return this.r;
        }
        return 0;
    }

    private void a(byte[] byArray) throws IllegalStateException {
        byte[] byArray2 = this.e.transform(this.f, 0, this.q, true);
        this.c = this.b(byArray2);
        if ((byArray2[0] & 0xFFFFFF80) == -128) {
            this.c = this.a(this.c, this.k);
        }
        this.d = this.b(this.c);
        if ((this.c[0] & 0xFFFFFF80) == -128) {
            this.d = this.a(this.d, this.k);
        }
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray3[n5 + i2] = (byte)(byArray[n2 + i2] ^ byArray2[n3 + i2]);
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            throw new IllegalStateException("cannot produce xor of different stream lengths");
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[i2]);
        }
        return byArray;
    }

    private byte[] b(byte[] byArray) {
        if (byArray == null) {
            return byArray;
        }
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        byte by = 0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            byte by2 = byArray[i2];
            byArray2[i2] = (byte)(by2 << 1);
            int n3 = i2;
            byArray2[n3] = (byte)(byArray2[n3] | by);
            by = (by2 & 0x80) == 0 ? (byte)0 : 1;
        }
        return byArray2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.c);
        objectOutputStream.writeObject(this.d);
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.f);
        objectOutputStream.writeObject(this.k);
        objectOutputStream.writeObject(this.l);
        objectOutputStream.writeObject(this.m);
        objectOutputStream.writeObject(this.n);
        objectOutputStream.writeObject(this.o);
        objectOutputStream.writeObject(this.p);
        objectOutputStream.writeObject(new Integer(this.q));
        objectOutputStream.writeObject(new Integer(this.r));
        objectOutputStream.writeObject(this.s);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (String)objectInputStream.readObject();
        this.b = (byte[])objectInputStream.readObject();
        this.c = (byte[])objectInputStream.readObject();
        this.d = (byte[])objectInputStream.readObject();
        this.e = (CryptoTransform)objectInputStream.readObject();
        this.f = (byte[])objectInputStream.readObject();
        this.k = (byte[])objectInputStream.readObject();
        this.l = (byte[])objectInputStream.readObject();
        this.m = (byte[])objectInputStream.readObject();
        this.n = (byte[])objectInputStream.readObject();
        this.o = (byte[])objectInputStream.readObject();
        this.p = (Integer)objectInputStream.readObject();
        this.q = (Integer)objectInputStream.readObject();
        this.r = (Integer)objectInputStream.readObject();
        this.s = (Random)objectInputStream.readObject();
    }
}

