/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.BlockCipherSpi;
import com.certicom.ecc.jcae.RNGSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.spec.GCMParameterSpec;
import com.certicom.ecc.system.CryptoManager;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.security.spec.AESParameterSpec;
import javax.security.spec.CCMSTARParameterSpec;

public class AESCipherSpi
extends BlockCipherSpi {
    protected int h = -1;

    public AESCipherSpi() {
        this((CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "AES"), "AES", -1);
    }

    public AESCipherSpi(int n2) {
        this((CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "AES"), "AES", n2);
    }

    public AESCipherSpi(CryptoTransform cryptoTransform, String string, int n2) {
        super(cryptoTransform, string);
        this.h = n2;
    }

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            this.a(key);
            return key.getEncoded().length * 8;
        }
        throw new InvalidKeyException("Invalid AES key.");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void a(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) throw new InvalidKeyException("wrong key");
        if (key == null) {
            throw new InvalidKeyException("wrong key");
        }
        this.a(key);
        byte[] byArray = key.getEncoded();
        if (this.e.equals("CCMSTAR")) {
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            if (!(algorithmParameterSpec instanceof CCMSTARParameterSpec)) throw new InvalidAlgorithmParameterException("wrong params");
            CCMSTARParameterSpec cCMSTARParameterSpec = (CCMSTARParameterSpec)algorithmParameterSpec;
            this.b[0] = "AES";
            this.b[1] = cCMSTARParameterSpec.getNonce();
            this.b[2] = cCMSTARParameterSpec.getAssociatedData();
            this.b[3] = byArray;
            this.b[4] = cCMSTARParameterSpec.getMacLength();
            return;
        }
        if (this.e.equals("GCM")) {
            if (algorithmParameterSpec == null) throw new InvalidAlgorithmParameterException("wrong params");
            if (!(algorithmParameterSpec instanceof GCMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            GCMParameterSpec gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
            this.b[0] = "AES";
            this.b[1] = gCMParameterSpec.getIV();
            this.b[2] = gCMParameterSpec.getAAD();
            this.b[3] = gCMParameterSpec.getTagLength();
            this.b[4] = byArray;
            return;
        }
        this.b[0] = this.e;
        this.b[1] = new Integer(128);
        this.b[2] = byArray;
        if (algorithmParameterSpec == null) {
            if (this.e.equals("ECB")) return;
            if (this.c == 4) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            byte[] byArray2 = new byte[this.engineGetBlockSize()];
            if (this.d == null) {
                RNGSpi.a().nextBytes(byArray2);
            } else {
                this.d.nextBytes(byArray2);
            }
            this.b[3] = byArray2;
            return;
        }
        if (algorithmParameterSpec instanceof AESParameterSpec) {
            AESParameterSpec aESParameterSpec = (AESParameterSpec)algorithmParameterSpec;
            Integer n2 = aESParameterSpec.getblockLen();
            this.b[1] = n2;
            if (!this.e.equalsIgnoreCase("ECB")) {
                this.b[3] = aESParameterSpec.getIV();
                return;
            }
            if (aESParameterSpec.getIV() == null) return;
            throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
        }
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("wrong params");
        if (this.e.equalsIgnoreCase("ECB")) {
            throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
        }
        if (this.e.equalsIgnoreCase("CTR")) {
            byte[] byArray3 = ((IvParameterSpec)algorithmParameterSpec).getIV();
            this.b[1] = new Integer(byArray3.length << 3);
            this.b[3] = byArray3;
            return;
        }
        this.b[3] = ((IvParameterSpec)algorithmParameterSpec).getIV();
    }

    protected final AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        this.e = this.e.toUpperCase();
        try {
            if (this.e.equals("CCMSTAR")) {
                algorithmParameters = AlgorithmParameters.getInstance("CCMSTAR", "Certicom");
                algorithmParameters.init(new CCMSTARParameterSpec((byte[])this.b[1], (byte[])this.b[2], (Integer)this.b[4]));
            } else if (this.e.equals("GCM")) {
                algorithmParameters = AlgorithmParameters.getInstance("GCM", "Certicom");
                algorithmParameters.init(new GCMParameterSpec((byte[])this.b[1], (byte[])this.b[2], (Integer)this.b[3]));
            } else {
                algorithmParameters = AlgorithmParameters.getInstance("AES", "Certicom");
                if (this.e.indexOf("ECB") != -1) {
                    return null;
                }
                if (this.e.indexOf("CFB") != -1 || this.e.indexOf("CTR") != -1) {
                    algorithmParameters.init(new AESParameterSpec((Integer)this.b[1], (byte[])this.b[3]));
                } else {
                    algorithmParameters.init(new AESParameterSpec((byte[])this.b[3]));
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return algorithmParameters;
    }

    protected void a(Key key) throws InvalidKeyException {
        int n2;
        String string = key.getAlgorithm();
        String string2 = AESCipherSpi.commonKeyVerification(string, this.h, n2 = key.getEncoded().length * 8);
        if (string2 != null) {
            throw new InvalidKeyException(string2);
        }
    }

    public static String commonKeyVerification(String string, int n2, int n3) {
        if (string.indexOf("AES") != 0) {
            return "Key must be AES";
        }
        String string2 = AESCipherSpi.commonKeyVerification(n2, n3);
        if (string2 != null) {
            return string2;
        }
        if (string.length() > 3) {
            if ("AES-128".equals(string) && n3 != 128) {
                return "128 bit key required";
            }
            if ("AES-192".equals(string) && n3 != 192) {
                return "192 bit key required";
            }
            if ("AES-256".equals(string) && n3 != 256) {
                return "256 bit key required";
            }
        }
        return null;
    }

    public static String commonKeyVerification(int n2, int n3) {
        if (n2 == -1) {
            if (n3 != 128 && n3 != 192 && n3 != 256) {
                return "key size must be 128,192 or 256";
            }
        } else if (n3 != n2) {
            return "key size must be " + n2;
        }
        return null;
    }
}

