/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.io.Serializable;
import java.util.ArrayList;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayParms;

public class DistributedArrayState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<DistributedArrayParms> _daParms = new ArrayList();

    public void add(DistributedArrayParms d) {
        this._daParms.add(d);
    }

    public void add(int ndim, Class classType, int elementCount, int[] lengths, int[] decompTypes) {
        this._daParms.add(new DistributedArrayParms(ndim, classType, elementCount, lengths, decompTypes));
    }

    public void add(int[] lengths) {
        int[] decompTypes = new int[lengths.length];
        for (int i = 0; i < lengths.length; ++i) {
            decompTypes[i] = Decomposition.NONE;
        }
        decompTypes[lengths.length - 1] = Decomposition.BLOCK;
        this._daParms.add(new DistributedArrayParms(lengths.length, Float.TYPE, 1, lengths, decompTypes));
    }

    public void add(int[] lengths, int decompType) {
        int[] decompTypes = new int[lengths.length];
        for (int i = 0; i < lengths.length; ++i) {
            decompTypes[i] = Decomposition.NONE;
        }
        decompTypes[lengths.length - 1] = decompType;
        this._daParms.add(new DistributedArrayParms(lengths.length, Float.TYPE, 1, lengths, decompTypes));
    }

    public void add(DistributedArray a) {
        this._daParms.add(new DistributedArrayParms(a.getDimensions(), a.getClassType(), a.getElementCount(), a.getShape(), a.getDecompTypes()));
    }

    public void remove(int index) {
        this._daParms.remove(index);
    }

    public int size() {
        return this._daParms.size();
    }

    public DistributedArrayParms get(int index) {
        return this._daParms.get(index);
    }

    public int getMaxDimensions() {
        int maxdim = 0;
        for (DistributedArrayParms d : this._daParms) {
            if (d.ndim <= maxdim) continue;
            maxdim = d.ndim;
        }
        return maxdim;
    }

    public long getMaxLocalLength(int numTasks) {
        long maxlen = 0L;
        for (DistributedArrayParms d : this._daParms) {
            long len = d.elementCount;
            for (int i = 0; i < d.ndim; ++i) {
                long tmp = Decomposition.paddedLength(d.lengths[i], numTasks);
                len *= tmp;
            }
            if (len <= maxlen) continue;
            maxlen = len;
        }
        long rem = maxlen % (long)numTasks;
        if (rem == 0L) {
            return maxlen / (long)numTasks;
        }
        return (maxlen + (long)numTasks - rem) / (long)numTasks;
    }
}

