/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayIterator;
import org.javaseis.util.ArrayUtil;

public class Aperture3dIterator
implements DistributedArrayIterator<float[][][]> {
    private static final Logger LOG = Logger.getLogger("org.javaseis.parallel");
    private DistributedArray _distributedArray;
    private float[][][] _aperture;
    private int _currentInline = 0;
    private int _currentCrossline = 0;
    private int _nCrosslines;
    private int _nInlines;
    private int _halfWidthInlines;
    private int _halfWidthCrosslines;
    private int[] _localPosition;
    private int[] _activeLocalShape;
    private int[] _tracePosition;
    private LinkedList<TracePositionPair> _traceList;
    private int _maxTraceListSize;
    private boolean[][] _apertureTraceIsFilled;
    private int[][] _apertureTracePosition2;
    private int[][] _apertureTracePosition1;
    private int _nExchanged = 0;
    private int _nFetched = 0;

    public static void isInsideEllipse(boolean[][] insideEllipse) {
        int nFramesOperator = insideEllipse.length;
        int nTracesOperator = insideEllipse[0].length;
        int centralFrameIndex = nFramesOperator / 2;
        int centralTraceIndex = nTracesOperator / 2;
        double a = centralFrameIndex;
        double b = centralTraceIndex;
        if (a == 0.0 || b == 0.0) {
            for (int k = 0; k < nFramesOperator; ++k) {
                for (int j = 0; j < nTracesOperator; ++j) {
                    insideEllipse[k][j] = true;
                }
            }
            return;
        }
        double ab = a * b;
        double aSquared = a * a;
        double bSquared = b * b;
        for (int k = 0; k < nFramesOperator; ++k) {
            double distanceX = k - centralFrameIndex;
            for (int j = 0; j < nTracesOperator; ++j) {
                double cosAngleSquared;
                double distanceY = j - centralTraceIndex;
                double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
                double angle = Math.atan2(distanceY, distanceX);
                double cosAngle = Math.cos(angle);
                double sinAngle = Math.sin(angle);
                double sinAngleSquared = sinAngle * sinAngle;
                double ellipseRadius = ab / Math.sqrt(aSquared * sinAngleSquared + bSquared * (cosAngleSquared = cosAngle * cosAngle));
                insideEllipse[k][j] = distance <= ellipseRadius;
            }
        }
    }

    public Aperture3dIterator(DistributedArray distributedArray, float[][][] aperture) {
        if (distributedArray == null || aperture == null) {
            throw new IllegalArgumentException("null arguments are not allowed");
        }
        if (aperture.length % 2 == 0 || aperture[0].length % 2 == 0) {
            throw new IllegalArgumentException("aperture must have odd number of traces in both directions");
        }
        this._halfWidthInlines = aperture.length / 2;
        this._halfWidthCrosslines = aperture[0].length / 2;
        this._distributedArray = distributedArray;
        this._aperture = aperture;
        this.init(distributedArray, aperture);
    }

    private void init(DistributedArray distributedArray, float[][][] aperture) {
        this._apertureTraceIsFilled = new boolean[aperture.length][aperture[0].length];
        this._apertureTracePosition2 = new int[aperture.length][aperture[0].length];
        this._apertureTracePosition1 = new int[aperture.length][aperture[0].length];
        for (int ja = 0; ja < this._apertureTracePosition2.length; ++ja) {
            for (int ia = 0; ia < this._apertureTracePosition2[ja].length; ++ia) {
                this._apertureTracePosition2[ja][ia] = Integer.MIN_VALUE;
                this._apertureTracePosition1[ja][ia] = Integer.MIN_VALUE;
            }
        }
        this._activeLocalShape = distributedArray.getLocalShape();
        this._activeLocalShape[0] = distributedArray.getLocalLength(0);
        this._activeLocalShape[1] = distributedArray.getLocalLength(1);
        this._activeLocalShape[2] = distributedArray.getLocalLength(2);
        this._nInlines = this._activeLocalShape[2];
        this._nCrosslines = this._activeLocalShape[1];
        this._tracePosition = new int[distributedArray.getDimensions()];
        this._localPosition = new int[distributedArray.getDimensions()];
        this._maxTraceListSize = this._nCrosslines * (this._halfWidthInlines + 1);
    }

    @Override
    public boolean hasNext() {
        return this._currentInline < this._nInlines;
    }

    @Override
    public float[][][] next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Attempt to use next() after hasNext() returns false");
        }
        RuntimeException re = null;
        try {
            this.getData();
        }
        catch (RuntimeException e) {
            re = e;
        }
        ++this._currentCrossline;
        if (this._currentCrossline >= this._nCrosslines) {
            this._currentCrossline = 0;
            ++this._currentInline;
        }
        if (re != null) {
            throw re;
        }
        return this._aperture;
    }

    private void getData() {
        int ia;
        int ja;
        int crosslineEnd;
        int inlineEnd;
        this._localPosition[0] = 0;
        this._localPosition[1] = this._currentCrossline;
        this._localPosition[2] = this._currentInline;
        int inlineAperStart = 0;
        int inlineStart = this._currentInline - this._halfWidthInlines;
        if (inlineStart < 0) {
            inlineAperStart = 0 - inlineStart;
            inlineStart = 0;
        }
        if ((inlineEnd = this._currentInline + this._halfWidthInlines) > this._activeLocalShape[2] - 1) {
            inlineEnd = this._activeLocalShape[2] - 1;
        }
        int crosslineAperStart = 0;
        int crosslineStart = this._currentCrossline - this._halfWidthCrosslines;
        if (crosslineStart < 0) {
            crosslineAperStart = 0 - crosslineStart;
            crosslineStart = 0;
        }
        if ((crosslineEnd = this._currentCrossline + this._halfWidthCrosslines) > this._activeLocalShape[1] - 1) {
            crosslineEnd = this._activeLocalShape[1] - 1;
        }
        for (ja = 0; ja < this._apertureTraceIsFilled.length; ++ja) {
            for (ia = 0; ia < this._apertureTraceIsFilled[ja].length; ++ia) {
                this._apertureTraceIsFilled[ja][ia] = false;
            }
        }
        int crosslineAperEnd = crosslineAperStart + (crosslineEnd - crosslineStart);
        int jt = inlineStart;
        ja = inlineAperStart;
        while (jt <= inlineEnd) {
            this._tracePosition[2] = this._distributedArray.localToGlobal(2, jt);
            int it = crosslineStart;
            ia = crosslineAperStart;
            while (it <= crosslineEnd) {
                this._tracePosition[1] = this._distributedArray.localToGlobal(1, it);
                if (ia < crosslineAperEnd && this._apertureTracePosition2[ja][ia + 1] == this._tracePosition[2] && this._apertureTracePosition1[ja][ia + 1] == this._tracePosition[1]) {
                    float[] traceSave = this._aperture[ja][ia];
                    this._aperture[ja][ia] = this._aperture[ja][ia + 1];
                    this._aperture[ja][ia + 1] = traceSave;
                    this._apertureTracePosition2[ja][ia + 1] = this._apertureTracePosition2[ja][ia];
                    this._apertureTracePosition1[ja][ia + 1] = this._apertureTracePosition1[ja][ia];
                    ++this._nExchanged;
                } else {
                    this._distributedArray.getTrace(this._aperture[ja][ia], this._tracePosition);
                    ++this._nFetched;
                }
                this._apertureTracePosition2[ja][ia] = this._tracePosition[2];
                this._apertureTracePosition1[ja][ia] = this._tracePosition[1];
                this._apertureTraceIsFilled[ja][ia] = true;
                ++it;
                ++ia;
            }
            ++jt;
            ++ja;
        }
        for (ja = 0; ja < this._aperture.length; ++ja) {
            for (ia = 0; ia < this._aperture[ja].length; ++ia) {
                if (this._apertureTraceIsFilled[ja][ia]) continue;
                Arrays.fill(this._aperture[ja][ia], 0.0f);
                this._apertureTracePosition2[ja][ia] = Integer.MIN_VALUE;
                this._apertureTracePosition1[ja][ia] = Integer.MIN_VALUE;
            }
        }
    }

    public int[] getLocalPosition() {
        return this._localPosition;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this._distributedArray.localToGlobal(0, this._localPosition[0]), this._distributedArray.localToGlobal(1, this._localPosition[1]), this._distributedArray.localToGlobal(2, this._localPosition[2])};
    }

    public void putData(float[] trace) throws RuntimeException {
        TracePositionPair tracePositionPair;
        if (this._traceList == null) {
            this._traceList = new LinkedList();
        }
        if (this._traceList.size() >= this._maxTraceListSize) {
            tracePositionPair = this._traceList.removeFirst();
            this._distributedArray.putTrace(tracePositionPair.trace, tracePositionPair.tracePosition);
            tracePositionPair.reset(trace, this._distributedArray, this._localPosition);
        } else {
            tracePositionPair = new TracePositionPair(trace, this._distributedArray, this._localPosition);
        }
        this._traceList.addLast(tracePositionPair);
    }

    public void flushData() {
        if (this._traceList == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("nExchanged= " + this._nExchanged);
            LOG.fine("nFetched= " + this._nFetched);
        }
        int nTraces = this._traceList.size();
        for (int i = 0; i < nTraces; ++i) {
            TracePositionPair tracePositionPair = this._traceList.removeFirst();
            this._distributedArray.putTrace(tracePositionPair.trace, tracePositionPair.tracePosition);
        }
        this._traceList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this._traceList != null) {
                LOG.severe("Aperture3DIterator " + this.toString() + " was not flushed before it was garbage collected");
                this.flushData();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }

    @Override
    public void reset() {
        this.init(this._distributedArray, this._aperture);
    }

    private class TracePositionPair {
        public float[] trace;
        public int[] tracePosition;

        public TracePositionPair(float[] inputTrace, DistributedArray distributedArray, int[] localPosition) {
            this.trace = new float[inputTrace.length];
            this.tracePosition = new int[3];
            this.reset(inputTrace, distributedArray, localPosition);
        }

        public void reset(float[] inputTrace, DistributedArray distributedArray, int[] localPosition) {
            ArrayUtil.arraycopy(inputTrace, 0, this.trace, 0, inputTrace.length);
            this.tracePosition[1] = distributedArray.localToGlobal(1, localPosition[1]);
            this.tracePosition[2] = distributedArray.localToGlobal(2, localPosition[2]);
        }
    }
}

