/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.parallel;

import java.util.Iterator;
import java.util.logging.Logger;

public class Aperture2dIterator
implements Iterator<float[][]> {
    private static final Logger LOG = Logger.getLogger(Aperture2dIterator.class.getName());
    private final float[][] _data;
    private final float[][] _aperture;
    private int _currentTrace = 0;
    private int _currentSample = 0;
    private final int _nSamples;
    private final int _nTraces;
    private final int _halfWidthTraces;
    private final int _halfWidthSamples;
    private final int[] _localPosition = new int[2];

    public Aperture2dIterator(float[][] data, float[][] aperture) {
        if (data == null) {
            throw new NullPointerException("data array is null");
        }
        if (aperture == null) {
            throw new NullPointerException("aperture array is null");
        }
        if (aperture.length % 2 == 0 || aperture[0].length % 2 == 0) {
            throw new IllegalArgumentException("aperture must have odd number of samples in both directions");
        }
        this._halfWidthTraces = aperture.length / 2;
        this._halfWidthSamples = aperture[0].length / 2;
        this._data = data;
        this._aperture = aperture;
        this._nTraces = data.length;
        this._nSamples = data[0].length;
    }

    @Override
    public boolean hasNext() {
        return this._currentTrace < this._nTraces;
    }

    @Override
    public float[][] next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Attempt to use next() after hasNext() returns false");
        }
        RuntimeException re = null;
        try {
            this.getData();
        }
        catch (RuntimeException e) {
            re = e;
        }
        ++this._currentSample;
        if (this._currentSample >= this._nSamples) {
            this._currentSample = 0;
            ++this._currentTrace;
        }
        if (re != null) {
            throw re;
        }
        return this._aperture;
    }

    private void getData() {
        int sampleEnd;
        int traceEnd;
        this._localPosition[0] = this._currentSample;
        this._localPosition[1] = this._currentTrace;
        int traceAperStart = 0;
        int traceStart = this._currentTrace - this._halfWidthTraces;
        if (traceStart < 0) {
            traceAperStart = 0 - traceStart;
            traceStart = 0;
        }
        if ((traceEnd = this._currentTrace + this._halfWidthTraces) > this._data.length - 1) {
            traceEnd = this._data.length - 1;
        }
        int sampleAperStart = 0;
        int sampleStart = this._currentSample - this._halfWidthSamples;
        if (sampleStart < 0) {
            sampleAperStart = 0 - sampleStart;
            sampleStart = 0;
        }
        if ((sampleEnd = this._currentSample + this._halfWidthSamples) > this._data[0].length - 1) {
            sampleEnd = this._data[0].length - 1;
        }
        int nj = this._aperture.length;
        for (int ja = 0; ja < nj; ++ja) {
            int ni = this._aperture[ja].length;
            for (int ia = 0; ia < ni; ++ia) {
                this._aperture[ja][ia] = 0.0f;
            }
        }
        int jt = traceStart;
        int ja = traceAperStart;
        while (jt <= traceEnd) {
            int it = sampleStart;
            int ia = sampleAperStart;
            while (it <= sampleEnd) {
                this._aperture[ja][ia] = this._data[jt][it];
                ++it;
                ++ia;
            }
            ++jt;
            ++ja;
        }
    }

    public int[] getPosition() {
        return this._localPosition;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Optional method Iterator.remove() is not implemented");
    }

    private static void sanityTests() {
        for (int nFrames = 1; nFrames <= 20; ++nFrames) {
            for (int nTraces = 1; nTraces <= 20; ++nTraces) {
                float[][] data = new float[nFrames][nTraces];
                for (int j = 0; j < data.length; ++j) {
                    for (int i = 0; i < data[j].length; ++i) {
                        data[j][i] = 10.0f;
                    }
                }
                for (int width = 1; width <= 11; width += 2) {
                    for (int height = 1; height <= 11; height += 2) {
                        float[][] ap;
                        float[][] aperture = new float[width][height];
                        Aperture2dIterator it = new Aperture2dIterator(data, aperture);
                        int count = 0;
                        while (it.hasNext()) {
                            ap = it.next();
                            ++count;
                        }
                        assert (count == nFrames * nTraces);
                        it = new Aperture2dIterator(data, aperture);
                        while (it.hasNext()) {
                            ap = it.next();
                            count = 0;
                            float sum = 0.0f;
                            int nj = ap.length;
                            for (int j = 0; j < nj; ++j) {
                                int ni = ap[j].length;
                                for (int i = 0; i < ni; ++i) {
                                    if (ap[j][i] == 0.0f) continue;
                                    sum += ap[j][i];
                                    ++count;
                                }
                            }
                            assert (count > 0);
                            assert (sum / (float)count == 10.0f);
                        }
                    }
                }
            }
        }
        LOG.info("org.javaseis.parallel.Aperture2dIterator.sanityTests ***** SUCCESS *****");
    }

    public static void main(String[] args) {
        Aperture2dIterator.sanityTests();
    }
}

