/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.javaseis.io.SortIOParms;
import org.javaseis.io.SortMapIO;

public class JTestSortMapIO3D
extends TestCase {
    private static final Logger LOG = Logger.getLogger(JTestSortMapIO3D.class.getName());

    public static SortIOParms createParms(String basePath, String sortMapName, int frames, int tpf) throws IOException {
        SortIOParms parms = new SortIOParms();
        parms.sort3_secondary = "NONE";
        parms.sort3_tertiary = "NONE";
        parms.volumes = 1;
        parms.framesPerVolume = frames;
        parms.tracesPerFrame = tpf;
        parms.tracesInSort = frames * tpf;
        parms.minLogVol = 0;
        parms.maxLogVol = 1;
        parms.minLogFrm = 1;
        parms.maxLogFrm = frames;
        parms.minLogTrc = 1;
        parms.maxLogTrc = tpf;
        parms.label4 = "NONE";
        parms.label3 = "ILINE_NO";
        parms.label2 = "XLINE_NO";
        SortMapIO.writeparms(basePath, sortMapName, parms);
        return parms;
    }

    public void testSMCreate() throws IOException {
        File out = File.createTempFile("sortmap_test_3d", ".js");
        out.delete();
        out.mkdir();
        String basePath = out.getAbsolutePath();
        String sortmapName = System.currentTimeMillis() + "";
        int nFrames = 3;
        int ntracesPerFrame = 97;
        SortIOParms parms = JTestSortMapIO3D.createParms(basePath, sortmapName, nFrames, ntracesPerFrame);
        JTestSortMapIO3D.write(basePath, sortmapName, 0, 2, ntracesPerFrame);
        JTestSortMapIO3D.writeVolumeWrapper(basePath, sortmapName, nFrames);
        LOG.info("path=" + out.getAbsolutePath());
        JTestSortMapIO3D.validate(basePath, sortmapName, parms);
        SortMapIO.delete(basePath);
        new File(basePath).delete();
    }

    public static void write(String basePath, String sortmapName, int iMinFrm, int iMaxFrm, int nTracesPerFrame) throws IOException {
        SortMapIO smio = new SortMapIO(basePath, sortmapName);
        smio.open("w");
        long[] _traceList = smio.getCurrentTraceList();
        for (int ifrm = iMinFrm; ifrm <= iMaxFrm; ++ifrm) {
            int locialFrame = ifrm + 1;
            smio.appendFrame(ifrm, locialFrame, nTracesPerFrame);
            for (int i = 0; i < nTracesPerFrame; ++i) {
                long index;
                _traceList[i] = index = (long)ifrm * (long)nTracesPerFrame + (long)i;
            }
            smio.writeTraceMap(nTracesPerFrame, 0, ifrm);
        }
        smio.writeFrameMap(iMinFrm, iMaxFrm - iMinFrm + 1, 0);
        smio.close();
    }

    public static void writeVolumeWrapper(String basePath, String sortmapName, int nFrames) throws IOException {
        SortMapIO smio = new SortMapIO(basePath, sortmapName);
        smio.open("w");
        smio.appendVolume(0, 0, nFrames);
        smio.writeVolumeMap(1, 0);
        smio.close();
    }

    public static void validateParms(SortIOParms parms, SortIOParms parms2) throws IOException {
        JTestSortMapIO3D.assertTrue((boolean)parms2.sort3_secondary.equalsIgnoreCase(parms.sort3_secondary));
        JTestSortMapIO3D.assertTrue((boolean)parms2.sort3_tertiary.equalsIgnoreCase(parms.sort3_tertiary));
        JTestSortMapIO3D.assertTrue((parms2.volumes == parms.volumes ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.framesPerVolume == parms.framesPerVolume ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.tracesPerFrame == parms.tracesPerFrame ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.tracesInSort == parms.tracesInSort ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.minLogVol == parms.minLogVol ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.maxLogVol == parms.maxLogVol ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.minLogFrm == parms.minLogFrm ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.maxLogFrm == parms.maxLogFrm ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.minLogTrc == parms.minLogTrc ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.maxLogTrc == parms.maxLogTrc ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((boolean)parms2.label4.equalsIgnoreCase(parms.label4));
        JTestSortMapIO3D.assertTrue((boolean)parms2.label3.equalsIgnoreCase(parms.label3));
        JTestSortMapIO3D.assertTrue((boolean)parms2.label2.equalsIgnoreCase(parms.label2));
        JTestSortMapIO3D.assertTrue((parms.getDimensions() == 3 ? 1 : 0) != 0);
        JTestSortMapIO3D.assertTrue((parms2.getDimensions() == parms.getDimensions() ? 1 : 0) != 0);
    }

    public static void validate(String basePath, String sortMapName, SortIOParms parms) throws IOException {
        SortMapIO smio = new SortMapIO(basePath, sortMapName);
        SortIOParms parms2 = smio.getParms();
        JTestSortMapIO3D.validateParms(parms, parms2);
        smio.open("r");
        int nFramesPerVolume = parms2.maxLogFrm - parms2.minLogFrm + 1;
        int nTracesPerFrame = parms2.tracesPerFrame;
        long counter = 0L;
        for (int ifrm = 0; ifrm < nFramesPerVolume; ++ifrm) {
            int tracesInFrame = smio.setFrame(ifrm);
            if (tracesInFrame != nTracesPerFrame) {
                System.out.println("tracesInFrame=" + tracesInFrame + " nTracesPerFrame=" + nTracesPerFrame);
            }
            JTestSortMapIO3D.assertTrue((tracesInFrame == nTracesPerFrame ? 1 : 0) != 0);
            for (int i = 0; i < tracesInFrame; ++i) {
                long[] traceList = smio.getCurrentTraceList();
                JTestSortMapIO3D.assertTrue((traceList[i] == counter++ ? 1 : 0) != 0);
            }
        }
        smio.close();
    }

    public static void main(String[] args) throws IOException {
        new JTestSortMapIO3D().testSMCreate();
    }
}

