/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Iterator;
import org.javaseis.array.IMultiArray;

public class MultiArrayPositionIterator
implements Iterable,
Iterator<int[]> {
    private int _hypercubeIndex;
    private int _volumeIndex;
    private int _frameIndex;
    private int _traceIndex;
    private IMultiArray _seismicArray;
    private int _nHypercubes;
    private int _nVolumes;
    private int _nFrames;
    private int _nTraces;
    private int[] _position;
    private int[] _shape;
    private static int FORWARD = 1;
    private static int REVERSE = -1;
    private int _incr = FORWARD;

    public MultiArrayPositionIterator(IMultiArray multiArray, int[] position) {
        if (multiArray == null) {
            throw new IllegalArgumentException("seismicArray is null");
        }
        if (position == null) {
            throw new IllegalArgumentException("position is null");
        }
        this._seismicArray = multiArray;
        this._position = position;
        if (this._position.length < multiArray.getDimensions()) {
            String message = String.format("position.length, dimensions mismatch (%d vs. %d)", position.length, multiArray.getDimensions());
            throw new IllegalArgumentException(message);
        }
        this._shape = multiArray.getShape();
        this._nHypercubes = this._shape.length > 4 ? this._shape[4] : 1;
        this._nVolumes = this._shape.length > 3 ? this._shape[3] : 1;
        this._nFrames = this._shape.length > 2 ? this._shape[2] : 1;
        this._nTraces = this._shape[1];
        this._hypercubeIndex = 0;
        this._volumeIndex = 0;
        this._frameIndex = 0;
        this._traceIndex = 0;
    }

    public MultiArrayPositionIterator(IMultiArray multiArray, int[] position, int direction) {
        this(multiArray, position);
        if (direction == REVERSE) {
            this._incr = REVERSE;
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex = this._nVolumes - 1;
            this._hypercubeIndex = this._nHypercubes - 1;
            this._incr = REVERSE;
        } else {
            this._incr = FORWARD;
        }
    }

    @Override
    public final boolean hasNext() {
        return this._hypercubeIndex < this._nHypercubes && this._hypercubeIndex >= 0;
    }

    @Override
    public final int[] next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Attempt to use next() after hasNext() returns false");
        }
        if (this._shape.length > 4) {
            this._position[4] = this._hypercubeIndex;
        }
        if (this._shape.length > 3) {
            this._position[3] = this._volumeIndex;
        }
        if (this._shape.length > 2) {
            this._position[2] = this._frameIndex;
        }
        this._position[1] = this._traceIndex;
        this._position[0] = 0;
        this._traceIndex += this._incr;
        if (this._traceIndex >= this._nTraces) {
            this._traceIndex = 0;
            this._frameIndex += this._incr;
        } else if (this._traceIndex < 0) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex += this._incr;
        }
        if (this._frameIndex >= this._nFrames) {
            this._traceIndex = 0;
            this._frameIndex = 0;
            this._volumeIndex += this._incr;
        } else if (this._frameIndex < 0) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex += this._incr;
        }
        if (this._volumeIndex >= this._nVolumes) {
            this._traceIndex = 0;
            this._frameIndex = 0;
            this._volumeIndex = 0;
            this._hypercubeIndex += this._incr;
        } else if (this._volumeIndex < 0) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex = this._nVolumes - 1;
            this._hypercubeIndex += this._incr;
        }
        return this._position;
    }

    public void reset() {
        this._shape = this._seismicArray.getShape();
        this._nHypercubes = this._shape.length > 4 ? this._shape[4] : 1;
        this._nVolumes = this._shape.length > 3 ? this._shape[3] : 1;
        this._nFrames = this._shape.length > 2 ? this._shape[2] : 1;
        this._nTraces = this._shape.length > 1 ? this._shape[1] : 1;
        if (this._incr == REVERSE) {
            this._traceIndex = this._nTraces - 1;
            this._frameIndex = this._nFrames - 1;
            this._volumeIndex = this._nVolumes - 1;
            this._hypercubeIndex = this._nHypercubes - 1;
        } else {
            this._traceIndex = 0;
            this._frameIndex = 0;
            this._volumeIndex = 0;
            this._hypercubeIndex = 0;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }

    public Iterator iterator() {
        return new MultiArrayPositionIterator(this._seismicArray, this._position);
    }
}

