/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public abstract class CryptoTransform
implements Serializable {
    private static final long serialVersionUID = 3116024283635909639L;
    public static final int UNINIT = 0;
    public static final int SIGN = 1;
    public static final int VERIFY = 2;
    public static final int ENCRYPT = 3;
    public static final int DECRYPT = 4;
    public static final int GENKEY = 5;
    public static final int RAW = 6;
    public static final int KDF = 7;
    public static final int ECQV_SERVER = 8;
    public static final int ECQV_CA = 9;
    public static final int ECQV_USER = 10;
    public static final Class TYPE;
    protected Random g = null;
    protected int h = 0;
    protected String i = null;
    public static final int HASH_GLOBAL = 0;
    public static final int HASH_NONE = 1;
    public static final int HASH_ALG = 2;
    private int a = 0;
    private static boolean failVerifyOpResult;
    protected int j;
    private byte[] b;

    protected CryptoTransform(CryptoTransform cryptoTransform) {
        this.g = cryptoTransform.g;
        this.h = cryptoTransform.h;
        this.i = cryptoTransform.i;
        this.a = cryptoTransform.a;
        this.j = cryptoTransform.j;
    }

    protected CryptoTransform(String string) {
        this.i = string;
        SystemConfig systemConfig = SystemConfig.getConfig();
        this.j = systemConfig.getConformance();
    }

    public void setConformance(int n2) {
        this.j = n2;
    }

    public int getConformance() {
        return this.j;
    }

    public int getHashMode() {
        if (this.a == 0) {
            int n2 = SystemConfig.getConfig().getHashType();
            switch (n2) {
                case 17: {
                    return 2;
                }
                case 18: {
                    return 1;
                }
            }
        }
        return this.a;
    }

    public void setHashMode(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.a = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid hash mode");
            }
        }
    }

    public void reset() {
        this.h = 0;
        this.g = null;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.h = n2;
        this.g = random;
    }

    public abstract int transform(byte[] var1, int var2, int var3, byte[] var4, int var5, boolean var6) throws IllegalArgumentException, IllegalStateException;

    public byte[] transform(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        int n4 = this.outputSize(n3, bl);
        if (n4 > 0) {
            this.b = new byte[n4];
            n4 = this.transform(byArray, n2, n3, this.b, 0, bl);
            if (n4 < this.b.length) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.b, 0, byArray2, 0, n4);
                return byArray2;
            }
            return this.b;
        }
        this.transform(byArray, n2, n3, null, 0, bl);
        return null;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return this.transform(byArray, n2, n3, bl);
    }

    public int inputSize() {
        return 0;
    }

    public abstract int outputSize(int var1, boolean var2) throws IllegalStateException;

    public boolean hasInterData() {
        return false;
    }

    public boolean isIncremental() {
        return true;
    }

    public String getAlgorithm() {
        return this.i;
    }

    public int getMode() {
        return this.h;
    }

    public boolean isVerifiable() {
        return false;
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        return false;
    }

    protected boolean a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl, int n5) {
        return true;
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, byte[] byArray2) {
        return true;
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Clone is not supported by this object");
    }

    protected final boolean g() {
        return failVerifyOpResult;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.g);
        objectOutputStream.writeObject(new Integer(this.h));
        objectOutputStream.writeObject(this.i);
        objectOutputStream.writeObject(new Integer(this.a));
        objectOutputStream.writeObject(new Integer(this.j));
        objectOutputStream.writeObject(this.b);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.g = (Random)objectInputStream.readObject();
        this.h = (Integer)objectInputStream.readObject();
        this.i = (String)objectInputStream.readObject();
        this.a = (Integer)objectInputStream.readObject();
        this.j = (Integer)objectInputStream.readObject();
        this.b = (byte[])objectInputStream.readObject();
    }

    static {
        failVerifyOpResult = false;
        try {
            TYPE = Class.forName("com.certicom.ecc.scheme.CryptoTransform");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException();
        }
    }
}

