/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.wavelet;

import java.io.Serializable;
import java.util.Arrays;
import org.javaseis.util.ArrayUtil;

public class Window1D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int n;
    private int nw;
    private int nwin;
    private int nov;
    private int nwm;
    private int wtype;
    private int stype;
    private float[][] weight;
    public static final int FORWARD = 0;
    public static final int INVERSE = 1;
    public static final int SYMMETRIC = 2;
    public static final int TRAPEZOID = 0;
    public static final int COSINE = 1;
    public static final int ITERSINE = 2;

    public Window1D(int numSamples, float sampleRate, float windowLength, float windowOverlap) throws IllegalArgumentException {
        int windowLengthSamples = (int)Math.rint(windowLength / sampleRate);
        int windowOverlapSamples = (int)Math.rint(windowOverlap / sampleRate);
        this.initializeWindow1D(numSamples, windowLengthSamples, windowOverlapSamples, 0, 0);
    }

    public Window1D(int numSamples, int windowLength, int windowOverlap) throws IllegalArgumentException {
        this.initializeWindow1D(numSamples, windowLength, windowOverlap, 0, 0);
    }

    public Window1D(int numSamples, int windowLength, int windowOverlap, int windowType, int scaleType) throws IllegalArgumentException {
        this.initializeWindow1D(numSamples, windowLength, windowOverlap, windowType, scaleType);
    }

    public void initializeWindow1D(int length, int windowLength, int windowOverlap, int windowType, int scaleType) throws IllegalArgumentException {
        this.wtype = windowType == 1 ? 1 : (windowType == 2 ? 2 : 0);
        this.stype = scaleType == 1 ? 1 : (scaleType == 2 ? 2 : 0);
        this.n = length;
        this.nw = windowLength;
        this.nov = windowOverlap;
        this.nwm = this.nw - 2 * this.nov;
        if (this.nwm < 0) {
            throw new IllegalArgumentException(String.format("Window overlap %d exceeds window length %d", windowOverlap, windowLength));
        }
        if (this.n > this.nov) {
            this.nwin = 1 + (this.n - this.nwm) / (this.nwm + this.nov);
            if ((this.n - this.nwm) % (this.nwm + this.nov) != 0) {
                ++this.nwin;
            }
        } else {
            this.nwin = 1;
        }
        this.initializeWeights();
    }

    public void windowForward(float[] x, float[][] wx) {
        if (x.length < this.n) {
            throw new IllegalArgumentException("Input array length is less than Window1D length");
        }
        if (wx.length < this.nwin || wx[0].length < this.nw) {
            throw new IllegalArgumentException("Output array is too short for windowed data");
        }
        for (int iwin = 0; iwin < this.nwin; ++iwin) {
            this.getWindowSamples(x, iwin, wx[iwin]);
        }
    }

    public void windowForward(float[] x, float[] wx) {
        if (x.length < this.n) {
            throw new IllegalArgumentException("Input array length is less than Window1D length");
        }
        if (wx.length < this.nw * this.nwin) {
            throw new IllegalArgumentException("Output array is too short for windowed data");
        }
        float[] w = new float[this.nw];
        int k = 0;
        for (int iwin = 0; iwin < this.nwin; ++iwin) {
            this.getWindowSamples(x, iwin, w);
            ArrayUtil.arraycopy(w, 0, wx, k, this.nw);
            k += this.nw;
        }
    }

    public void windowInverse(float[][] wx, float[] xo) {
        if (wx.length < this.nwin || wx[0].length < this.nw) {
            throw new IllegalArgumentException("Input array shape does not match Window1D shape");
        }
        if (xo.length < this.n) {
            throw new IllegalArgumentException("Output array length is less than Window1D length");
        }
        Arrays.fill(xo, 0.0f);
        for (int iwin = 0; iwin < this.nwin; ++iwin) {
            this.putWindowSamples(wx[iwin], iwin, xo);
        }
    }

    public void windowInverse(float[] wx, float[] xo) {
        if (xo.length < this.n) {
            throw new IllegalArgumentException("Output array length is less than Window1D length");
        }
        if (wx.length < this.nw * this.nwin) {
            throw new IllegalArgumentException("Input array is too short for windowed data");
        }
        Arrays.fill(xo, 0.0f);
        float[] w = new float[this.nw];
        int k = 0;
        for (int iwin = 0; iwin < this.nwin; ++iwin) {
            ArrayUtil.arraycopy(wx, k, w, 0, this.nw);
            k += this.nw;
            this.putWindowSamples(w, iwin, xo);
        }
    }

    public int getWindowSamples(float[] x, int iwin, float[] wx) {
        return this.getWindowSamples(x, iwin, wx, 0);
    }

    public int getWindowSamples(float[] x, int iwin, float[] wx, int offset) {
        int j;
        int[] iw = this.getWindowRange(iwin);
        int ix = offset;
        if (this.stype == 1) {
            for (j = iw[0]; j <= iw[1]; ++j) {
                wx[ix] = x[j];
                ++ix;
            }
        } else {
            float[] wt = this.windowWeights(iwin);
            for (int j2 = iw[0]; j2 <= iw[1]; ++j2) {
                wx[ix] = wt[ix] * x[j2];
                ++ix;
            }
        }
        for (j = ix; j < this.nw + offset; ++j) {
            wx[j] = 0.0f;
        }
        return iw[1] - iw[0] + 1;
    }

    public void putWindowSamples(float[] wx, int iwin, float[] xo) {
        this.putWindowSamples(wx, 0, iwin, xo);
    }

    public void putWindowSamples(float[] wx, int offset, int iwin, float[] xo) {
        int[] iw = this.getWindowRange(iwin);
        if (this.stype == 0) {
            int j = offset;
            for (int i = iw[0]; i <= iw[1]; ++i) {
                xo[i] = xo[i] + wx[j];
                ++j;
            }
        } else {
            float[] wt = this.windowWeights(iwin);
            int j = offset;
            for (int i = iw[0]; i <= iw[1]; ++i) {
                xo[i] = xo[i] + wt[j] * wx[j];
                ++j;
            }
        }
    }

    public int[] getWindowRange(int iwin) {
        int[] iw = new int[]{0, 0};
        if (iwin == 0) {
            iw[0] = 0;
            iw[1] = this.nwm + this.nov - 1;
        } else if (iwin < this.nwin) {
            iw[0] = this.nwm + (this.nwm + this.nov) * (iwin - 1);
            iw[1] = iw[0] + this.nw - 1;
        }
        if (iw[1] >= this.n) {
            iw[1] = this.n - 1;
        }
        return iw;
    }

    public float[] getWindowWeights(int iwin) {
        if (iwin == 0) {
            return (float[])this.weight[0].clone();
        }
        return (float[])this.weight[1].clone();
    }

    private float[] windowWeights(int iwin) {
        if (iwin == 0) {
            return this.weight[0];
        }
        return this.weight[1];
    }

    private void initializeWeights() {
        this.weight = new float[2][this.nw];
        if (this.wtype == 1) {
            this.setCosineWeights(0);
            this.setCosineWeights(1);
        } else if (this.wtype == 2) {
            this.setIteratedSineWeights(0);
            this.setIteratedSineWeights(1);
        } else {
            this.setTrapezoidWeights(0);
            this.setTrapezoidWeights(1);
        }
    }

    private void setCosineWeights(int iwin) {
        int i;
        float fact = (float)(1.5707963267948966 / (double)(this.nov + 1));
        int j = 0;
        if (iwin > 0) {
            for (i = 1; i <= this.nov; ++i) {
                this.weight[iwin][j] = (float)Math.sin(fact * (float)i);
                ++j;
            }
        }
        for (i = 0; i < this.nwm; ++i) {
            this.weight[iwin][j] = 1.0f;
            ++j;
        }
        for (i = 1; i <= this.nov; ++i) {
            this.weight[iwin][j] = (float)Math.cos(fact * (float)i);
            ++j;
        }
        if (iwin == 0) {
            for (i = 1; i <= this.nov; ++i) {
                this.weight[iwin][j] = 0.0f;
                ++j;
            }
        }
        if (this.stype == 2) {
            return;
        }
        for (i = 0; i < this.nw; ++i) {
            this.weight[iwin][i] = this.weight[iwin][i] * this.weight[iwin][i];
        }
    }

    private void setIteratedSineWeights(int iwin) {
        int i;
        double piov4 = 0.7853981633974483;
        double domega = Math.PI / (double)(this.nov + 1);
        int j = 0;
        double omega = -1.5707963267948966;
        if (iwin > 0) {
            for (i = 1; i <= this.nov; ++i) {
                this.weight[iwin][j] = (float)Math.sin(piov4 * (1.0 + Math.sin(omega += domega)));
                ++j;
            }
        }
        for (i = 0; i < this.nwm; ++i) {
            this.weight[iwin][j] = 1.0f;
            ++j;
        }
        omega = 1.5707963267948966;
        for (i = 1; i <= this.nov; ++i) {
            this.weight[iwin][j] = (float)Math.sin(piov4 * (1.0 + Math.sin(omega -= domega)));
            ++j;
        }
        if (iwin == 0) {
            for (i = 1; i <= this.nov; ++i) {
                this.weight[iwin][j] = 0.0f;
                ++j;
            }
        }
        if (this.stype == 2) {
            return;
        }
        for (i = 0; i < this.nw; ++i) {
            this.weight[iwin][i] = this.weight[iwin][i] * this.weight[iwin][i];
        }
    }

    private void setTrapezoidWeights(int iwin) {
        int i;
        float fact = 1.0f / (float)(this.nov + 1);
        int j = 0;
        if (iwin > 0) {
            for (i = 1; i <= this.nov; ++i) {
                this.weight[iwin][j] = fact * (float)i;
                ++j;
            }
        }
        for (i = 0; i < this.nwm; ++i) {
            this.weight[iwin][j] = 1.0f;
            ++j;
        }
        for (i = 1; i <= this.nov; ++i) {
            this.weight[iwin][j] = 1.0f - fact * (float)i;
            ++j;
        }
        if (iwin == 0) {
            for (i = 1; i <= this.nov; ++i) {
                this.weight[iwin][j] = 0.0f;
                ++j;
            }
        }
        if (this.stype != 2) {
            return;
        }
        for (i = 0; i < this.nw; ++i) {
            this.weight[iwin][i] = (float)Math.sqrt(this.weight[iwin][i]);
        }
    }

    public int getWindowCount() {
        return this.nwin;
    }

    public int getWindowLength() {
        return this.nw;
    }

    public int getWindowOverlap() {
        return this.nov;
    }

    public static void main(String[] args) {
        int i;
        Window1D w1d = new Window1D(16, 9, 4, 2, 0);
        System.out.println("WindowLength " + w1d.getWindowLength());
        System.out.println("WindowCount " + w1d.getWindowCount());
        System.out.println("WindowOverlap " + w1d.getWindowOverlap());
        float[] x = new float[w1d.n];
        Arrays.fill(x, 1.0f);
        float[] wx = new float[w1d.getWindowLength()];
        float[] xo = new float[x.length];
        for (int j = 0; j < w1d.getWindowCount(); ++j) {
            float[] wt = w1d.windowWeights(j);
            System.out.println(" Window " + j + " Weights:\n " + Arrays.toString(wt));
            int nw = w1d.getWindowSamples(x, j, wx);
            for (int i2 = 0; i2 < nw; ++i2) {
                assert (wx[i2] == wt[i2]) : "Invalid sample " + wx[i2] + " for window " + j + " sample " + i2;
            }
            w1d.putWindowSamples(wx, j, xo);
        }
        for (int i3 = 0; i3 < xo.length; ++i3) {
            assert ((double)Math.abs(xo[i3] - 1.0f) < 1.0E-6) : "Invalid output sample " + i3 + " xo[i] = " + xo[i3];
        }
        float[][] xw = new float[w1d.getWindowCount()][w1d.getWindowLength()];
        w1d.windowForward(x, xw);
        System.out.println(" Output after windowForward IteratedSine Forward:");
        for (i = 0; i < w1d.getWindowCount(); ++i) {
            System.out.println(Arrays.toString(xw[i]));
        }
        Arrays.fill(xo, 0.0f);
        w1d.windowInverse(xw, xo);
        for (i = 0; i < xo.length; ++i) {
            assert (xo[i] == 1.0f) : "Invalid output sample " + i + "xo[i] = " + xo[i];
        }
        System.out.println(" Output after windowInverse IteratedSine Forward:\n" + Arrays.toString(xo));
        w1d.initializeWindow1D(16, 9, 4, 1, 2);
        Arrays.fill(x, 1.0f);
        w1d.windowForward(x, xw);
        System.out.println(" Output after windowForward Cosine Symmetric:");
        for (i = 0; i < w1d.getWindowCount(); ++i) {
            System.out.println(Arrays.toString(xw[i]));
        }
        Arrays.fill(xo, 0.0f);
        w1d.windowInverse(xw, xo);
        for (i = 0; i < xo.length; ++i) {
            assert ((double)Math.abs(xo[i] - 1.0f) < 1.0E-6) : "Invalid output sample " + i + " xo[i] = " + xo[i];
        }
        System.out.println(" Output after windowInverse Cosine Symmetric:\n" + Arrays.toString(xo));
        w1d.initializeWindow1D(16, 9, 4, 0, 1);
        Arrays.fill(x, 1.0f);
        w1d.windowForward(x, xw);
        System.out.println(" Output after windowForward Trapezoid Inverse:");
        for (i = 0; i < w1d.getWindowCount(); ++i) {
            System.out.println(Arrays.toString(xw[i]));
        }
        Arrays.fill(xo, 0.0f);
        w1d.windowInverse(xw, xo);
        for (i = 0; i < xo.length; ++i) {
            assert ((double)Math.abs(xo[i] - 1.0f) < 1.0E-6) : "Invalid output sample " + i + " xo[i] = " + xo[i];
        }
        System.out.println(" Output after windowInverse Trapezoid Inverse:\n" + Arrays.toString(xo));
        w1d.initializeWindow1D(16, 9, 4, 1, 2);
        for (i = 0; i < w1d.n; ++i) {
            x[i] = (float)Math.random();
        }
        System.out.println(" Random input to windowForward Cosine Symmetric:");
        System.out.println(Arrays.toString(x));
        w1d.windowForward(x, xw);
        System.out.println(" Output after windowForward Cosine Symmetric:");
        for (i = 0; i < w1d.getWindowCount(); ++i) {
            System.out.println(Arrays.toString(xw[i]));
        }
        Arrays.fill(xo, 0.0f);
        w1d.windowInverse(xw, xo);
        System.out.println(" Output after windowInverse Cosine Symmetric:\n" + Arrays.toString(xo));
        for (i = 0; i < xo.length; ++i) {
            assert ((double)Math.abs(xo[i] - x[i]) < 1.0E-6) : "Invalid output sample " + i + " xo[i] = " + xo[i];
        }
        System.out.println("*** Window1D Success ***");
    }
}

