/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualFoldersSimple;
import org.javaseis.util.SeisException;
import org.javaseis.util.datavolume.Directory;

public class DiskSet {
    private String _path = "";
    private String _root = "";
    private String _location = "";
    private String[] _hosts = null;
    private Directory _user = null;
    private Directory[] _folders = null;

    public DiskSet(String path, String root, String[] hosts, String location) {
        if (path != null) {
            this._path = path;
        }
        if (root != null) {
            this._root = root;
        }
        if (location != null) {
            this._location = location;
        }
        if (hosts != null && hosts.length != 0) {
            this._hosts = new String[hosts.length];
            for (int k2 = 0; k2 < hosts.length; ++k2) {
                this._hosts[k2] = hosts[k2];
            }
        }
        this._user = new Directory(2);
        if (this._hosts != null) {
            this._folders = new Directory[this._hosts.length];
        }
    }

    public String getPath(String name) throws SeisException {
        return this._user.verifyFolder(this._path, name);
    }

    public String[] getFolders(String name) throws SeisException {
        String[] folders;
        if (this._hosts != null) {
            folders = new String[this._hosts.length];
            for (int k2 = 0; k2 < folders.length; ++k2) {
                this._folders[k2] = new Directory();
                folders[k2] = this._folders[k2].verifyFolder(this._root + this._hosts[k2] + "." + this._location, name);
            }
        } else {
            folders = null;
        }
        return folders;
    }

    public VirtualFolders getVirtualFolders(String name, ExtentPolicy policy) throws SeisException {
        String[] folders = this.getFolders(name);
        VirtualFoldersSimple retval = folders != null ? new VirtualFoldersSimple(this.getPath(name), this.getFolders(name), policy) : null;
        return retval;
    }

    public boolean recursiveDelete(String name) {
        boolean retval = true;
        retval = this._user.recursiveDelete(this.getPathDot() + name);
        if (this._folders != null) {
            retval = true;
            for (int k2 = 0; retval && k2 < this._folders.length; ++k2) {
                if (this._folders[k2] == null) continue;
                retval = this._folders[k2].recursiveDelete(this._root + this._hosts[k2] + "." + this.getLocationDot() + name);
            }
        }
        return retval;
    }

    private String getPathDot() {
        String path_dot = this._path.length() > 0 ? this._path + "." : "";
        return path_dot;
    }

    private String getLocationDot() {
        String loc_dot = this._location.length() > 0 ? this._location + "." : "";
        return loc_dot;
    }
}

