/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.ListIterator;

public class MXBeanReporter {
    PrintStream _printStream = null;

    public MXBeanReporter() {
        this(System.out);
    }

    public MXBeanReporter(PrintStream out) {
        this._printStream = out;
    }

    public void printReport() {
        Element root = new Element("mxbean-reporter");
        root.addChild(this.getThreadsElement());
        root.addChild(this.getMemoryElement());
        this._printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this._printStream.print(root.toXML());
    }

    public Element getThreadsElement() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        Element threadsElement = new Element("threads");
        threadsElement.setAttribute("thread-count", Long.toString(threads.getThreadCount()));
        threadsElement.setAttribute("total-started-thread-count", Long.toString(threads.getTotalStartedThreadCount()));
        threadsElement.setAttribute("daemon-thread-count", Long.toString(threads.getDaemonThreadCount()));
        threadsElement.setAttribute("peak-thread-count", Long.toString(threads.getPeakThreadCount()));
        long totalCpuTime = 0L;
        long totalUserTime = 0L;
        ThreadInfo[] threadInfos = threads.getThreadInfo(threads.getAllThreadIds(), Integer.MAX_VALUE);
        for (int i = 0; i < threadInfos.length; ++i) {
            ThreadInfo threadInfo = threadInfos[i];
            long threadID = threadInfo.getThreadId();
            Element threadElement = new Element("thread");
            threadElement.setAttribute("id", Long.toString(threadID));
            threadElement.setAttribute("name", threadInfo.getThreadName());
            threadElement.setAttribute("state", (Object)threadInfo.getThreadState());
            long threadCpuTime = threads.getThreadCpuTime(threadID);
            long threadUserTime = threads.getThreadUserTime(threadID);
            threadElement.setAttribute("cpu-time-nano", Long.toString(threadCpuTime));
            threadElement.setAttribute("cpu-time-ms", Long.toString(threadCpuTime / 1000000L));
            threadElement.setAttribute("user-time-nano", Long.toString(threadUserTime));
            threadElement.setAttribute("user-time-ms", Long.toString(threadUserTime / 1000000L));
            threadElement.setAttribute("blocked-count", Long.toString(threadInfo.getBlockedCount()));
            threadElement.setAttribute("blocked-time", Long.toString(threadInfo.getBlockedTime()));
            threadElement.setAttribute("waited-count", Long.toString(threadInfo.getWaitedCount()));
            threadElement.setAttribute("waited-time", Long.toString(threadInfo.getWaitedTime()));
            StackTraceElement[] e = threadInfo.getStackTrace();
            if (e.length > 0) {
                Element threadStackElement = new Element("stack-trace");
                for (int j = 0; j < e.length; ++j) {
                    threadStackElement.addItem("stack-trace-element", e[j]);
                }
                threadElement.addChild(threadStackElement);
            }
            threadsElement.addChild(threadElement);
            totalCpuTime += threadCpuTime;
            totalUserTime += threadUserTime;
        }
        long totalCpuTimeMs = totalCpuTime / 1000000L;
        long totalUserTimeMs = totalUserTime / 1000000L;
        threadsElement.setAttribute("total-cpu-time-nano", Long.toString(totalCpuTime));
        threadsElement.setAttribute("total-user-time-nano", Long.toString(totalUserTime));
        threadsElement.setAttribute("total-cpu-time-ms", Long.toString(totalCpuTimeMs));
        threadsElement.setAttribute("total-user-time-ms", Long.toString(totalUserTimeMs));
        long uptime = runtime.getUptime();
        threadsElement.setAttribute("uptime", Long.toString(uptime));
        double cpuPercentage = (double)totalCpuTimeMs / (double)uptime * 100.0;
        double userPercentage = (double)totalUserTimeMs / (double)uptime * 100.0;
        threadsElement.setAttribute("total-cpu-percent", Double.toString(cpuPercentage));
        threadsElement.setAttribute("total-user-percent", Double.toString(userPercentage));
        return threadsElement;
    }

    public Element getMemoryElement() {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        Element memoryElement = new Element("memory");
        memoryElement.addChild(this.getMemoryUsageElement("heap", memory.getHeapMemoryUsage()));
        memoryElement.addChild(this.getMemoryUsageElement("non-heap", memory.getNonHeapMemoryUsage()));
        memoryElement.setAttribute("object-pending-finalization-count", Integer.toString(memory.getObjectPendingFinalizationCount()));
        return memoryElement;
    }

    public String getHeapMemoryUsage() {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        return this.getMemoryUsageElement("heap", memory.getHeapMemoryUsage()).toXML();
    }

    private Element getMemoryUsageElement(String type, MemoryUsage memoryUsage) {
        long committed = memoryUsage.getCommitted();
        long init = memoryUsage.getInit();
        long max = memoryUsage.getMax();
        long used = memoryUsage.getUsed();
        Element memoryUsedElement = new Element("usage");
        memoryUsedElement.setAttribute("type", type);
        memoryUsedElement.setAttribute("committed-raw", Long.toString(committed));
        memoryUsedElement.setAttribute("init-raw", Long.toString(init));
        memoryUsedElement.setAttribute("max-raw", Long.toString(max));
        memoryUsedElement.setAttribute("used-raw", Long.toString(used));
        memoryUsedElement.setAttribute("committed", this.convertToMemoryString(committed));
        memoryUsedElement.setAttribute("init", this.convertToMemoryString(init));
        memoryUsedElement.setAttribute("max", this.convertToMemoryString(max));
        memoryUsedElement.setAttribute("used", this.convertToMemoryString(used));
        return memoryUsedElement;
    }

    private String convertToMemoryString(long size) {
        String out;
        if (size > 0x10000000000L) {
            double dsize = (double)size / 1.099511627776E12;
            out = String.format("%.3f TB", dsize);
        } else if (size > 0x40000000L) {
            double dsize = (double)size / 1.073741824E9;
            out = String.format("%.3f GB", dsize);
        } else if (size > 0x100000L) {
            double dsize = (double)size / 1048576.0;
            out = String.format("%.3f MB", dsize);
        } else if (size > 1024L) {
            double dsize = (double)size / 1024.0;
            out = String.format("%.3f KB", dsize);
        } else {
            out = Long.toString(size);
        }
        return out;
    }

    public static void main(String[] args) {
        MXBeanReporter m = new MXBeanReporter();
        m.printReport();
    }

    public class Element {
        private String _name;
        private ArrayList<Object> _attributeList;
        private ArrayList<Object> _itemList;

        public Element(String name) {
            this._name = name;
            this._attributeList = new ArrayList();
            this._itemList = new ArrayList();
        }

        public String getName() {
            return this._name;
        }

        public void setAttribute(String key, Object value) {
            this._attributeList.add(key);
            this._attributeList.add(value);
        }

        public void addItem(String key, Object value) {
            this._itemList.add(key);
            this._itemList.add(value);
        }

        public void addChild(Element e) {
            this._itemList.add(e.getName());
            this._itemList.add(e);
        }

        public String toString() {
            return this.toXML();
        }

        public String toXML() {
            return this.toXML("");
        }

        public String toXML(String indent) {
            String out;
            String innerIndent = indent + "  ";
            ListIterator<Object> attributeIterator = this._attributeList.listIterator();
            String attributeString = "";
            while (attributeIterator.hasNext()) {
                Object objKey = attributeIterator.next();
                if (!(objKey instanceof String)) {
                    throw new IllegalStateException("Expected key of type String, but found " + objKey.getClass());
                }
                String key = (String)objKey;
                if (!attributeIterator.hasNext()) {
                    throw new IllegalStateException("No value object for key " + key);
                }
                Object objVal = attributeIterator.next();
                attributeString = attributeString + " " + key + "=\"" + objVal.toString() + "\"";
            }
            if (this._itemList.isEmpty()) {
                out = indent + "<" + this._name + attributeString + "/>\n";
            } else {
                out = indent + "<" + this._name + attributeString + ">\n";
                ListIterator<Object> itemIterator = this._itemList.listIterator();
                while (itemIterator.hasNext()) {
                    Object objKey = itemIterator.next();
                    if (!(objKey instanceof String)) {
                        throw new IllegalStateException("Expected key of type String, but found " + objKey.getClass());
                    }
                    String key = (String)objKey;
                    if (!itemIterator.hasNext()) {
                        throw new IllegalStateException("No value object for key " + key);
                    }
                    Object objVal = itemIterator.next();
                    if (objVal instanceof Element) {
                        out = out + ((Element)objVal).toXML(innerIndent);
                        continue;
                    }
                    out = out + innerIndent + "<item key=\"" + key + "\" value=\"" + objVal.toString() + "\"/>\n";
                }
                out = out + indent + "</" + this._name + ">\n";
            }
            return out;
        }
    }
}

