/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.distributed.beta;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.ArraysUtil;
import org.javaseis.array.beta.DecompositionType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.FlexArrayUtil;
import org.javaseis.array.beta.FrameIterator;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.ParallelDecomposition;
import org.javaseis.array.beta.TraceIterator;
import org.javaseis.array.beta.Transposer;
import org.javaseis.distributed.beta.ParallelArrayPositionIterator;
import org.javaseis.iterators.beta.IPositionIterator;
import org.javaseis.parallel.IParallelContext;

public class ParallelArray<T>
implements IFlexArray<T> {
    private final Logger LOG = Logger.getLogger(ParallelArray.class.getName());
    private int[] globalShape;
    private ParallelDecomposition decomposition;
    private IFlexArray<T> flexArray;
    private final IParallelContext parallelContext;

    public ParallelArray(Class<?> type, int elementCount, int[] shape, DecompositionType decompositionType, IParallelContext pc) {
        this.validateShape(shape);
        this.validateDecomposition(decompositionType);
        this.parallelContext = pc;
        this.globalShape = (int[])shape.clone();
        this.decomposition = new ParallelDecomposition(decompositionType, this.globalShape[this.globalShape.length - 1], this.parallelContext.size(), this.parallelContext.rank());
        int[] localShape = (int[])this.globalShape.clone();
        localShape[this.globalShape.length - 1] = this.decomposition.getElementsPerTask();
        this.flexArray = new FlexArray(type, elementCount, localShape);
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine(this.toString());
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("GlobalShape = " + Arrays.toString(this.globalShape) + "\n");
        buf.append("Decomposition = " + this.decomposition.toString() + "\n");
        buf.append("LocalData = " + this.flexArray.toString() + "\n");
        return buf.toString();
    }

    public String getContents(String message) {
        StringBuilder buf = new StringBuilder();
        buf.append(message + "\n");
        TraceIterator ti = new TraceIterator(this);
        while (ti.hasNext()) {
            Object trace = ti.next();
            buf.append(Arrays.toString(ti.getPosition()));
            buf.append(" ");
            buf.append(ArraysUtil.toString(trace));
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public int getDimensions() {
        return this.flexArray.getDimensions();
    }

    @Override
    public int getElementCount() {
        return this.flexArray.getElementCount();
    }

    @Override
    public void setElementCount(int elementCount) {
        this.flexArray.setElementCount(elementCount);
    }

    @Override
    public Class<?> getType() {
        return this.flexArray.getType();
    }

    @Override
    public Class<?> getElementType() {
        return this.flexArray.getElementType();
    }

    @Override
    public T[] getBackArray() {
        return this.flexArray.getBackArray();
    }

    @Override
    public int[] getShape() {
        return (int[])this.globalShape.clone();
    }

    @Override
    public void reshape(int[] shape) {
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("reshape called, current shape = " + Arrays.toString(this.globalShape) + " target shape = " + Arrays.toString(shape));
        }
        if (shape.length != this.globalShape.length) {
            throw new UnsupportedOperationException("Changing dimensionality is not supported yet");
        }
        if (shape[shape.length - 1] != this.globalShape[shape.length - 1]) {
            this.transposeOuter();
            int[] transposedShape = (int[])this.globalShape.clone();
            transposedShape[transposedShape.length - 2] = shape[shape.length - 1];
            this.flexArray.reshape(transposedShape);
            this.updateGlobalShape(this.flexArray.getShape());
            this.transposeOuter();
        }
        int[] localShape = this.flexArray.getShape();
        for (int i = 0; i < localShape.length - 1; ++i) {
            localShape[i] = shape[i];
        }
        this.flexArray.reshape(localShape);
        this.updateGlobalShape(this.flexArray.getShape());
    }

    @Override
    public void transpose(TransposeType type) {
        Transposer.transpose(this, type);
    }

    @Override
    public void transpose(int axisA, int axisB) {
        int len = this.flexArray.getDimensions();
        if (axisA == len && axisB == len - 1 || axisB == len && axisA == len - 1) {
            this.transposeOuter();
            return;
        }
        if (axisA == 1 && axisB != 2) {
            this.transpose(1, 2);
            this.transpose(2, axisB);
            this.transpose(1, 2);
            return;
        }
        if (axisB == 1 && axisA != 2) {
            this.transpose(1, 2);
            this.transpose(2, axisA);
            this.transpose(1, 2);
            return;
        }
        if (axisA == len && axisB != len - 1) {
            this.transpose(len - 1, axisB);
            this.transpose(len, len - 1);
            this.transpose(len - 1, axisB);
            return;
        }
        if (axisB == len && axisA != len - 1) {
            this.transpose(len - 1, axisA);
            this.transpose(len, len - 1);
            this.transpose(len - 1, axisA);
            return;
        }
        this.flexArray.transpose(axisA, axisB);
        this.updateGlobalShape(this.flexArray.getShape());
    }

    @Override
    public void transposeOuter() {
        boolean debugTransposeOuter = false;
        int ncpu = this.parallelContext.size();
        if (debugTransposeOuter) {
            this.parallelContext.serialPrint(this.LOG, this.toString());
        }
        int[] transposableShape = this.flexArray.getShape();
        while (transposableShape[transposableShape.length - 2] % ncpu != 0) {
            int n = transposableShape.length - 2;
            transposableShape[n] = transposableShape[n] + 1;
        }
        if (debugTransposeOuter) {
            this.parallelContext.masterPrint(this.LOG, "Original Global Shape = " + Arrays.toString(this.globalShape));
            this.parallelContext.masterPrint(this.LOG, "Original Local Shape = " + Arrays.toString(this.flexArray.getShape()));
            this.parallelContext.masterPrint(this.LOG, "Transposable Local Shape = " + Arrays.toString(transposableShape));
        }
        if (debugTransposeOuter) {
            this.parallelContext.masterPrint(this.LOG, "Reshaping to transposable shape");
        }
        this.flexArray.reshape(transposableShape);
        if (debugTransposeOuter) {
            this.parallelContext.masterPrint(this.printFrames(this.flexArray, "After reshape to transposable shape"));
        }
        if (debugTransposeOuter) {
            this.parallelContext.serialPrint(this.LOG, "Perform local T132");
        }
        this.flexArray.transposeOuter();
        int tileSize = transposableShape[transposableShape.length - 2] / this.parallelContext.size();
        if (debugTransposeOuter) {
            this.parallelContext.masterPrint(this.LOG, "Start transpose, tileSize = " + tileSize);
        }
        throw new UnsupportedOperationException("ttranObject is not available!");
    }

    @Override
    public void putTrace(T buf, int[] pos) {
        this.flexArray.putTrace(buf, this.decomposition.localPosition(pos));
    }

    @Override
    public T getTrace(int[] pos) {
        return this.flexArray.getTrace(this.decomposition.localPosition(pos));
    }

    @Override
    public void putFrame(T[] buf, int[] pos) {
        this.flexArray.putFrame(buf, this.decomposition.localPosition(pos));
    }

    @Override
    public T[] getFrame(int[] pos) {
        return this.flexArray.getFrame(this.decomposition.localPosition(pos));
    }

    @Override
    public T[][] getVolume(int[] pos) {
        return this.flexArray.getVolume(this.decomposition.localPosition(pos));
    }

    @Override
    public void putVolume(T[][] buf, int[] pos) {
        this.flexArray.putVolume(buf, this.decomposition.localPosition(pos));
    }

    @Override
    public T[][][] getHypercube(int[] pos) {
        return this.flexArray.getHypercube(this.decomposition.localPosition(pos));
    }

    @Override
    public void putHypercube(T[][][] buf, int[] pos) {
        this.flexArray.putHypercube(buf, this.decomposition.localPosition(pos));
    }

    @Override
    public IPositionIterator<int[]> newPositionIterator() {
        return this.newPositionIterator(IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
    }

    @Override
    public IPositionIterator<int[]> newPositionIterator(IPositionIterator.Direction dir, IPositionIterator.Scope axis) {
        int[] shape = this.getShape();
        return new ParallelArrayPositionIterator(this.decomposition, shape, dir, axis);
    }

    public IPositionIterator<int[]> newPositionIterator(IPositionIterator.Direction dir, int axisIndex) {
        int[] shape = this.getShape();
        return new ParallelArrayPositionIterator(this.decomposition, shape, dir, axisIndex);
    }

    @Override
    public ParallelDecomposition getDecomposition() {
        return this.decomposition;
    }

    private void updateGlobalShape(int[] localShape) {
        int[] shape = (int[])localShape.clone();
        shape[shape.length - 1] = this.globalShape[shape.length - 1];
        this.globalShape = shape;
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("updateGlobalShape called, localShape = " + Arrays.toString(localShape) + " globalShape = " + Arrays.toString(this.globalShape));
        }
    }

    private void updateDecomposition(int elements) {
        ParallelDecomposition newDecomp = new ParallelDecomposition(this.decomposition.getDecompType(), elements, this.parallelContext.size(), this.parallelContext.rank());
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("updateDecomposition callled original decomposition = " + this.decomposition + " new decomposition = " + newDecomp);
        }
        this.decomposition = newDecomp;
    }

    private void validateDecomposition(DecompositionType decompositionType) {
        if (!decompositionType.equals((Object)DecompositionType.BLOCK)) {
            throw new IllegalArgumentException("Currently only block decomposition is support");
        }
    }

    private void validateShape(int[] shape) {
        if (shape.length < 3) {
            throw new IllegalArgumentException("Shape must represent 3 or more dimensions");
        }
        if (shape[0] < 0) {
            throw new IllegalArgumentException("Shape is invalid " + Arrays.toString(shape));
        }
        for (int i = 1; i < shape.length; ++i) {
            if (shape[i] >= 1) continue;
            throw new IllegalArgumentException("Shape has dimensions other than the sample axis with fewer than 1 item " + Arrays.toString(shape));
        }
    }

    private String printFrames(IFlexArray<T> input, String str) {
        StringBuilder buf = new StringBuilder();
        buf.append(str + "\n");
        FrameIterator it = new FrameIterator(input);
        while (it.hasNext()) {
            buf.append(FlexArrayUtil.frameToString((Object[])it.next()));
        }
        return buf.toString();
    }

    private String printFlatArray(T[] flatArray) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < flatArray.length; ++i) {
            buf.append("rank = " + this.parallelContext.rank() + " " + ArraysUtil.toString(flatArray[i]) + "\n");
        }
        return buf.toString();
    }
}

