/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta;

import java.util.Arrays;
import java.util.Random;
import org.javaseis.array.TransposeType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;
import org.javaseis.iterators.beta.IPositionIterator;
import org.javaseis.util.MemoryReporter;
import org.junit.Assert;

public class FftNdLocal {
    SeisFft[] _ffts;
    int _ndim;
    int[] _inShape;
    int[] _forwardShape;
    boolean _complex;
    private MemoryReporter _memrp = null;

    public FftNdLocal(int[] shapeIn) {
        int ndim = shapeIn.length;
        this.init(ndim, shapeIn, new float[ndim], IFFT.Type.REAL);
    }

    public FftNdLocal(int[] shapeIn, float[] pad, IFFT.Type type) {
        this.init(shapeIn.length, shapeIn, pad, type);
    }

    public FftNdLocal(int ndim, int[] shape, float[] pad, IFFT.Type type) {
        this.init(ndim, shape, pad, type);
    }

    public FftNdLocal(int ndim, int[] shape, float[] pad, IFFT.Type type, IFFT.Scale scale) {
        this.init(ndim, shape, pad, type, scale);
    }

    public void init(int ndim, int[] shape, float[] pad, IFFT.Type type) {
        this.init(ndim, shape, pad, type, IFFT.Scale.INVERSE);
    }

    public void init(int ndim, int[] shape, float[] pad, IFFT.Type type, IFFT.Scale scale) {
        if (ndim < 1 || ndim > 4 || ndim > shape.length) {
            throw new RuntimeException("Only support 1D, 2D, 3D, 4D FFT now! " + ndim);
        }
        this._ndim = ndim;
        this._ffts = new SeisFft[ndim];
        this._inShape = (int[])shape.clone();
        this._forwardShape = (int[])shape.clone();
        this._ffts[0] = type == IFFT.Type.REAL ? new SeisFft(shape[0], pad[0], type, -1, scale) : new SeisFft(shape[0], pad[0], type, 1, scale);
        this._forwardShape[0] = this._ffts[0].getLength();
        for (int i = 1; i < ndim; ++i) {
            this._ffts[i] = new SeisFft(shape[i], pad[i], IFFT.Type.COMPLEX, 1, scale);
            this._forwardShape[i] = this._ffts[i].getLength();
        }
        if (type == IFFT.Type.REAL) {
            this._complex = false;
            this._forwardShape[0] = this._forwardShape[0] / 2 + 1;
        } else {
            this._complex = true;
        }
    }

    public int[] getForwardShape() {
        return (int[])this._forwardShape.clone();
    }

    public int[] getInverseShape() {
        return (int[])this._inShape.clone();
    }

    public void setmemlog(MemoryReporter memrp) {
        this._memrp = memrp;
    }

    public void forward(IFlexArray<float[]> gma) {
        if (this._complex && gma.getElementCount() != 2) {
            throw new RuntimeException("\nInput arrays have wrong element counts:" + gma.getElementCount() + "transform type:" + (this._complex ? "Complex" : "Real"));
        }
        if (gma.getDimensions() < this._ndim) {
            throw new RuntimeException("\nInput arrays have wrong dimensions: " + gma.getDimensions() + " fft dimension: " + this._ndim);
        }
        int daDim = gma.getDimensions();
        int lDim = Math.min(this._ndim, daDim);
        if (this._memrp != null) {
            System.out.println("before forward 1D FFT:" + this._memrp.getMemoryUsage());
        }
        for (int idim = 0; idim < lDim; ++idim) {
            this.forwardFft1D(gma, idim);
            if (this._memrp != null) {
                System.out.println("after forward 1D FFT:" + this._memrp.getMemoryUsage());
            }
            if (lDim >= 2) {
                gma.transpose(TransposeType.T21);
                if (this._memrp != null) {
                    System.out.println("after T21:" + this._memrp.getMemoryUsage());
                }
            }
            if (lDim >= 3) {
                gma.transpose(TransposeType.T132);
                if (this._memrp != null) {
                    System.out.println("after T132:" + this._memrp.getMemoryUsage());
                }
            }
            if (lDim < 4) continue;
            gma.transpose(TransposeType.T1243);
            if (this._memrp == null) continue;
            System.out.println("after T1243:" + this._memrp.getMemoryUsage());
        }
    }

    private void forwardFft1D(IFlexArray<float[]> gma, int idim) {
        int elem = gma.getElementCount();
        int[] newshape = gma.getShape();
        newshape[0] = this._forwardShape[idim];
        IPositionIterator<int[]> dapi = gma.newPositionIterator(IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.FRAME_AXIS);
        while (dapi.hasNext()) {
            int[] position = (int[])dapi.next();
            float[][] intrcs = gma.getFrame(position);
            float[][] outtrcs = new float[newshape[1]][newshape[0] * 2];
            for (int i = 0; i < outtrcs.length; ++i) {
                if (elem == 1) {
                    this._ffts[idim].realToComplex(intrcs[i], outtrcs[i]);
                    continue;
                }
                this._ffts[idim].complexForward(intrcs[i], outtrcs[i]);
            }
            gma.putFrame((T[])outtrcs, position);
        }
        gma.setElementCount(2);
        gma.reshape(newshape);
    }

    public void inverse(IFlexArray<float[]> gma) {
        if (gma.getElementCount() != 2) {
            throw new RuntimeException("\nInput arrays have wrong element counts:" + gma.getElementCount() + " must be Complex");
        }
        int daDim = gma.getDimensions();
        int lDim = Math.min(this._ndim, daDim);
        if (this._memrp != null) {
            System.out.println("before inverse:" + this._memrp.getMemoryUsage());
        }
        for (int idim = lDim - 1; idim >= 0; --idim) {
            if (lDim >= 4) {
                gma.transpose(TransposeType.T1243);
                if (this._memrp != null) {
                    System.out.println("after T1243:" + this._memrp.getMemoryUsage());
                }
            }
            if (lDim >= 3) {
                gma.transpose(TransposeType.T132);
                if (this._memrp != null) {
                    System.out.println("after T132:" + this._memrp.getMemoryUsage());
                }
            }
            if (lDim >= 2) {
                gma.transpose(TransposeType.T21);
                if (this._memrp != null) {
                    System.out.println("after T21:" + this._memrp.getMemoryUsage());
                }
            }
            this.inverseFft1D(gma, idim);
            if (this._memrp == null) continue;
            System.out.println("after inverse 1D FFT:" + this._memrp.getMemoryUsage());
        }
    }

    private void inverseFft1D(IFlexArray<float[]> gma, int idim) {
        int elem = gma.getElementCount();
        int[] newshape = gma.getShape();
        newshape[0] = this._inShape[idim];
        if (idim == 0 && !this._complex) {
            elem = 1;
        }
        IPositionIterator<int[]> dapi = gma.newPositionIterator(IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.FRAME_AXIS);
        while (dapi.hasNext()) {
            int[] position = (int[])dapi.next();
            float[][] intrcs = gma.getFrame(position);
            float[][] outtrcs = new float[newshape[1]][newshape[0] * elem];
            for (int i = 0; i < outtrcs.length; ++i) {
                if (elem == 1) {
                    this._ffts[idim].complexToReal(intrcs[i], outtrcs[i]);
                    continue;
                }
                this._ffts[idim].complexInverse(intrcs[i], outtrcs[i]);
            }
            gma.putFrame((T[])outtrcs, position);
        }
        gma.setElementCount(elem);
        gma.reshape(newshape);
    }

    public static void main(String[] args) {
        int i;
        float[] trc;
        int[] pos;
        int[] shape = new int[]{13, 17, 7};
        float[] pad = new float[]{0.0f, 0.0f, 0.0f};
        FftNdLocal fnd = new FftNdLocal(3, shape, pad, IFFT.Type.REAL);
        IFlexArray<float[]> gma = FlexArray.createFloatArray(shape);
        IPositionIterator<int[]> pti = gma.newPositionIterator();
        Random r = new Random(12345L);
        while (pti.hasNext()) {
            pos = (int[])pti.next();
            trc = gma.getTrace(pos);
            for (i = 0; i < shape[0]; ++i) {
                trc[i] = r.nextFloat();
            }
        }
        fnd.forward(gma);
        fnd.inverse(gma);
        pti.reset();
        r.setSeed(12345L);
        while (pti.hasNext()) {
            pos = (int[])pti.next();
            trc = gma.getTrace(pos);
            for (i = 0; i < shape[0]; ++i) {
                float f1 = trc[i];
                float f2 = r.nextFloat();
                Assert.assertEquals((String)("frequency slice " + i + Arrays.toString(pos)), (double)f1, (double)f2, (double)1.0E-6f);
            }
        }
    }
}

