/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.a.d.i;
import com.certicom.ecc.a.d.n;
import com.certicom.ecc.asn1.Parameters;
import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.spec.ECKeySpec;
import com.certicom.ecc.spec.F2mParameterSpec;
import com.certicom.ecc.spec.FFParameterSpec;
import com.certicom.ecc.spec.FpParameterSpec;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class ECPrivateKeySpec
extends ECKeySpec
implements Zeroizeable,
ECPrivateKey,
Serializable {
    private static final long serialVersionUID = -7316588176791738290L;
    private byte[] a;
    private ECParams b;
    private int c;
    private transient CryptoCodec d = null;
    private boolean e = false;

    public ECPrivateKeySpec() {
    }

    public ECPrivateKeySpec(int n2, BigInteger bigInteger, ECParams eCParams) {
        int n3;
        this.c = n2;
        this.b = eCParams;
        byte[] byArray = bigInteger.toByteArray();
        for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
        }
        this.a = new byte[eCParams.getPointOrder().length];
        int n4 = this.a.length - (byArray.length - n3);
        System.arraycopy(byArray, n3, this.a, n4, byArray.length - n3);
    }

    public ECPrivateKeySpec(int n2, ECParams eCParams, byte[] byArray, int n3, int n4) {
        this.init(n2, eCParams, byArray, n3, n4);
    }

    public void init(int n2, ECParams eCParams, byte[] byArray, int n3, int n4) {
        i i2;
        Object[] objectArray;
        this.c = n2;
        this.b = eCParams;
        String string = null;
        if (this.b != null) {
            string = this.b.getOID();
        }
        CryptoCodec cryptoCodec = this.codec();
        if (string == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        }
        cryptoCodec.init(2, objectArray);
        Object[] objectArray3 = this.codec().codecToObject(byArray, n3, n4, true);
        this.a = objectArray3[2] instanceof n ? ((n)objectArray3[2]).a() : (byte[])objectArray3[2];
        String string2 = null;
        string2 = objectArray3[1] instanceof Parameters ? ((i2 = ((Parameters)objectArray3[1]).b()) != null ? i2.toString() : "noCurveInAsnOID") : objectArray3[1].toString();
        if (string2.equals("ECParameters")) {
            throw new IllegalArgumentException("cannot decode full params");
        }
        if (string2.equals("ImplicitlyCA") || string == null || !string2.equals(string)) {
            this.b = CurveList.byName(string2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Integer(this.c));
        ECParams eCParams = this.getECParams();
        objectOutputStream.writeObject(new Integer(eCParams.getCofactor()));
        objectOutputStream.writeObject(eCParams.getA());
        objectOutputStream.writeObject(eCParams.getB());
        objectOutputStream.writeObject(eCParams.getPoint().getX());
        objectOutputStream.writeObject(eCParams.getPoint().getY());
        objectOutputStream.writeObject(eCParams.getPointOrder());
        objectOutputStream.writeObject(eCParams.getOID());
        if (eCParams.getSeed() != null) {
            objectOutputStream.writeObject(new Boolean(true));
            objectOutputStream.writeObject(eCParams.getSeed());
        } else {
            objectOutputStream.writeObject(new Boolean(false));
        }
        if (eCParams instanceof F2mParameterSpec) {
            objectOutputStream.writeObject("F2m");
            objectOutputStream.writeObject(new Integer(eCParams.getSize()));
            objectOutputStream.writeObject(((F2mParameterSpec)eCParams).getName());
            objectOutputStream.writeObject(((F2mParameterSpec)eCParams).getBasis());
        } else {
            objectOutputStream.writeObject("Fp");
            objectOutputStream.writeObject(((FpParameterSpec)eCParams).getPrime());
            objectOutputStream.writeObject(((FpParameterSpec)eCParams).getName());
        }
        objectOutputStream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        String string;
        int n2 = (Integer)objectInputStream.readObject();
        FFParameterSpec fFParameterSpec = null;
        int n3 = (Integer)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        byte[] byArray2 = (byte[])objectInputStream.readObject();
        byte[] byArray3 = (byte[])objectInputStream.readObject();
        byte[] byArray4 = (byte[])objectInputStream.readObject();
        byte[] byArray5 = (byte[])objectInputStream.readObject();
        String string2 = (String)objectInputStream.readObject();
        boolean bl = (Boolean)objectInputStream.readObject();
        byte[] byArray6 = null;
        if (bl) {
            byArray6 = (byte[])objectInputStream.readObject();
        }
        if ((string = (String)objectInputStream.readObject()).equals("F2m")) {
            int n4 = (Integer)objectInputStream.readObject();
            String string3 = (String)objectInputStream.readObject();
            int[] nArray = (int[])objectInputStream.readObject();
            fFParameterSpec = new F2mParameterSpec(byArray, byArray2, byArray6, byArray3, byArray4, byArray5, n3, n4, nArray, string3, string2);
        } else if (string.equals("Fp")) {
            byte[] byArray7 = (byte[])objectInputStream.readObject();
            String string4 = (String)objectInputStream.readObject();
            fFParameterSpec = new FpParameterSpec(byArray, byArray2, byArray6, byArray3, byArray4, byArray5, n3, byArray7, string4, string2);
        }
        byte[] byArray8 = (byte[])objectInputStream.readObject();
        this.init(n2, fFParameterSpec, byArray8, 0, byArray8.length);
    }

    public synchronized byte[] getEncoded() {
        Object[] objectArray;
        String string = null;
        if (this.b != null) {
            string = this.b.getOID();
        }
        CryptoCodec cryptoCodec = this.codec();
        if (string == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        }
        cryptoCodec.init(1, objectArray);
        Object[] objectArray3 = this.codec().codecToObject(this.a, 0, this.a.length, true);
        return (byte[])objectArray3[1];
    }

    public ECParams getECParams() {
        if (this.b == null) {
            this.b = CurveList.byName("ImplicitlyCA");
        }
        return this.b;
    }

    public byte[] getExp() {
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public String toString() {
        if (this.b == null) {
            return "[ key: " + Conversion.OS2Hex(this.a, 2) + " curve: 0 ]";
        }
        return "[ key: " + Conversion.OS2Hex(this.a, 2) + " curve: " + this.b.toString() + " ] ";
    }

    public boolean equals(Object object) {
        ECPrivateKeySpec eCPrivateKeySpec;
        boolean bl;
        if (object instanceof ECPrivateKeySpec && (bl = this.b.equals((eCPrivateKeySpec = (ECPrivateKeySpec)object).getECParams()))) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.a.length && this.a[n3] == 0; ++n3) {
            }
            for (n2 = 0; n2 < eCPrivateKeySpec.a.length && eCPrivateKeySpec.a[n2] == 0; ++n2) {
            }
            if (this.a.length - n3 != eCPrivateKeySpec.a.length - n2) {
                return false;
            }
            n3 = this.a.length - n3;
            n2 = 0;
            while (n3-- > 0) {
                if (this.a[this.a.length - ++n2] == eCPrivateKeySpec.a[eCPrivateKeySpec.a.length - n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CryptoCodec codec() {
        if (this.d == null) {
            this.d = CryptoCodec.getInstance("ECPrivateKey", this.c);
        }
        return this.d;
    }

    public boolean isZeroized() {
        return this.e;
    }

    public boolean testZeroizationState() {
        return this.e;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.a, (byte)0);
        this.b = null;
        this.e = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

