/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.TextFieldBase;
import java.awt.Color;

public class TextFieldDouble
extends TextFieldBase {
    protected double m_min = 0.0;
    protected double m_max = 0.0;
    protected boolean m_rangeSet = false;

    protected void setRange(double min, double max) {
        this.m_min = min;
        this.m_max = max;
        this.m_rangeSet = true;
    }

    public double rangeMax() {
        return this.m_max;
    }

    public double rangeMin() {
        return this.m_min;
    }

    public boolean rangeSet() {
        return this.m_rangeSet;
    }

    public void clearRange() {
        this.m_rangeSet = false;
    }

    public TextFieldDouble() {
        super(DataType.Double);
        try {
            this.setText("0");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getDouble(double defaultValue) {
        try {
            if (!this.m_ok) {
                this.m_ignoreDoc = true;
                this.setText(Double.toString(defaultValue));
                this.m_ok = true;
                this.setForeground(Color.black);
                this.m_ignoreDoc = false;
                return defaultValue;
            }
            double v = Double.parseDouble(this.getText());
            if (this.m_rangeSet) {
                if (v < this.m_min) {
                    this.m_ignoreDoc = true;
                    this.setText(Double.toString(this.m_min));
                    this.m_ok = true;
                    this.setForeground(Color.black);
                    this.m_ignoreDoc = false;
                    return this.m_min;
                }
                if (v > this.m_max) {
                    this.m_ignoreDoc = true;
                    this.setText(Double.toString(this.m_max));
                    this.m_ok = true;
                    this.setForeground(Color.black);
                    this.m_ignoreDoc = false;
                    return this.m_max;
                }
            }
            return v;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return defaultValue;
        }
    }

    @Override
    public boolean checkText() {
        double v = 0.0;
        try {
            v = Double.parseDouble(this.getText());
        }
        catch (Exception error) {
            this.m_badnessReason = "Failed to parse double";
            this.setForeground(Color.red);
            return false;
        }
        if (!this.m_rangeSet) {
            this.setForeground(Color.black);
            return true;
        }
        if (v < this.m_min || v > this.m_max) {
            this.setForeground(Color.red);
            this.m_badnessReason = "Outside of range";
            return false;
        }
        this.setForeground(Color.black);
        return true;
    }
}

