/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.ParameterWidgetListenerList;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SliderWidget
extends LinearLayoutWidget
implements ChangeListener,
ActionListener,
DocumentListener {
    protected ParameterWidgetListenerList m_listenerList = new ParameterWidgetListenerList();
    protected double m_rangeMinimum = 10.0;
    protected double m_rangeMaximum = 10.0;
    protected double m_currentValue = 10.0;
    protected JSlider m_slider = new JSlider();
    protected boolean m_ignoreSliderChangeEvent = true;
    protected boolean m_bSliderRangeFixed = false;
    protected JTextField m_valueTextField = new JTextField("");
    protected JTextField m_minRangeTextField = new JTextField("");
    protected JTextField m_maxRangeTextField = new JTextField("");
    protected JCheckBox m_checkBox = null;
    protected boolean m_valueModified = true;
    protected boolean m_minModified = true;
    protected boolean m_maxModified = true;
    protected double m_scale = 1.0;
    protected double m_shift = 0.0;

    public SliderWidget(IParameterWidgetListener listener, String checkBoxText, String boxLabel, int inset, double val, double min, double max) {
        super(LinearLayoutWidget.Direction.Vertical, inset, boxLabel);
        try {
            this.m_listenerList.add(listener);
            this.m_currentValue = val;
            this.m_rangeMinimum = Math.min(min, this.m_currentValue - 0.01);
            this.m_rangeMaximum = Math.max(max, this.m_currentValue + 0.01);
            double range = this.m_rangeMaximum - this.m_rangeMinimum;
            this.m_valueTextField.setText(Tools_Strings.doubleToString(this.m_currentValue, range));
            this.m_minRangeTextField.setText(Tools_Strings.doubleToString(this.m_rangeMinimum, range));
            this.m_maxRangeTextField.setText(Tools_Strings.doubleToString(this.m_rangeMaximum, range));
            this.m_valueModified = false;
            this.m_minModified = false;
            this.m_maxModified = false;
            if (checkBoxText != null && checkBoxText.length() > 0) {
                this.m_checkBox = new JCheckBox(checkBoxText);
                this.m_checkBox.addActionListener(this);
                this.addComponent(this.m_checkBox, 0);
            }
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            LinearLayoutWidget bottom = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            top.addComponent(this.m_slider, 3);
            top.addComponent(this.m_valueTextField, 2);
            this.m_valueTextField.setMinimumSize(new Dimension(70, 10));
            bottom.addComponent(new JLabel("Min"), 0);
            bottom.addComponent(this.m_minRangeTextField, 10);
            bottom.addComponent(new JLabel("Max"), 0);
            bottom.addComponent(this.m_maxRangeTextField, 10);
            this.m_valueTextField.getDocument().addDocumentListener(this);
            this.m_minRangeTextField.getDocument().addDocumentListener(this);
            this.m_maxRangeTextField.getDocument().addDocumentListener(this);
            this.m_slider.setMinimum(0);
            this.m_slider.setMaximum(1000);
            this.m_slider.addChangeListener(this);
            this.m_valueTextField.addActionListener(this);
            this.m_minRangeTextField.addActionListener(this);
            this.m_maxRangeTextField.addActionListener(this);
            this.prepareSliderConversion();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasCheck() {
        return this.m_checkBox != null;
    }

    public void setCheckSelected(boolean sel) throws Exception {
        try {
            if (this.m_checkBox == null) {
                throw new Exception("m_checkBox == null");
            }
            this.m_checkBox.setSelected(sel);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean isCheckSelected() throws Exception {
        try {
            if (this.m_checkBox == null) {
                throw new Exception("m_checkBox == null");
            }
            return this.m_checkBox.isSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setRangeLocked(boolean bRangeLocked) {
        try {
            this.m_bSliderRangeFixed = bRangeLocked;
            this.m_minRangeTextField.setEnabled(!this.m_bSliderRangeFixed);
            this.m_maxRangeTextField.setEnabled(!this.m_bSliderRangeFixed);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getDoubleValue() {
        String text = this.m_valueTextField.getText();
        text = text.replace(",", ".");
        return Double.parseDouble(text);
    }

    public void setDoubleValue(double v) {
        try {
            this.m_currentValue = v;
            this.m_rangeMinimum = Math.min(this.m_rangeMinimum, v);
            this.m_rangeMaximum = Math.max(this.m_rangeMaximum, v);
            this.writeDataToTextFields();
            this.prepareSliderConversion();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public long getLongValue() {
        return Long.parseLong(this.m_valueTextField.getText());
    }

    protected void writeDataToTextFields() {
        try {
            double range = this.m_rangeMaximum - this.m_rangeMinimum;
            this.m_valueTextField.setText(Tools_Strings.doubleToString(this.m_currentValue, range));
            this.m_minRangeTextField.setText(Tools_Strings.doubleToString(this.m_rangeMinimum, range));
            this.m_maxRangeTextField.setText(Tools_Strings.doubleToString(this.m_rangeMaximum, range));
            this.m_valueModified = false;
            this.m_minModified = false;
            this.m_maxModified = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void overwriteMinChanges() {
        try {
            if (!this.m_minModified) {
                return;
            }
            double range = this.m_rangeMaximum - this.m_rangeMinimum;
            this.m_minRangeTextField.setText(Tools_Strings.doubleToString(this.m_rangeMinimum, range));
            this.m_minModified = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void overwriteMaxChanges() {
        try {
            if (!this.m_maxModified) {
                return;
            }
            double range = this.m_rangeMaximum - this.m_rangeMinimum;
            this.m_maxRangeTextField.setText(Tools_Strings.doubleToString(this.m_rangeMaximum, range));
            this.m_maxModified = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (this.m_ignoreSliderChangeEvent) {
                return;
            }
            this.overwriteMinChanges();
            this.overwriteMaxChanges();
            this.m_currentValue = ((double)this.m_slider.getValue() - this.m_shift) / this.m_scale;
            this.writeDataToTextFields();
            this.m_listenerList.send(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepareSliderConversion() {
        try {
            this.m_ignoreSliderChangeEvent = true;
            this.m_scale = (double)this.m_slider.getMaximum() / (this.m_rangeMaximum - this.m_rangeMinimum);
            this.m_shift = 0.0 - this.m_rangeMinimum * this.m_scale;
            this.m_slider.setValue((int)(this.m_shift + this.m_scale * this.m_currentValue));
            this.m_ignoreSliderChangeEvent = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleValueTextFieldChanged() {
        try {
            this.m_currentValue = Double.parseDouble(this.m_valueTextField.getText());
            if (!this.m_bSliderRangeFixed) {
                this.m_rangeMinimum = Math.min(this.m_rangeMinimum, this.m_currentValue - 0.001);
                this.m_rangeMaximum = Math.max(this.m_rangeMaximum, this.m_currentValue + 0.001);
            } else {
                this.m_currentValue = Math.max(this.m_currentValue, this.m_rangeMinimum);
                this.m_currentValue = Math.min(this.m_currentValue, this.m_rangeMaximum);
            }
            this.writeDataToTextFields();
            this.prepareSliderConversion();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this.m_valueTextField.getDocument()) {
                this.m_valueModified = true;
            }
            if (e.getDocument() == this.m_minRangeTextField.getDocument()) {
                this.m_minModified = true;
            }
            if (e.getDocument() == this.m_maxRangeTextField.getDocument()) {
                this.m_maxModified = true;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this.m_valueTextField.getDocument()) {
                this.m_valueModified = true;
            }
            if (e.getDocument() == this.m_minRangeTextField.getDocument()) {
                this.m_minModified = true;
            }
            if (e.getDocument() == this.m_maxRangeTextField.getDocument()) {
                this.m_maxModified = true;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this.m_valueTextField.getDocument()) {
                this.m_valueModified = true;
            }
            if (e.getDocument() == this.m_minRangeTextField.getDocument()) {
                this.m_minModified = true;
            }
            if (e.getDocument() == this.m_maxRangeTextField.getDocument()) {
                this.m_maxModified = true;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_checkBox) {
                this.m_listenerList.send(this);
                return;
            }
            if (e.getSource() == this.m_valueTextField) {
                this.handleValueTextFieldChanged();
                this.m_listenerList.send(this);
                return;
            }
            if (e.getSource() == this.m_maxRangeTextField) {
                this.m_rangeMaximum = Double.parseDouble(this.m_maxRangeTextField.getText());
                this.m_rangeMinimum = Double.parseDouble(this.m_minRangeTextField.getText());
                this.m_currentValue = Math.min(this.m_currentValue, this.m_rangeMaximum);
                this.m_rangeMinimum = Math.min(this.m_rangeMinimum, this.m_currentValue - 0.01);
            }
            if (e.getSource() == this.m_minRangeTextField) {
                this.m_rangeMinimum = Double.parseDouble(this.m_minRangeTextField.getText());
                this.m_rangeMaximum = Double.parseDouble(this.m_maxRangeTextField.getText());
                this.m_currentValue = Math.max(this.m_currentValue, this.m_rangeMinimum);
                this.m_rangeMaximum = Math.max(this.m_rangeMaximum, this.m_currentValue + 0.01);
            }
            this.writeDataToTextFields();
            this.prepareSliderConversion();
            this.m_listenerList.send(this);
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            try {
                this.m_rangeMinimum = Math.min(this.m_rangeMinimum, this.m_currentValue - 0.01);
                this.m_rangeMaximum = Math.max(this.m_rangeMaximum, this.m_currentValue + 0.01);
                this.writeDataToTextFields();
                this.m_ignoreSliderChangeEvent = true;
                this.m_scale = (double)this.m_slider.getMaximum() / (this.m_rangeMaximum - this.m_rangeMinimum);
                this.m_shift = 0.0 - this.m_rangeMinimum * this.m_scale;
                this.m_slider.setValue((int)(this.m_shift + this.m_scale * this.m_currentValue));
                this.m_ignoreSliderChangeEvent = false;
            }
            catch (Exception error2) {
                ExceptionMonitor.add(error2);
            }
            return;
        }
    }
}

