/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JComponent;

public abstract class ParameterBase
implements IParameterWidgetListener {
    protected ParameterTree m_parameterTree;
    protected String m_parameterName;
    protected String m_tabPageName;
    protected int m_editorVerticalStretch;
    protected int m_editorHorizontalStretch;
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();

    public ParameterTree parameterTree() {
        return this.m_parameterTree;
    }

    public String parameterName() {
        return this.m_parameterName;
    }

    public String tabPageName() {
        return this.m_tabPageName;
    }

    public int editorVerticalStretch() {
        return this.m_editorVerticalStretch;
    }

    public int editorHorizontalStretch() {
        return this.m_editorHorizontalStretch;
    }

    public String getString() throws Exception {
        throw new Exception("Not implemented");
    }

    public double getDouble(double defValue, double min, double max) throws Exception {
        throw new Exception("Not implemented");
    }

    public int getInt(int defvalue, int min, int max) throws Exception {
        throw new Exception("Not implemented");
    }

    public ArrayList<String> getStringList() throws Exception {
        throw new Exception("Not implemented");
    }

    public String getGridString(String gridKey) throws Exception {
        throw new Exception("Not implemented");
    }

    public double getGridDouble(String gridKey, double defValue, double min, double max) throws Exception {
        throw new Exception("Not implemented");
    }

    public int getGridInt(String gridKey, int defvalue, int min, int max) throws Exception {
        throw new Exception("Not implemented");
    }

    public abstract JComponent editor();

    public abstract void updateParametersFromEditor();

    public ParameterBase(ParameterTree pt, String parameterName, String tabPageName, int editorVerticalStretch, int editorHorizontalStretch) {
        try {
            this.m_editorVerticalStretch = Math.max(editorVerticalStretch, 0);
            this.m_editorHorizontalStretch = Math.max(editorHorizontalStretch, 0);
            this.m_parameterName = parameterName;
            if (this.m_parameterName.isEmpty()) {
                this.m_parameterName = "Error";
            }
            this.m_tabPageName = tabPageName;
            if (this.m_tabPageName.isEmpty()) {
                this.m_tabPageName = "Default";
            }
            this.m_parameterTree = pt;
            if (this.m_parameterTree == null) {
                this.m_parameterTree = new ParameterTree();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.updateParametersFromEditor();
            this.broadcast(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearListeners() {
        try {
            this.m_listeners.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void broadcast(Object data) {
        try {
            for (int n = this.m_listeners.size() - 1; n >= 0; --n) {
                WeakReference<Listener> weak = this.m_listeners.get(n);
                Listener listener = (Listener)weak.get();
                if (listener != null) {
                    listener.handleParameterModified(this, data);
                    continue;
                }
                this.m_listeners.remove(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected static interface Listener {
        public void handleParameterModified(ParameterBase var1, Object var2);
    }
}

