/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Tools;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Tools_XML {
    public static ArrayList<Element> getChildListWithTagName(Element node, String tagName) {
        try {
            ArrayList<Element> list = new ArrayList<Element>();
            NodeList nodes = node.getChildNodes();
            for (int n = 0; n < nodes.getLength(); ++n) {
                Element e;
                String childTagName;
                Node childNode = nodes.item(n);
                if (childNode.getNodeType() != 1 || !(childTagName = (e = (Element)childNode).getTagName()).equals(tagName)) continue;
                list.add(e);
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static Element getChildWithTagName(Element node, String tagName, boolean bAddChild) {
        try {
            NodeList nodes = node.getChildNodes();
            for (int n = 0; n < nodes.getLength(); ++n) {
                Element e;
                String childTagName;
                Node childNode = nodes.item(n);
                if (childNode.getNodeType() != 1 || !(childTagName = (e = (Element)childNode).getTagName()).equals(tagName)) continue;
                return e;
            }
            if (!bAddChild) {
                return null;
            }
            Element e = node.getOwnerDocument().createElement(tagName);
            node.appendChild(e);
            return e;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static void fillTree(Element element, JTree tree) {
        try {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(element.getTagName());
            DefaultTreeModel model = new DefaultTreeModel(top);
            Tools_XML.fillTreeRecursion(element, top);
            tree.setModel(model);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void fillTreeRecursion(Element parentElement, DefaultMutableTreeNode parentNode) {
        try {
            NodeList list = parentElement.getChildNodes();
            for (int n = 0; n < list.getLength(); ++n) {
                Node node = list.item(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void addComment(Element element, String comment) {
        try {
            Comment c = element.getOwnerDocument().createComment(comment);
            element.appendChild(c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void addBlockComment(Element element, String comment) {
        try {
            element.appendChild(element.getOwnerDocument().createComment(" ========================================================= "));
            element.appendChild(element.getOwnerDocument().createComment(comment));
            element.appendChild(element.getOwnerDocument().createComment("   "));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void putBoolean(Element element, String attributeName, boolean val) {
        try {
            element.setAttribute(attributeName, Boolean.toString(val));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static boolean getBoolean(Element element, String attributeName, boolean defaultValue) {
        try {
            if (element.hasAttribute(attributeName)) {
                String s = element.getAttribute(attributeName);
                return Boolean.parseBoolean(s);
            }
            return defaultValue;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return defaultValue;
        }
    }

    public static String getString(Element element, String attributeName, String defaultValue) {
        try {
            if (element.hasAttribute(attributeName)) {
                return element.getAttribute(attributeName);
            }
            return defaultValue;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return defaultValue;
        }
    }

    public static void putColor(Element element, String attributeName, Color val) {
        try {
            element.setAttribute(attributeName, Integer.toString(val.getRGB()));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static Color getColor(Element element, String attributeName, Color defaultVal) {
        try {
            if (!element.hasAttribute(attributeName)) {
                return defaultVal;
            }
            String s = element.getAttribute(attributeName);
            int val = Integer.parseInt(s);
            return new Color(val, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return defaultVal;
        }
    }

    public static int getInt(Element element, String attributeName, int defaultValue) {
        try {
            if (element.hasAttribute(attributeName)) {
                String s = element.getAttribute(attributeName);
                return Integer.parseInt(s);
            }
            return defaultValue;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return defaultValue;
        }
    }

    public static double getDouble(Element element, String attributeName, double defaultValue) {
        try {
            if (element.hasAttribute(attributeName)) {
                String s = element.getAttribute(attributeName);
                return Double.parseDouble(s);
            }
            return defaultValue;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return defaultValue;
        }
    }

    public static Document createDocument() throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static String writeDocumentToString(Document doc) throws Exception {
        try {
            String sXml = null;
            StringWriter writer = new StringWriter();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource src = new DOMSource(doc);
            StreamResult dest = new StreamResult(writer);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(src, dest);
            sXml = writer.toString();
            return sXml;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static void writeDocumentToFile(Logger logger, Document doc, String fileName) throws Exception {
        try {
            if (logger != null) {
                logger.log(Level.INFO, "XML, writeDocumentToFile");
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource src = new DOMSource(doc);
            StreamResult dest = new StreamResult(new File(fileName));
            transformer.setOutputProperty("indent", "yes");
            if (logger != null) {
                logger.log(Level.INFO, "XML, writeDocumentToFile call transform");
            }
            transformer.transform(src, dest);
        }
        catch (Exception ex) {
            if (logger != null) {
                logger.log(Level.INFO, ex.getMessage());
            } else {
                ExceptionMonitor.add(ex);
            }
            throw ex;
        }
    }

    public static void writeDocumentToFile(Document doc, String fileName) throws Exception {
        try {
            Tools_XML.writeDocumentToFile(null, doc, fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Document readDocument(String fileName) {
        try {
            if (!Tools_FileSystem.exists_file(fileName)) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fileName);
            document.getDocumentElement().normalize();
            return document;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static Document readDocumentFromString(String sXml) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sXml.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            document.getDocumentElement().normalize();
            return document;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

