/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Tools;

import com.PecosCore.Shared.ExceptionMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class Tools_Strings {
    public static String dateString() {
        try {
            Date date = new Date();
            return date.toString();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    /*
     * Loose catch block
     */
    public static boolean canConvertToDouble(String s) {
        block6: {
            if (s == null) {
                return false;
            }
            if (s.length() >= 1) break block6;
            return false;
            {
                catch (Exception error) {
                    ExceptionMonitor.add(error);
                    return false;
                }
            }
        }
        try {
            double v = Double.parseDouble(s);
            return true;
        }
        catch (Exception v) {
            return false;
        }
    }

    public static boolean listContainsString(ArrayList<String> list, String s, boolean ignoreCase) {
        try {
            for (String str : list) {
                if (!(ignoreCase ? str.equalsIgnoreCase(s) : str.equals(s))) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static String removePrefix(String str, String prefix) throws Exception {
        try {
            if (prefix.length() < 1) {
                return str;
            }
            if (prefix.length() >= str.length()) {
                return str;
            }
            while (str.startsWith(prefix)) {
                int last = str.length();
                int start = prefix.length();
                str = str.substring(start, last);
            }
            return str;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String removeSuffix(String str, String suffix) throws Exception {
        try {
            if (suffix.length() < 1) {
                return str;
            }
            if (suffix.length() >= str.length()) {
                return str;
            }
            while (str.endsWith(suffix)) {
                int index = str.length() - suffix.length();
                str = str.substring(0, index);
            }
            return str;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String removeFileSuffix(String str) throws Exception {
        try {
            if (!str.contains(".")) {
                return str;
            }
            int index = str.indexOf(".");
            return str.substring(0, index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static boolean startsWithIgnoreCase(String s1, String prefix) {
        try {
            if (s1.length() < prefix.length()) {
                return false;
            }
            String start = s1.substring(0, prefix.length());
            return start.equalsIgnoreCase(prefix);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static ArrayList<String> getUniqueStrings(ArrayList<String> input, boolean ignoreCase) {
        try {
            ArrayList<String> unique = new ArrayList<String>();
            if (input == null) {
                return unique;
            }
            for (String s : input) {
                if (s.length() <= 0) continue;
                boolean ok = true;
                for (String u : unique) {
                    if (ignoreCase) {
                        if (!s.equalsIgnoreCase(u)) continue;
                        ok = false;
                        continue;
                    }
                    if (!s.equals(u)) continue;
                    ok = false;
                }
                if (!ok) continue;
                unique.add(s);
            }
            return unique;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static String doubleToString(double val, double range, boolean bCheckIfInt) {
        try {
            long v;
            double diff;
            if (bCheckIfInt && (diff = Math.abs(val - (double)(v = Math.round(val)))) < 1.0E-5) {
                return Long.toString(v);
            }
            return Tools_Strings.doubleToString(val, range);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Double.toString(val);
        }
    }

    public static String doubleToString(double val, double range) {
        try {
            range = Math.abs(range);
            if (range < 1.0E-6) {
                return Double.toString(val);
            }
            if (Math.abs(val) < 1.0E-5 * range) {
                return "0.0";
            }
            int pow = (int)Math.round(Math.log10(range));
            int num = 3 - pow;
            num = Math.max(1, num);
            num = Math.min(5, num);
            return Tools_Strings.getString(val, num);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Double.toString(val);
        }
    }

    public static String getString(double val, int num) {
        try {
            if (Math.abs(val) < 1.0E-7) {
                return "0";
            }
            String string = String.format("%f", val);
            if (!string.contains(".")) {
                return string;
            }
            int indexOfDot = string.indexOf(".");
            int len = indexOfDot + num + 1;
            len = Math.min(len, string.length());
            return string.substring(0, len);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Double.toString(val);
        }
    }

    public static String runTimeMessage(int seconds) {
        try {
            if (seconds < 60) {
                String s = Integer.toString(seconds) + " seconds";
                return s;
            }
            int minutes = seconds / 60;
            seconds %= 60;
            if (minutes < 60) {
                String s = Integer.toString(minutes) + " min, " + Integer.toString(seconds) + " sec";
                return s;
            }
            int hours = minutes / 60;
            minutes %= 60;
            if (hours < 24) {
                String s = Integer.toString(hours) + " h, " + Integer.toString(minutes) + " m, " + Integer.toString(seconds) + " s";
                return s;
            }
            int days = hours / 24;
            String s = Integer.toString(days) + " d, " + Integer.toString(hours %= 24) + " h, " + Integer.toString(minutes) + " m, " + Integer.toString(seconds) + " s";
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "0 sec";
        }
    }

    public static boolean startsWithNumber(String s) {
        try {
            if (s == null) {
                return false;
            }
            if (s.length() < 1) {
                return false;
            }
            char[] chars = s.toCharArray();
            char c = chars[0];
            return c >= '0' && c <= '9';
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean containsDoubleChar(String s, char c) {
        try {
            char[] chars = s.toCharArray();
            for (int x = 0; x < chars.length - 1; ++x) {
                char c1 = chars[x];
                char c2 = chars[x + 1];
                if (c != c1 || c != c2) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static String removeMostSpecialChars(String s) {
        try {
            if (s == null) {
                return "";
            }
            if (s.isEmpty()) {
                return "";
            }
            char[] chars = s.toCharArray();
            int numOkay = 0;
            char[] str = null;
            for (int iter = 1; iter <= 2; ++iter) {
                numOkay = 0;
                for (int x = 0; x < chars.length; ++x) {
                    boolean other;
                    char c = chars[x];
                    boolean lower = c >= 'a' && c <= 'z';
                    boolean upper = c >= 'A' && c <= 'Z';
                    boolean numeric = c >= '0' && c <= '9';
                    boolean bl = other = c == '+' || c == '-' || c == '.' || c == ',';
                    if (!lower && !upper && !numeric && !other) continue;
                    if (iter == 2) {
                        str[numOkay] = c;
                    }
                    ++numOkay;
                }
                if (numOkay < 1) {
                    return "";
                }
                if (iter != 1) {
                    return new String(str);
                }
                str = new char[numOkay];
            }
            return "";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public static String removeCrap(String s) {
        try {
            return Tools_Strings.removeCrap(s, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public static String removeCrap(String s, boolean underscoreOkay) {
        try {
            if (s == null) {
                return "";
            }
            char[] chars = s.toCharArray();
            int numOkay = 0;
            for (int x = 0; x < chars.length; ++x) {
                boolean underscore;
                char c = chars[x];
                boolean lower = c >= 'a' && c <= 'z';
                boolean upper = c >= 'A' && c <= 'Z';
                boolean numeric = c >= '0' && c <= '9';
                boolean bl = underscore = c == '_' && underscoreOkay;
                if (!lower && !upper && !numeric && !underscore) continue;
                ++numOkay;
            }
            if (numOkay < 1) {
                return "";
            }
            char[] str = new char[numOkay];
            numOkay = 0;
            for (int x = 0; x < chars.length; ++x) {
                boolean underscore;
                char c = chars[x];
                boolean lower = c >= 'a' && c <= 'z';
                boolean upper = c >= 'A' && c <= 'Z';
                boolean numeric = c >= '0' && c <= '9';
                boolean bl = underscore = c == '_' && underscoreOkay;
                if (!lower && !upper && !numeric && !underscore) continue;
                str[numOkay] = c;
                ++numOkay;
            }
            return new String(str);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public static boolean underscoreStart(String s) {
        try {
            char[] chars = s.toCharArray();
            if (chars.length < 1) {
                return false;
            }
            return chars[0] == '_';
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean underscoreEnd(String s) {
        try {
            char[] chars = s.toCharArray();
            if (chars.length < 1) {
                return false;
            }
            return chars[chars.length - 1] == '_';
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean okForColumnName(String s) {
        try {
            if (s == null) {
                JOptionPane.showMessageDialog(null, "Name cannot be null", "Column name not valid", 0);
                return false;
            }
            if (s.length() < 1) {
                JOptionPane.showMessageDialog(null, "Name cannot be zero length", "Column name not valid", 0);
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(s, true, true)) {
                JOptionPane.showMessageDialog(null, "Name must be alphanumeric", "Column name not valid", 0);
                return false;
            }
            if (Tools_Strings.startsWithNumber(s)) {
                JOptionPane.showMessageDialog(null, "Name cannot start with a number", "Column name not valid", 0);
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean isBlankLine(String s) {
        try {
            if (s == null) {
                return true;
            }
            if (s.length() < 1) {
                return true;
            }
            char[] chars = s.toCharArray();
            for (int n = 0; n < chars.length; ++n) {
                if (' ' == chars[n]) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            return true;
        }
    }

    public static String removeLeadingAndTrailingSpaces(String s) {
        try {
            s = Tools_Strings.removeTrailingSpaces(s);
            return Tools_Strings.removeLeadingSpaces(s);
        }
        catch (Exception error) {
            return "";
        }
    }

    public static String removeTrailingSpaces(String s) {
        try {
            int len;
            if (Tools_Strings.isBlankLine(s)) {
                return "";
            }
            char[] chars = s.toCharArray();
            if (chars[(len = chars.length) - 1] != ' ') {
                return s;
            }
            for (int n = len - 2; n >= 0; --n) {
                if (' ' == chars[n]) continue;
                return s.substring(0, n + 1);
            }
            return "";
        }
        catch (Exception error) {
            return "";
        }
    }

    public static String removeLeadingSpaces(String s) {
        try {
            if (Tools_Strings.isBlankLine(s)) {
                return "";
            }
            char[] chars = s.toCharArray();
            if (chars[0] != ' ') {
                return s;
            }
            for (int n = 1; n < chars.length; ++n) {
                if (' ' == chars[n]) continue;
                return s.substring(n, chars.length);
            }
            return "";
        }
        catch (Exception error) {
            return "";
        }
    }

    public static double toDouble(String s, double defVal) {
        try {
            double v = Double.parseDouble(s);
            return v;
        }
        catch (Exception error) {
            return defVal;
        }
    }

    public static int toInt(String s, int defVal) {
        try {
            s = Tools_Strings.removeLeadingAndTrailingSpaces(s);
            int v = Integer.parseInt(s);
            return v;
        }
        catch (Exception error) {
            return defVal;
        }
    }

    public static long toLong(String s, long defVal) {
        try {
            s = Tools_Strings.removeLeadingAndTrailingSpaces(s);
            long v = Long.parseLong(s);
            return v;
        }
        catch (Exception error) {
            return defVal;
        }
    }

    public static boolean isAlphaNumeric(String s, boolean bAllowNumeric, boolean bAllowUnderscore) {
        try {
            return Tools_Strings.isAlphaNumeric(s, bAllowNumeric, bAllowUnderscore, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean startsWithLetterOrNumber(String s) {
        try {
            if (s == null) {
                return false;
            }
            char[] chars = s.toCharArray();
            if (chars.length < 1) {
                return false;
            }
            char c = chars[0];
            boolean lower = c >= 'a' && c <= 'z';
            boolean upper = c >= 'A' && c <= 'Z';
            boolean numeric = c >= '0' && c <= '9';
            return lower || upper || numeric;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static boolean isAlphaNumeric(String s, boolean bAllowNumeric, boolean bAllowUnderscore, boolean allowDash) {
        try {
            if (s == null) {
                return false;
            }
            char[] chars = s.toCharArray();
            for (int x = 0; x < chars.length; ++x) {
                boolean ok;
                char c = chars[x];
                boolean lower = c >= 'a' && c <= 'z';
                boolean upper = c >= 'A' && c <= 'Z';
                boolean numeric = c >= '0' && c <= '9';
                boolean underscore = c == '_';
                boolean dash = c == '-';
                boolean underscoreOK = underscore && bAllowUnderscore;
                boolean dashOK = dash && allowDash;
                boolean bl = ok = lower || upper || underscoreOK || dashOK;
                if (ok) continue;
                if (!numeric) {
                    return false;
                }
                if (bAllowNumeric) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static String removeSpace(String s) {
        try {
            if (s == null) {
                return "";
            }
            if (s.length() < 1) {
                return "";
            }
            String[] tokens = s.split(" ");
            Object result = "";
            for (String token : tokens) {
                result = (String)result + token;
            }
            return result;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return s;
        }
    }

    public static boolean isAllSpace(String s) {
        try {
            char[] chars;
            for (char c : chars = s.toCharArray()) {
                if (c == ' ') continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static ArrayList<String> tokenizer_improved(String s, char delim) {
        try {
            char[] chars = s.toCharArray();
            int[] index = new int[10 + s.length()];
            int numDelim = 0;
            for (int x = 0; x < chars.length; ++x) {
                if (delim != chars[x]) continue;
                index[numDelim] = x;
                ++numDelim;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (numDelim < 1) {
                list.add(s);
                return list;
            }
            if (chars[0] == delim) {
                list.add("NULL");
            } else {
                list.add(s.substring(0, index[0]));
            }
            for (int d = 0; d < numDelim - 1; ++d) {
                if (index[d] == index[d + 1] - 1) {
                    list.add("NULL");
                    continue;
                }
                list.add(s.substring(index[d] + 1, index[d + 1]));
            }
            if (chars[chars.length - 1] == delim) {
                list.add("NULL");
            } else {
                list.add(s.substring(index[numDelim - 1] + 1, chars.length));
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> tokenizer_space(String s, boolean includeEmpty) {
        try {
            String[] tokens;
            ArrayList<String> list = new ArrayList<String>();
            String str = s.replace('\t', ' ');
            for (String token : tokens = str.split(" ")) {
                if (!includeEmpty && token.length() <= 0) continue;
                list.add(token);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> tokenizer_period(String s, boolean includeEmpty) {
        try {
            String[] tokens;
            ArrayList<String> list = new ArrayList<String>();
            for (String token : tokens = s.split(".")) {
                if (!includeEmpty && token.length() <= 0) continue;
                list.add(token);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> tokenizer_comma(String s, boolean includeEmpty) {
        try {
            String[] tokens;
            ArrayList<String> list = new ArrayList<String>();
            for (String token : tokens = s.split(",")) {
                if (!includeEmpty && token.length() <= 0) continue;
                list.add(token);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> tokenizer(String s, String separator, boolean includeEmpty) {
        try {
            String[] tokens;
            ArrayList<String> list = new ArrayList<String>();
            for (String token : tokens = s.split(separator)) {
                if (!includeEmpty && token.length() <= 0) continue;
                list.add(token);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> tokenizer(String s) {
        try {
            String[] tokens;
            ArrayList<String> list = new ArrayList<String>();
            for (String token : tokens = s.split(" ")) {
                if (token.length() <= 0) continue;
                list.add(token);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    public static String confirmSuffixNew(String str, String suffix) {
        try {
            if (suffix == null) {
                return str;
            }
            if (suffix.length() < 1) {
                return str;
            }
            if (suffix.contains(".")) {
                return str;
            }
            int index = str.indexOf(".");
            if (index <= 0) {
                return str + "." + suffix;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, File.pathSeparator, false);
            char c1 = File.pathSeparatorChar;
            char c2 = File.separatorChar;
            char c3 = '\\';
            char[] chars = str.toCharArray();
            int lastSep = 0;
            for (int n = 0; n < chars.length; ++n) {
                if (chars[n] != c1 && chars[n] != c2 && chars[n] != c3) continue;
                lastSep = n;
            }
            int lastPeriod = str.lastIndexOf(".");
            if (lastPeriod >= lastSep) {
                String s = str.substring(0, lastPeriod);
                return s + "." + suffix;
            }
            return str + "." + suffix;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return str;
        }
    }

    public static void testConfirmSuffix() {
        try {
            Tools_Strings.testConfirmSuffix("/home/matt/junk", "sgy");
            Tools_Strings.testConfirmSuffix("/home/matt/junk.old", "sgy");
            Tools_Strings.testConfirmSuffix("/home/matt.windows/junk", "sgy");
            Tools_Strings.testConfirmSuffix("/home/matt.windows/junk.old", "sgy");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void testConfirmSuffix(String str, String suffix) {
        try {
            String s = Tools_Strings.confirmSuffixNew(str, suffix);
            System.out.println("str = " + str + ", suffix = " + suffix + ", output ===> " + s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static String confirmSuffix(String str, String suffix) {
        try {
            return Tools_Strings.confirmSuffixNew(str, suffix);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return str;
        }
    }
}

