/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Tools;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Shared.ExceptionMonitor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Tools_ByteArray {
    public static void populateFloatUsingShort(ByteOrder inputByteOrder, byte[] inputArray, float[] outputArray) throws Exception {
        try {
            Tools_ByteArray.populateFloatUsingShort(inputByteOrder, inputArray, 0, outputArray);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void populateFloatUsingShort(ByteOrder inputByteOrder, byte[] inputArray, int offset, float[] outputArray) throws Exception {
        try {
            int validOutputLength;
            int rawSampleCount = inputArray.length / 2;
            for (int n = validOutputLength = Math.min(outputArray.length, rawSampleCount); n < outputArray.length; ++n) {
                outputArray[n] = 0.0f;
            }
            int len = 2 * validOutputLength;
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, len);
            buffer.order(inputByteOrder);
            ((Buffer)buffer).rewind();
            byte[] buff = buffer.array();
            for (int s = 0; s < len; ++s) {
                buff[s] = inputArray[s + offset];
            }
            ((Buffer)buffer).rewind();
            for (int n = 0; n < validOutputLength; ++n) {
                outputArray[n] = buffer.getShort();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void populateFloatUsingIEEE(ByteOrder inputByteOrder, byte[] inputArray, float[] outputArray) throws Exception {
        try {
            Tools_ByteArray.populateFloatUsingIEEE(inputByteOrder, inputArray, 0, outputArray);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void populateFloatUsingIEEE(ByteOrder inputByteOrder, byte[] inputArray, int offset, float[] outputArray) throws Exception {
        try {
            int validOutputLength;
            int rawSampleCount = inputArray.length / 4;
            for (int n = validOutputLength = Math.min(outputArray.length, rawSampleCount); n < outputArray.length; ++n) {
                outputArray[n] = 0.0f;
            }
            int len = 4 * validOutputLength;
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, len);
            buffer.order(inputByteOrder);
            ((Buffer)buffer).rewind();
            byte[] buff = buffer.array();
            for (int s = 0; s < len; ++s) {
                buff[s] = inputArray[s + offset];
            }
            buffer.rewind();
            for (int n = 0; n < validOutputLength; ++n) {
                outputArray[n] = buffer.getFloat();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static float extractFloatUsingIBM(byte[] inputArray, int inputArrayIndex) throws Exception {
        try {
            boolean isZero;
            double Alpha = 16.0;
            double Beta = 64.0;
            double Exp24 = 1.6777216E7;
            byte byte1 = inputArray[inputArrayIndex + 0];
            byte byte2 = inputArray[inputArrayIndex + 1];
            byte byte3 = inputArray[inputArrayIndex + 2];
            byte byte4 = inputArray[inputArrayIndex + 3];
            int intVal1 = byte1 & 0x7F;
            if (byte1 < 0) {
                intVal1 += 128;
            }
            int intVal2 = byte2 & 0x7F;
            if (byte2 < 0) {
                intVal2 += 128;
            }
            int intVal3 = byte3 & 0x7F;
            if (byte3 < 0) {
                intVal3 += 128;
            }
            int intVal4 = byte4 & 0x7F;
            if (byte4 < 0) {
                intVal4 += 128;
            }
            byte sign = (byte)((intVal1 & 0x80) >> 7);
            int exponent = intVal1 & 0x7F;
            long fraction = (intVal2 << 16) + (intVal3 << 8) + intVal4;
            double tempDouble1 = (double)fraction / Exp24;
            double tempDouble2 = 1.0;
            tempDouble2 = sign == 0 ? 1.0 : -1.0;
            boolean bl = isZero = sign == 0 && exponent == 0 && fraction == 0L;
            if (!isZero) {
                return (float)(tempDouble2 * tempDouble1 * Math.pow(Alpha, (double)exponent - Beta));
            }
            return 0.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void populateFloatUsingIBM(byte[] inputArray, float[] outputArray) throws Exception {
        try {
            Tools_ByteArray.populateFloatUsingIBM(inputArray, 0, outputArray);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void populateFloatUsingIBM(byte[] inputArray, int inputOffset, float[] outputArray) throws Exception {
        try {
            int validOutputLength;
            double Alpha = 16.0;
            double Beta = 64.0;
            double Exp24 = 1.6777216E7;
            int rawSampleCount = inputArray.length / 4;
            for (int n = validOutputLength = Math.min(outputArray.length, rawSampleCount); n < outputArray.length; ++n) {
                outputArray[n] = 0.0f;
            }
            int inputArrayIndex = inputOffset;
            int numFunky = 0;
            for (int n = 0; n < validOutputLength; ++n) {
                boolean isZero;
                byte byte1 = inputArray[inputArrayIndex + 0];
                byte byte2 = inputArray[inputArrayIndex + 1];
                byte byte3 = inputArray[inputArrayIndex + 2];
                byte byte4 = inputArray[inputArrayIndex + 3];
                int intVal1 = byte1 & 0x7F;
                if (byte1 < 0) {
                    intVal1 += 128;
                }
                int intVal2 = byte2 & 0x7F;
                if (byte2 < 0) {
                    intVal2 += 128;
                }
                int intVal3 = byte3 & 0x7F;
                if (byte3 < 0) {
                    intVal3 += 128;
                }
                int intVal4 = byte4 & 0x7F;
                if (byte4 < 0) {
                    intVal4 += 128;
                }
                byte sign = (byte)((intVal1 & 0x80) >> 7);
                int exponent = intVal1 & 0x7F;
                long fraction = (intVal2 << 16) + (intVal3 << 8) + intVal4;
                double tempDouble1 = (double)fraction / Exp24;
                double tempDouble2 = 1.0;
                tempDouble2 = sign == 0 ? 1.0 : -1.0;
                boolean bl = isZero = sign == 0 && exponent == 0 && fraction == 0L;
                if (!isZero) {
                    boolean funky;
                    float sample = (float)(tempDouble2 * tempDouble1 * Math.pow(Alpha, (double)exponent - Beta));
                    boolean bl2 = funky = Float.isInfinite(sample) || Float.isNaN(sample);
                    if (!funky) {
                        outputArray[n] = sample;
                    } else {
                        ++numFunky;
                    }
                } else {
                    outputArray[n] = 0.0f;
                }
                inputArrayIndex += 4;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static void convertFloatToIBM(byte[] outputArray, float[] inputArray, int maxCount) throws Exception {
        try {
            double Exp24 = 1.6777216E7;
            int count = Math.min(inputArray.length, maxCount);
            for (int n = 0; n < count; ++n) {
                int outputArrayIndex = n * 4;
                outputArray[outputArrayIndex + 0] = 0;
                outputArray[outputArrayIndex + 1] = 0;
                outputArray[outputArrayIndex + 2] = 0;
                outputArray[outputArrayIndex + 3] = 0;
                float v = inputArray[n];
                if (!(Math.abs(v) > 1.0E-30f)) continue;
                boolean negative = false;
                if (v < 0.0f) {
                    negative = true;
                    v = -v;
                }
                int exp = (int)(Math.log(v) / Math.log(2.0) / 4.0 + 1.0 + 64.0);
                double frac = (double)v / Math.pow(16.0, exp - 64);
                int tf = (int)(Exp24 * frac);
                int byte3 = tf & 0xFF;
                int byte2 = (tf /= 256) & 0xFF;
                int byte1 = (tf /= 256) & 0xFF;
                int byte0 = exp;
                if (negative) {
                    byte0 += 128;
                }
                outputArray[outputArrayIndex + 3] = (byte)Tools_ByteArray.convertInt(byte3);
                outputArray[outputArrayIndex + 2] = (byte)Tools_ByteArray.convertInt(byte2);
                outputArray[outputArrayIndex + 1] = (byte)Tools_ByteArray.convertInt(byte1);
                outputArray[outputArrayIndex + 0] = (byte)Tools_ByteArray.convertInt(byte0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static int convertInt(int v) {
        try {
            if (v < 128) {
                return (byte)v;
            }
            return -((byte)(256 - v));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }
}

