/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Shared.ExceptionMonitor;

public class Range_Int {
    protected boolean m_rangeValid = false;
    protected int m_rangeMin = 0;
    protected int m_rangeMax = 0;

    public boolean insideRange(int v) {
        if (!this.m_rangeValid) {
            return false;
        }
        return v >= this.m_rangeMin && v <= this.m_rangeMax;
    }

    public void clearRange() {
        this.m_rangeValid = false;
    }

    public boolean rangeValid() {
        return this.m_rangeValid;
    }

    public int range() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return this.m_rangeMax - this.m_rangeMin;
    }

    public int rangeMin() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return this.m_rangeMin;
    }

    public int rangeMax() throws Exception {
        if (!this.m_rangeValid) {
            throw new Exception("Range not valid");
        }
        return this.m_rangeMax;
    }

    public void expandRange(Range_Int r) {
        try {
            if (r == null) {
                return;
            }
            if (!r.rangeValid()) {
                return;
            }
            this.expandRange(r.rangeMax());
            this.expandRange(r.rangeMin());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void expandRange(int[] v) {
        try {
            if (v == null) {
                return;
            }
            if (v.length < 1) {
                return;
            }
            this.expandRange(v[0]);
            for (int n = 0; n < v.length; ++n) {
                this.m_rangeMin = Math.min(this.m_rangeMin, v[n]);
                this.m_rangeMax = Math.max(this.m_rangeMax, v[n]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void expandRange(int v) {
        if (this.m_rangeValid) {
            this.m_rangeMin = Math.min(this.m_rangeMin, v);
            this.m_rangeMax = Math.max(this.m_rangeMax, v);
        } else {
            this.m_rangeMin = v;
            this.m_rangeMax = v;
            this.m_rangeValid = true;
        }
    }
}

