/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Data.Column_Bool;
import com.PecosCore.Data.Column_Long;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import java.awt.Cursor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class Messenger {
    protected int m_selectedShotID;
    protected int m_selectedReceiverID;
    public Column_Long SelectedTraces = new Column_Long();
    public Column_Bool TracePolarity = new Column_Bool();
    public int SelectedTraceCount = 0;
    public int ShotID;
    public int ReceiverID;
    public int Inline;
    public int Crossline;
    public int Bin2D;
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();
    protected static Messenger m_singleton = null;

    public int selectedShotID() {
        return this.m_selectedShotID;
    }

    public int selectedReceiverID() {
        return this.m_selectedReceiverID;
    }

    protected Messenger() {
    }

    public static Messenger singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Messenger();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void clearListeners() {
        try {
            this.m_listeners.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static int bin2D() {
        try {
            return Messenger.singleton().Bin2D;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static int inline() {
        try {
            return Messenger.singleton().Inline;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static int crossline() {
        try {
            return Messenger.singleton().Crossline;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static void broadcastReloadAllGathers(Object sender) {
        try {
            System.out.println("Messenger.broadcastReloadAllGathers(Object sender)");
            Messenger messenger = Messenger.singleton();
            messenger.broadcastMessage(Message.ReloadAllGathers, sender, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastDelayTimeDataModifid(Object sender) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.broadcastMessage(Message.DelayTimeDataModified, sender, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastBin2DSelected(Object sender, int bin) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.Bin2D = bin;
            messenger.broadcastMessage(Message.Bin2DSelected, sender, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastBin3DSelected(Object sender, int inline, int crossline) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.Inline = inline;
            messenger.Crossline = crossline;
            messenger.broadcastMessage(Message.Bin3DSelected, sender, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastTracePolarityFlipped(Object sender) {
        try {
            Messenger messenger = Messenger.singleton();
            if (messenger.SelectedTraceCount < 1) {
                return;
            }
            messenger.broadcastMessage(Message.TracePolarityFlipped, sender, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void addSelectedTraceWithPolarity(long traceIndex, boolean polarity) {
        try {
            int num = Messenger.singleton().SelectedTraceCount;
            Messenger.singleton().SelectedTraces.putLong(num, traceIndex);
            Messenger.singleton().TracePolarity.putBool(num, polarity);
            Messenger.singleton().SelectedTraceCount = num + 1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void resetSelectedTraceCount() {
        Messenger.singleton().SelectedTraceCount = 0;
    }

    public static int selectedTraceCount() {
        return Messenger.singleton().SelectedTraceCount;
    }

    public static Column_Long selectedTraces() {
        try {
            return Messenger.singleton().SelectedTraces;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static Column_Bool selectedTracePolarity() {
        try {
            return Messenger.singleton().TracePolarity;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static int shotID() {
        try {
            return Messenger.singleton().ShotID;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static void broadcastShotSelected(Object sender, int shotID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ShotID = shotID;
            messenger.broadcastMessage(Message.ShotSelected, sender, new Integer(shotID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastShotGeometryChanged(Object sender, int shotID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ShotID = shotID;
            messenger.broadcastMessage(Message.ShotGeometryChanged, sender, new Integer(shotID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastShotDelayTimeChanged(Object sender, int shotID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ShotID = shotID;
            messenger.broadcastMessage(Message.ShotDelayTimeChanged, sender, new Integer(shotID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastShotKilled(Object sender, int shotID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ShotID = shotID;
            messenger.broadcastMessage(Message.ShotKilled, sender, new Integer(shotID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastShotPolarityFlipped(Object sender, int shotID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ShotID = shotID;
            messenger.broadcastMessage(Message.ShotPolarityFlipped, sender, new Integer(shotID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static int receiverID() {
        try {
            return Messenger.singleton().ReceiverID;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    public static void broadcastReceiverSelected(Object sender, int receiverID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ReceiverID = receiverID;
            messenger.broadcastMessage(Message.ReceiverSelected, sender, new Integer(receiverID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastReceiverGeometryChanged(Object sender, int receiverID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ReceiverID = receiverID;
            messenger.broadcastMessage(Message.ReceiverGeometryChanged, sender, new Integer(receiverID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastReceiverDelayTimeChanged(Object sender, int receiverID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ReceiverID = receiverID;
            messenger.broadcastMessage(Message.ReceiverDelayTimeChanged, sender, new Integer(receiverID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastReceiverKilled(Object sender, int receiverID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ReceiverID = receiverID;
            messenger.broadcastMessage(Message.ReceiverKilled, sender, new Integer(receiverID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastReceiverPolarityFlipped(Object sender, int receiverID) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ReceiverID = receiverID;
            messenger.broadcastMessage(Message.ReceiverPolarityFlipped, sender, new Integer(receiverID));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void broadcastTraceSelected(Object sender, int shotID, int receiverID, int inline, int crossline) {
        try {
            Messenger messenger = Messenger.singleton();
            messenger.ShotID = shotID;
            messenger.ReceiverID = receiverID;
            messenger.Inline = inline;
            messenger.Crossline = crossline;
            messenger.broadcastMessage(Message.TraceSelected, sender, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void broadcastMessage(Message message, Object sender, Object data) {
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        try {
            if (data != null && data instanceof Integer) {
                int v = (Integer)data;
                if (message == Message.ShotSelected) {
                    this.ShotID = v;
                }
                if (message == Message.ShotGeometryChanged) {
                    this.ShotID = v;
                }
                if (message == Message.ReceiverSelected) {
                    this.ReceiverID = (Integer)data;
                }
                if (message == Message.ReceiverGeometryChanged) {
                    this.ReceiverID = (Integer)data;
                }
            }
            for (int n = this.m_listeners.size() - 1; n >= 0; --n) {
                WeakReference<Listener> weak = this.m_listeners.get(n);
                Listener listener = (Listener)weak.get();
                if (listener != null) {
                    listener.handleMessenger(message, sender, data);
                    continue;
                }
                this.m_listeners.remove(n);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static void broadcast(Message message, Object sender, Object data) {
        try {
            Messenger.singleton().broadcastMessage(message, sender, data);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static enum Message {
        ExceptionCaught,
        UpdateBranchOptionChanged,
        ProfileSemblanceRecomputed,
        ReloadAllGathers,
        DelayTimeDataModified,
        ShotKilled,
        ReceiverKilled,
        TracePolarityFlipped,
        ShotPolarityFlipped,
        ReceiverPolarityFlipped,
        VelocityFunctionAdded,
        TraceTableReloaded,
        ColumnsModified,
        TraceSelected,
        ShotSelected,
        ReceiverSelected,
        Bin3DSelected,
        Bin2DSelected,
        PicksChanged,
        PickColumnAdded,
        PickEventChanged,
        ReceiverGeometryChanged,
        ShotGeometryChanged,
        ReceiverDelayTimeChanged,
        ShotDelayTimeChanged,
        ProjectVersionChanged,
        ProjectPolygonModified,
        MoveoutTrendModified,
        SelectedProfileChanged,
        Rebinned,
        EikonalModelChanged,
        TomoVNSModelChanged,
        GliModelChanged,
        UpholeModelChanged,
        HvaComputed,
        CoordInterpProjectOpened,
        OffsetBinSizeChanged;

    }

    public static interface Listener {
        public void handleMessenger(Message var1, Object var2, Object var3);
    }
}

