/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Math;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import java.awt.geom.Point2D;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.List;

public class Grid3D_Conversion
implements Serializable {
    public double m_worldCoordAtOriginX = 0.0;
    public double m_worldCoordAtOriginY = 0.0;
    public int m_inlineAtOrigin = 0;
    public int m_crosslineAtOrigin = 0;
    public int m_inlineIncrement = 1;
    public int m_crosslineIncrement = 1;
    public double m_inlineBinSize = 25.0;
    public double m_crosslineBinSize = 25.0;
    public double m_inlineAngle = 0.0;
    protected double m_cosineInlineAngle = 0.0;
    protected double m_sineInlineAngle = 0.0;
    protected double m_inverseInlineIncrement = 1.0;
    protected double m_inverseCrosslineIncrement = 1.0;
    protected double m_inverseInlineBinSize = 1.0;
    protected double m_inverseCrosslineBinSize = 1.0;
    protected int m_minInline;
    protected int m_maxInline;
    protected int m_numInline;
    protected int m_minCrossline;
    protected int m_maxCrossline;
    protected int m_numCrossline;
    public double MinGridX;
    public double MinGridY;
    public double WorldCoordAtMinCornerY;
    public double WorldCoordAtMinCornerX;
    public static final String FileName = "GridDefinition3D.xml";
    public static final String OriginX = "OriginX";
    public static final String OriginY = "OriginY";
    public static final String OriginInline = "OriginInline";
    public static final String OriginCrossline = "OriginCrossline";
    public static final String InlineIncrement = "InlineIncrement";
    public static final String CrosslineIncrement = "CrosslineIncrement";
    public static final String InlineSize = "InlineSize";
    public static final String CrosslineSize = "CrosslineSize";
    public static final String Angle = "Angle";
    public double WorldX;
    public double WorldY;
    public double GridX;
    public double GridY;
    public int InlineIndex;
    public int CrosslineIndex;
    public int Inline;
    public int Crossline;
    public int InlineGridIndex;
    public int CrosslineGridIndex;

    public double inlineAngle() {
        return this.m_inlineAngle;
    }

    public void setInlineAngle(double inlineAngle) {
        this.m_inlineAngle = inlineAngle;
        this.computeInternals(true);
    }

    public void setInlineAtOrigin(int inlineAtOrigin) {
        this.m_inlineAtOrigin = inlineAtOrigin;
    }

    public int inlineAtOrigin() {
        return this.m_inlineAtOrigin;
    }

    public void setCrosslineAtOrigin(int crosslineAtOrigin) {
        this.m_crosslineAtOrigin = crosslineAtOrigin;
    }

    public int crosslineAtOrigin() {
        return this.m_crosslineAtOrigin;
    }

    public int crosslineIncrement() {
        return this.m_crosslineIncrement;
    }

    public int inlineIncrement() {
        return this.m_inlineIncrement;
    }

    public void setBinCounts(int numX, int numY) {
        this.m_minInline = 0;
        this.m_minCrossline = 0;
        this.m_numInline = numX;
        this.m_numCrossline = numY;
        this.m_maxInline = this.m_minInline + this.m_numInline - 1;
        this.m_maxCrossline = this.m_minCrossline + this.m_numCrossline - 1;
    }

    public int inlineMin() {
        return this.m_minInline;
    }

    public int inlineMax() {
        return this.m_maxInline;
    }

    public int crosslineMin() {
        return this.m_minCrossline;
    }

    public int crosslineMax() {
        return this.m_maxCrossline;
    }

    public void prepareRangeFinder() {
        this.MinGridX = Double.MAX_VALUE;
        this.MinGridY = Double.MAX_VALUE;
        this.m_minCrossline = Integer.MAX_VALUE;
        this.m_maxCrossline = Integer.MIN_VALUE;
        this.m_minInline = Integer.MAX_VALUE;
        this.m_maxInline = Integer.MIN_VALUE;
    }

    public void addToRangeFinder(double x, double y) {
        this.setWorldLocation(x, y);
        this.m_minInline = Math.min(this.m_minInline, this.Inline);
        this.m_maxInline = Math.max(this.m_maxInline, this.Inline);
        this.m_minCrossline = Math.min(this.m_minCrossline, this.Crossline);
        this.m_maxCrossline = Math.max(this.m_maxCrossline, this.Crossline);
        this.MinGridX = Math.min(this.MinGridX, this.GridX);
        this.MinGridY = Math.min(this.MinGridY, this.GridY);
        this.WorldCoordAtMinCornerX = this.m_worldCoordAtOriginX + this.m_cosineInlineAngle * this.MinGridX - this.m_sineInlineAngle * this.MinGridY;
        this.WorldCoordAtMinCornerY = this.m_worldCoordAtOriginY + this.m_cosineInlineAngle * this.MinGridY + this.m_sineInlineAngle * this.MinGridX;
    }

    public void addToRangeFinder(double x, double y, double buffer) {
        this.addToRangeFinder(x - buffer, y - buffer);
        this.addToRangeFinder(x - buffer, y + buffer);
        this.addToRangeFinder(x + buffer, y - buffer);
        this.addToRangeFinder(x + buffer, y + buffer);
    }

    public int numInline() {
        if (this.m_maxInline <= this.m_minInline) {
            return 0;
        }
        return this.m_maxInline - this.m_minInline + 1;
    }

    public int numCrossline() {
        if (this.m_maxCrossline <= this.m_minCrossline) {
            return 0;
        }
        return this.m_maxCrossline - this.m_minCrossline + 1;
    }

    public Grid3D_Conversion() {
        this.computeInternals(true);
        this.prepareRangeFinder();
    }

    public Grid3D_Conversion(double worldX, double worldY, int inlineAtOrigin, int crosslineAtOrigin, int inlineIncrement, int crosslineIncrement, double inlineBinSize, double crosslineBinSize, double inlineAngle) {
        this.m_worldCoordAtOriginX = worldX;
        this.m_worldCoordAtOriginY = worldY;
        this.m_inlineAtOrigin = inlineAtOrigin;
        this.m_crosslineAtOrigin = crosslineAtOrigin;
        this.m_inlineIncrement = inlineIncrement;
        this.m_crosslineIncrement = crosslineIncrement;
        this.m_inlineBinSize = inlineBinSize;
        this.m_crosslineBinSize = crosslineBinSize;
        this.m_inlineAngle = inlineAngle;
        this.computeInternals(true);
        this.prepareRangeFinder();
    }

    public Grid3D_Conversion clone() {
        Grid3D_Conversion grid = new Grid3D_Conversion();
        grid.m_worldCoordAtOriginX = this.m_worldCoordAtOriginX;
        grid.m_worldCoordAtOriginY = this.m_worldCoordAtOriginY;
        grid.m_inlineAtOrigin = this.m_inlineAtOrigin;
        grid.m_crosslineAtOrigin = this.m_crosslineAtOrigin;
        grid.m_inlineIncrement = this.m_inlineIncrement;
        grid.m_crosslineIncrement = this.m_crosslineIncrement;
        grid.m_inlineBinSize = this.m_inlineBinSize;
        grid.m_crosslineBinSize = this.m_crosslineBinSize;
        grid.m_inlineAngle = this.m_inlineAngle;
        grid.computeInternals(true);
        return grid;
    }

    public void setBinSize(double inlineBinSize, double crosslineBinSize) {
        this.m_inlineBinSize = inlineBinSize;
        this.m_crosslineBinSize = crosslineBinSize;
        this.computeInternals(true);
    }

    public double crosslineBinSize() {
        return this.m_crosslineBinSize;
    }

    public double inlineBinSize() {
        return this.m_inlineBinSize;
    }

    public void setOrigin(double ox, double oy) {
        this.m_worldCoordAtOriginX = ox;
        this.m_worldCoordAtOriginY = oy;
        this.computeInternals(true);
    }

    public double originX() {
        return this.m_worldCoordAtOriginX;
    }

    public double originY() {
        return this.m_worldCoordAtOriginY;
    }

    public void read(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (1000923 != magic) {
                throw new Exception("1000923 != magic");
            }
            int version = file.readInt();
            if (version != 1000) {
                throw new Exception("bad version");
            }
            this.m_inlineAtOrigin = file.readInt();
            this.m_crosslineAtOrigin = file.readInt();
            this.m_inlineIncrement = file.readInt();
            this.m_crosslineIncrement = file.readInt();
            this.m_worldCoordAtOriginX = file.readDouble();
            this.m_worldCoordAtOriginY = file.readDouble();
            this.m_inlineBinSize = file.readDouble();
            this.m_crosslineBinSize = file.readDouble();
            this.m_inlineAngle = file.readDouble();
            this.computeInternals(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(RandomAccessFile file) {
        try {
            int magic = 1000923;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_inlineAtOrigin);
                file.writeInt(this.m_crosslineAtOrigin);
                file.writeInt(this.m_inlineIncrement);
                file.writeInt(this.m_crosslineIncrement);
                file.writeDouble(this.m_worldCoordAtOriginX);
                file.writeDouble(this.m_worldCoordAtOriginY);
                file.writeDouble(this.m_inlineBinSize);
                file.writeDouble(this.m_crosslineBinSize);
                file.writeDouble(this.m_inlineAngle);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName) {
        try {
            ParameterTree tree = new ParameterTree();
            tree.int_put(OriginInline, this.m_inlineAtOrigin);
            tree.int_put(OriginCrossline, this.m_crosslineAtOrigin);
            tree.int_put(InlineIncrement, this.m_inlineIncrement);
            tree.int_put(CrosslineIncrement, this.m_crosslineIncrement);
            tree.double_put(OriginX, this.m_worldCoordAtOriginX);
            tree.double_put(OriginY, this.m_worldCoordAtOriginY);
            tree.double_put(InlineSize, this.m_inlineBinSize);
            tree.double_put(CrosslineSize, this.m_crosslineBinSize);
            tree.double_put(Angle, this.m_inlineAngle);
            tree.save(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            ParameterTree tree = new ParameterTree();
            tree.read(fileName);
            this.m_inlineAtOrigin = tree.int_get(OriginInline, 0);
            this.m_crosslineAtOrigin = tree.int_get(OriginCrossline, 0);
            this.m_inlineIncrement = tree.int_get(InlineIncrement, 0);
            this.m_crosslineIncrement = tree.int_get(CrosslineIncrement, 0);
            this.m_worldCoordAtOriginX = tree.double_get(OriginX, 0.0);
            this.m_worldCoordAtOriginY = tree.double_get(OriginY, 0.0);
            this.m_inlineBinSize = tree.double_get(InlineSize, 0.0);
            this.m_crosslineBinSize = tree.double_get(CrosslineSize, 0.0);
            this.m_inlineAngle = tree.double_get(Angle, 0.0);
            this.computeInternals(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeInternals(boolean prepRangeFinder) {
        try {
            this.m_inlineIncrement = Math.max(this.m_inlineIncrement, 1);
            this.m_inverseInlineIncrement = 1.0 / (double)this.m_inlineIncrement;
            this.m_crosslineIncrement = Math.max(this.m_crosslineIncrement, 1);
            this.m_inverseCrosslineIncrement = 1.0 / (double)this.m_crosslineIncrement;
            this.m_cosineInlineAngle = Math.cos(this.m_inlineAngle);
            this.m_sineInlineAngle = Math.sin(this.m_inlineAngle);
            this.m_inlineBinSize = Math.max(10.0, this.m_inlineBinSize);
            this.m_crosslineBinSize = Math.max(10.0, this.m_crosslineBinSize);
            this.m_inverseInlineBinSize = 1.0 / this.m_inlineBinSize;
            this.m_inverseCrosslineBinSize = 1.0 / this.m_crosslineBinSize;
            if (prepRangeFinder) {
                this.prepareRangeFinder();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setWorldLocation(double worldX, double worldY) {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            double dx = worldX - this.m_worldCoordAtOriginX;
            double dy = worldY - this.m_worldCoordAtOriginY;
            this.GridY = this.m_cosineInlineAngle * dy - this.m_sineInlineAngle * dx;
            this.GridX = this.m_cosineInlineAngle * dx + this.m_sineInlineAngle * dy;
            this.InlineIndex = (int)Math.round(this.GridX * this.m_inverseInlineBinSize);
            this.CrosslineIndex = (int)Math.round(this.GridY * this.m_inverseCrosslineBinSize);
            this.Inline = this.m_inlineAtOrigin + this.m_inlineIncrement * this.InlineIndex;
            this.Crossline = this.m_crosslineAtOrigin + this.m_crosslineIncrement * this.CrosslineIndex;
            this.InlineGridIndex = this.Inline - this.m_minInline;
            this.CrosslineGridIndex = this.Crossline - this.m_minCrossline;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setInlineCrossline(int i, int c) {
        try {
            this.Inline = i;
            this.Crossline = c;
            this.InlineIndex = (this.Inline - this.m_inlineAtOrigin) / this.m_inlineIncrement;
            this.CrosslineIndex = (this.Crossline - this.m_crosslineAtOrigin) / this.m_crosslineIncrement;
            this.GridX = (double)this.InlineIndex * this.m_inlineBinSize;
            this.GridY = (double)this.CrosslineIndex * this.m_crosslineBinSize;
            this.WorldX = this.m_worldCoordAtOriginX + this.GridX * this.m_cosineInlineAngle - this.GridY * this.m_sineInlineAngle;
            this.WorldY = this.m_worldCoordAtOriginY + this.GridX * this.m_sineInlineAngle + this.GridY * this.m_cosineInlineAngle;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getWorldY(double inline, double crossline) {
        try {
            this.GridX = (inline - (double)this.m_inlineAtOrigin) * this.m_inverseInlineIncrement * this.m_inlineBinSize;
            this.GridY = (crossline - (double)this.m_crosslineAtOrigin) * this.m_inverseCrosslineIncrement * this.m_crosslineBinSize;
            return this.m_worldCoordAtOriginY + this.m_cosineInlineAngle * this.GridY + this.m_sineInlineAngle * this.GridX;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public double getWorldX(double inline, double crossline) {
        try {
            this.GridX = (inline - (double)this.m_inlineAtOrigin) * this.m_inverseInlineIncrement * this.m_inlineBinSize;
            this.GridY = (crossline - (double)this.m_crosslineAtOrigin) * this.m_inverseCrosslineIncrement * this.m_crosslineBinSize;
            return this.m_worldCoordAtOriginX + this.m_cosineInlineAngle * this.GridX - this.m_sineInlineAngle * this.GridY;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public int getMinInline() {
        return this.m_minInline;
    }

    public int getMinCrossline() {
        return this.m_minCrossline;
    }

    public int getMaxInline() {
        return this.m_maxInline;
    }

    public int getMaxCrossline() {
        return this.m_maxCrossline;
    }

    public int getCrosslineIncrement() {
        return this.m_crosslineIncrement;
    }

    public int getInlineIncrement() {
        return this.m_inlineIncrement;
    }

    public int getNumInline() {
        return this.m_numInline;
    }

    public int getNumCrossline() {
        return this.m_numCrossline;
    }

    public void setGridRangeFromPoints(List<Point2D.Double> points, double buffer) throws Exception {
        int nPoints = points.size();
        this.prepareRangeFinder();
        for (int n = 0; n < nPoints; ++n) {
            Point2D.Double point = points.get(n);
            double x = point.x;
            double y = point.y;
            this.addToRangeFinder(x, y, buffer);
        }
    }
}

