/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.FFT;

import com.PecosCore.Shared.ExceptionMonitor;

public class FFT_Double {
    protected int m_forwardInputDataLength = -1;
    protected int m_powerOfTwo = 1024;
    protected double[] m_realComponent;
    protected double[] m_imaginaryComponent;
    protected boolean m_phaseComputed = false;
    protected double[] m_phase;
    protected double[] m_amplitude;
    protected double[] m_temp = new double[10];
    protected int m_freqSpikeIndex;

    public FFT_Double(int length) {
        try {
            length = Math.max(length, 16);
            this.resetLengths(length);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearArrays() {
        try {
            for (int n = 0; n < this.m_powerOfTwo; ++n) {
                this.m_realComponent[n] = 0.0;
                this.m_imaginaryComponent[n] = 0.0;
                this.m_amplitude[n] = 0.0;
                this.m_phase[n] = 0.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void printInternal() {
        try {
            for (int n = 0; n < this.m_powerOfTwo; ++n) {
                double amp = Math.sqrt(1.0E-60 + this.m_realComponent[n] * this.m_realComponent[n] + this.m_imaginaryComponent[n] * this.m_imaginaryComponent[n]);
                String s = String.format("%d     %f     %f     %f", n, this.m_realComponent[n], this.m_imaginaryComponent[n], amp);
                System.out.println(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int getPowerOfTwo() {
        return this.m_powerOfTwo;
    }

    protected void resetLengths(int len) throws Exception {
        try {
            this.m_forwardInputDataLength = -1;
            if (len < 4) {
                return;
            }
            this.m_powerOfTwo = 4;
            while (this.m_powerOfTwo < len) {
                this.m_powerOfTwo *= 2;
            }
            this.m_realComponent = new double[this.m_powerOfTwo];
            this.m_imaginaryComponent = new double[this.m_powerOfTwo];
            this.m_amplitude = new double[this.m_powerOfTwo];
            this.m_phase = new double[this.m_powerOfTwo];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computePhase() {
        try {
            for (int n = 0; n < this.m_powerOfTwo; ++n) {
                double x = this.m_realComponent[n];
                double y = this.m_imaginaryComponent[n];
                double rad = x * x + y * y;
                this.m_amplitude[n] = 0.0;
                this.m_phase[n] = 0.0;
                if (!(rad > 0.0)) continue;
                this.m_amplitude[n] = Math.sqrt(rad);
                this.m_phase[n] = Math.atan2(y, x);
            }
            this.m_phaseComputed = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeReIm() {
        try {
            for (int n = 0; n < this.m_powerOfTwo; ++n) {
                this.m_realComponent[n] = this.m_amplitude[n] * Math.cos(this.m_phase[n]);
                this.m_imaginaryComponent[n] = this.m_amplitude[n] * Math.sin(this.m_phase[n]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double[] imag() {
        return this.m_imaginaryComponent;
    }

    public double[] real() {
        return this.m_realComponent;
    }

    public double[] amplitude() {
        if (!this.m_phaseComputed) {
            this.computePhase();
        }
        return this.m_amplitude;
    }

    public double[] phase() {
        if (!this.m_phaseComputed) {
            this.computePhase();
        }
        return this.m_phase;
    }

    public void removeFrequencySpikes(double[] re, double threshold) throws Exception {
        try {
            threshold = Math.max(threshold, 10.0);
            if (re == null) {
                return;
            }
            if (re.length < 4) {
                return;
            }
            this.forward(re);
            this.computePhase();
            double sum = 0.0;
            double max = 0.0;
            int half = this.m_amplitude.length / 2;
            for (int n = 0; n < half; ++n) {
                double a = this.m_amplitude[n];
                sum += a;
                if (!(a > max)) continue;
                max = a;
                this.m_freqSpikeIndex = n;
            }
            double avg = sum / (double)half;
            double spike = max / avg;
            while (sum > 0.0 && spike > threshold) {
                int index;
                this.m_imaginaryComponent[this.m_freqSpikeIndex] = 0.0;
                this.m_realComponent[this.m_freqSpikeIndex] = 0.0;
                this.m_amplitude[this.m_freqSpikeIndex] = 0.0;
                if ((this.m_freqSpikeIndex > 0 || this.m_freqSpikeIndex < half) && (index = this.m_imaginaryComponent.length - this.m_freqSpikeIndex) >= 0 && index < this.m_imaginaryComponent.length) {
                    this.m_imaginaryComponent[index] = 0.0;
                    this.m_realComponent[index] = 0.0;
                    this.m_amplitude[index] = 0.0;
                }
                avg = (sum -= max) / (double)half;
                max = 0.0;
                for (int n = 0; n < half; ++n) {
                    double a = this.m_amplitude[n];
                    if (!(a > max)) continue;
                    max = a;
                    this.m_freqSpikeIndex = n;
                }
                spike = max / avg;
            }
            this.inverse(re);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double computeFrequencySpike(double[] re) throws Exception {
        try {
            this.m_freqSpikeIndex = 0;
            if (re == null) {
                return 1.0;
            }
            if (re.length < 4) {
                return 1.0;
            }
            this.forward(re);
            this.computePhase();
            double sum = 0.0;
            double max = 0.0;
            int half = this.m_amplitude.length / 2;
            for (int n = 0; n < half; ++n) {
                double a = this.m_amplitude[n];
                sum += a;
                if (!(max < a)) continue;
                this.m_freqSpikeIndex = n;
                max = a;
            }
            double avg = sum / (double)half;
            return max / (avg + 1.0E-20);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void forward(double[] re, double[] im) throws Exception {
        try {
            int n;
            this.m_phaseComputed = false;
            this.m_forwardInputDataLength = -1;
            if (re == null) {
                return;
            }
            if (re.length < 4) {
                return;
            }
            if (re.length != im.length) {
                throw new Exception("Lengths must be the same");
            }
            if (re.length > this.m_powerOfTwo || re.length <= this.m_powerOfTwo / 2) {
                this.resetLengths(re.length);
            }
            for (n = 0; n < re.length; ++n) {
                this.m_realComponent[n] = re[n];
                this.m_imaginaryComponent[n] = im[n];
            }
            for (n = re.length; n < this.m_powerOfTwo; ++n) {
                this.m_realComponent[n] = 0.0;
                this.m_imaginaryComponent[n] = 0.0;
            }
            this.complexToComplex(1);
            this.m_forwardInputDataLength = re.length;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void forward(double[] re) throws Exception {
        try {
            int n;
            this.m_phaseComputed = false;
            this.m_forwardInputDataLength = -1;
            if (re == null) {
                return;
            }
            if (re.length < 4) {
                return;
            }
            if (re.length > this.m_powerOfTwo || re.length <= this.m_powerOfTwo / 2) {
                this.resetLengths(re.length);
            }
            for (n = 0; n < re.length; ++n) {
                this.m_realComponent[n] = re[n];
                this.m_imaginaryComponent[n] = 0.0;
            }
            for (n = re.length; n < this.m_powerOfTwo; ++n) {
                this.m_realComponent[n] = 0.0;
                this.m_imaginaryComponent[n] = 0.0;
            }
            this.complexToComplex(1);
            this.m_forwardInputDataLength = re.length;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void inverse(double[] re, double[] im) throws Exception {
        try {
            this.m_phaseComputed = false;
            if (re.length != this.m_forwardInputDataLength) {
                throw new Exception("re.length != m_mostRecentLength");
            }
            this.complexToComplex(-1);
            for (int n = 0; n < re.length; ++n) {
                re[n] = this.m_realComponent[n];
                im[n] = this.m_imaginaryComponent[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setForwardInputDataLength(int forwardInputDataLength) {
        this.m_forwardInputDataLength = forwardInputDataLength;
    }

    public void inverse(double[] re) throws Exception {
        try {
            this.m_phaseComputed = false;
            if (re.length != this.m_forwardInputDataLength) {
                throw new Exception("re.length != m_mostRecentLength");
            }
            this.complexToComplex(-1);
            for (int n = 0; n < re.length; ++n) {
                re[n] = this.m_realComponent[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void complexToComplex(int sign) {
        try {
            int i;
            double scale = Math.sqrt(1.0f / (float)this.m_powerOfTwo);
            int j = 0;
            for (i = 0; i < this.m_powerOfTwo; ++i) {
                int m;
                if (j >= i) {
                    double tempr = this.m_realComponent[j] * scale;
                    double tempi = this.m_imaginaryComponent[j] * scale;
                    this.m_realComponent[j] = this.m_realComponent[i] * scale;
                    this.m_imaginaryComponent[j] = this.m_imaginaryComponent[i] * scale;
                    this.m_realComponent[i] = tempr;
                    this.m_imaginaryComponent[i] = tempi;
                }
                for (m = this.m_powerOfTwo / 2; m >= 1 && j >= m; j -= m, m /= 2) {
                }
                j += m;
            }
            int mmax = 1;
            int istep = 2 * mmax;
            while (mmax < this.m_powerOfTwo) {
                double delta = (double)sign * 3.1415927410125732 / (double)mmax;
                for (int m = 0; m < mmax; ++m) {
                    double w = (double)m * delta;
                    double wr = Math.cos(w);
                    double wi = Math.sin(w);
                    for (i = m; i < this.m_powerOfTwo; i += istep) {
                        j = i + mmax;
                        double tr = wr * this.m_realComponent[j] - wi * this.m_imaginaryComponent[j];
                        double ti = wr * this.m_imaginaryComponent[j] + wi * this.m_realComponent[j];
                        this.m_realComponent[j] = this.m_realComponent[i] - tr;
                        this.m_imaginaryComponent[j] = this.m_imaginaryComponent[i] - ti;
                        int n = i;
                        this.m_realComponent[n] = this.m_realComponent[n] + tr;
                        int n2 = i;
                        this.m_imaginaryComponent[n2] = this.m_imaginaryComponent[n2] + ti;
                    }
                }
                mmax = istep;
                mmax = istep;
                istep = 2 * mmax;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void rotatePhase(double radians, double[] input) {
        try {
            double y;
            double x;
            int s;
            if (input == null) {
                return;
            }
            if (input.length < 4) {
                return;
            }
            double cs = Math.cos(radians);
            double sn = Math.sin(radians);
            this.forward(input);
            int mid = this.m_powerOfTwo / 2;
            for (s = 1; s < mid; ++s) {
                x = this.m_realComponent[s];
                y = this.m_imaginaryComponent[s];
                this.m_realComponent[s] = cs * x + sn * y;
                this.m_imaginaryComponent[s] = cs * y - sn * x;
            }
            for (s = mid + 1; s < this.m_powerOfTwo; ++s) {
                x = this.m_realComponent[s];
                y = this.m_imaginaryComponent[s];
                this.m_realComponent[s] = cs * x - sn * y;
                this.m_imaginaryComponent[s] = cs * y + sn * x;
            }
            this.inverse(input);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void envelope(double[] input) {
        try {
            double radians = 1.5707963267948966;
            if (input == null) {
                return;
            }
            if (input.length < 4) {
                return;
            }
            if (this.m_temp.length != input.length) {
                this.m_temp = new double[input.length];
            }
            System.arraycopy(input, 0, this.m_temp, 0, input.length);
            this.rotatePhase(1.5707963267948966, input);
            for (int n = 0; n < input.length; ++n) {
                input[n] = Math.sqrt(input[n] * input[n] + this.m_temp[n] * this.m_temp[n]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

