/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.FFT;

import com.PecosCore.FFT.FFT_Double;
import com.PecosCore.Shared.ExceptionMonitor;

public class FFT_2D_Wrapper {
    protected FFT_Double m_rowFFT;
    protected FFT_Double m_columnFFT;
    protected int m_powerOfTwo_Row;
    protected int m_powerOfTwo_Column;
    protected double[][] m_real;
    protected double[][] m_imag;
    protected double[] m_tempRealRow;
    protected double[] m_tempImagRow;
    protected double[] m_tempRealCol;
    protected double[] m_tempImagCol;
    protected double[][] m_amplitude;
    protected double[][] m_phase;
    protected int m_externalRowCount;
    protected int m_externalColumnCount;
    protected double[][] m_realExternal;
    protected double[][] m_imagExternal;
    protected double m_amplitudeMax = 0.0;

    public int powerOfTwo_Row() {
        return this.m_powerOfTwo_Row;
    }

    public int powerOfTwo_Column() {
        return this.m_powerOfTwo_Column;
    }

    public double[][] real() {
        return this.m_real;
    }

    public double[][] imag() {
        return this.m_imag;
    }

    public double[][] amplitude() {
        return this.m_amplitude;
    }

    public double[][] phase() {
        return this.m_phase;
    }

    public int externalRowCount() {
        return this.m_externalRowCount;
    }

    public int externalColumnCount() {
        return this.m_externalColumnCount;
    }

    public double[][] realExternal() {
        return this.m_realExternal;
    }

    public double[][] imagExternal() {
        return this.m_imagExternal;
    }

    public void filter(double fraction_row, double fraction_column) {
        try {
            fraction_row = Math.max(0.05, Math.min(0.95, fraction_row));
            fraction_column = Math.max(0.05, Math.min(0.95, fraction_column));
            for (int col = 1; col < this.m_powerOfTwo_Column; ++col) {
                for (int row = 1; row < this.m_powerOfTwo_Row; ++row) {
                    double fr;
                    double ratio_r;
                    double fc;
                    double ratio_c;
                    double ratio;
                    int r;
                    int c = col;
                    if (c >= this.m_powerOfTwo_Column / 2) {
                        c = this.m_powerOfTwo_Column - col;
                    }
                    if ((r = row) >= this.m_powerOfTwo_Row / 2) {
                        r = this.m_powerOfTwo_Row - row;
                    }
                    if (!((ratio = Math.sqrt((ratio_c = (fc = 2.0 * (double)c / (double)this.m_powerOfTwo_Column) / fraction_column) * ratio_c + (ratio_r = (fr = 2.0 * (double)r / (double)this.m_powerOfTwo_Row) / fraction_row) * ratio_r)) > 1.0)) continue;
                    this.m_imag[row][col] = 0.0;
                    this.m_real[row][col] = 0.0;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setExternalDimensions(int rowCount, int columnCount) {
        try {
            this.m_externalRowCount = Math.max(1, rowCount);
            this.m_externalColumnCount = Math.max(1, columnCount);
            this.m_realExternal = new double[this.m_externalRowCount][this.m_externalColumnCount];
            this.m_imagExternal = new double[this.m_externalRowCount][this.m_externalColumnCount];
            this.m_rowFFT = new FFT_Double(this.m_externalColumnCount);
            this.m_powerOfTwo_Column = this.m_rowFFT.getPowerOfTwo();
            this.m_columnFFT = new FFT_Double(this.m_externalRowCount);
            this.m_powerOfTwo_Row = this.m_columnFFT.getPowerOfTwo();
            this.m_real = new double[this.m_powerOfTwo_Row][this.m_powerOfTwo_Column];
            this.m_imag = new double[this.m_powerOfTwo_Row][this.m_powerOfTwo_Column];
            this.m_amplitude = new double[this.m_powerOfTwo_Row][this.m_powerOfTwo_Column];
            this.m_phase = new double[this.m_powerOfTwo_Row][this.m_powerOfTwo_Column];
            this.m_tempRealRow = new double[this.m_powerOfTwo_Row];
            this.m_tempImagRow = new double[this.m_powerOfTwo_Row];
            this.m_tempRealCol = new double[this.m_powerOfTwo_Column];
            this.m_tempImagCol = new double[this.m_powerOfTwo_Column];
            this.clearExternal(0.0, 0.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearExternal(double r, double i) throws Exception {
        try {
            for (int row = 0; row < this.m_externalRowCount; ++row) {
                for (int col = 0; col < this.m_externalColumnCount; ++col) {
                    this.m_realExternal[row][col] = r;
                    this.m_imagExternal[row][col] = i;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearInternal(double r, double i) throws Exception {
        try {
            for (int row = 0; row < this.m_powerOfTwo_Row; ++row) {
                for (int col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    this.m_real[row][col] = r;
                    this.m_imag[row][col] = i;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double amplitudeMax() {
        return this.m_amplitudeMax;
    }

    public void computeAmplitude() {
        try {
            this.m_amplitudeMax = 0.0;
            for (int row = 0; row < this.m_powerOfTwo_Row; ++row) {
                for (int col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    double r = this.m_real[row][col];
                    double i = this.m_imag[row][col];
                    double a2 = r * r + i * i;
                    if (a2 > 0.0) {
                        this.m_amplitude[row][col] = Math.sqrt(a2);
                        this.m_phase[row][col] = Math.atan2(i, r);
                        this.m_amplitudeMax = Math.max(this.m_amplitudeMax, this.m_amplitude[row][col]);
                        continue;
                    }
                    this.m_amplitude[row][col] = 0.0;
                    this.m_phase[row][col] = 0.0;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void insertColumn_Float(int col, float[] data) throws Exception {
        try {
            int n;
            int num = Math.min(this.m_externalRowCount, data.length);
            for (n = 0; n < num; ++n) {
                this.m_realExternal[n][col] = data[n];
                this.m_imagExternal[n][col] = 0.0;
            }
            for (n = num; n < this.m_externalRowCount; ++n) {
                this.m_realExternal[n][col] = 0.0;
                this.m_imagExternal[n][col] = 0.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void insertColumn_Double(int col, double[] data) throws Exception {
        try {
            int n;
            int num = Math.min(this.m_externalRowCount, data.length);
            for (n = 0; n < num; ++n) {
                this.m_realExternal[n][col] = data[n];
                this.m_imagExternal[n][col] = 0.0;
            }
            for (n = num; n < this.m_powerOfTwo_Row; ++n) {
                this.m_realExternal[n][col] = 0.0;
                this.m_imagExternal[n][col] = 0.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void getColumn_Float(int col, float[] data) throws Exception {
        try {
            int num = Math.min(this.m_externalRowCount, data.length);
            for (int n = 0; n < num; ++n) {
                data[n] = (float)this.m_realExternal[n][col];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void getColumn_Double(int col, double[] data) throws Exception {
        try {
            int num = Math.min(this.m_externalRowCount, data.length);
            for (int n = 0; n < num; ++n) {
                data[n] = this.m_realExternal[n][col];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void forward() throws Exception {
        try {
            int col;
            int row;
            for (row = 0; row < this.m_powerOfTwo_Row; ++row) {
                for (col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    if (row < this.m_externalRowCount && col < this.m_externalColumnCount) {
                        this.m_real[row][col] = this.m_realExternal[row][col];
                        this.m_imag[row][col] = this.m_imagExternal[row][col];
                        continue;
                    }
                    this.m_real[row][col] = 0.0;
                    this.m_imag[row][col] = 0.0;
                }
            }
            for (int col2 = 0; col2 < this.m_powerOfTwo_Column; ++col2) {
                int row2;
                for (row2 = 0; row2 < this.m_powerOfTwo_Row; ++row2) {
                    this.m_tempRealRow[row2] = this.m_real[row2][col2];
                    this.m_tempImagRow[row2] = this.m_imag[row2][col2];
                }
                this.m_rowFFT.forward(this.m_tempRealRow, this.m_tempImagRow);
                for (row2 = 0; row2 < this.m_powerOfTwo_Row; ++row2) {
                    this.m_real[row2][col2] = this.m_rowFFT.real()[row2];
                    this.m_imag[row2][col2] = this.m_rowFFT.imag()[row2];
                }
            }
            for (row = 0; row < this.m_powerOfTwo_Row; ++row) {
                for (col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    this.m_tempRealCol[col] = this.m_real[row][col];
                    this.m_tempImagCol[col] = this.m_imag[row][col];
                }
                this.m_columnFFT.forward(this.m_tempRealCol, this.m_tempImagCol);
                for (col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    this.m_real[row][col] = this.m_columnFFT.real()[col];
                    this.m_imag[row][col] = this.m_columnFFT.imag()[col];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void inverse() throws Exception {
        try {
            int col;
            int row;
            for (row = 0; row < this.m_powerOfTwo_Row; ++row) {
                for (col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    this.m_columnFFT.real()[col] = this.m_real[row][col];
                    this.m_columnFFT.imag()[col] = this.m_imag[row][col];
                }
                this.m_columnFFT.inverse(this.m_tempRealCol, this.m_tempImagCol);
                for (col = 0; col < this.m_powerOfTwo_Column; ++col) {
                    this.m_real[row][col] = this.m_tempRealCol[col];
                    this.m_imag[row][col] = this.m_tempImagCol[col];
                }
            }
            for (int col2 = 0; col2 < this.m_powerOfTwo_Column; ++col2) {
                int row2;
                for (row2 = 0; row2 < this.m_powerOfTwo_Row; ++row2) {
                    this.m_rowFFT.real()[row2] = this.m_real[row2][col2];
                    this.m_rowFFT.imag()[row2] = this.m_imag[row2][col2];
                }
                this.m_rowFFT.inverse(this.m_tempRealRow, this.m_tempImagRow);
                for (row2 = 0; row2 < this.m_powerOfTwo_Row; ++row2) {
                    this.m_real[row2][col2] = this.m_tempRealRow[row2];
                    this.m_imag[row2][col2] = this.m_tempImagRow[row2];
                }
            }
            for (row = 0; row < this.m_externalRowCount; ++row) {
                for (col = 0; col < this.m_externalColumnCount; ++col) {
                    this.m_realExternal[row][col] = this.m_real[row][col];
                    this.m_imagExternal[row][col] = this.m_imag[row][col];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

