/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class EnsembleGroupManager {
    public String Label = "";
    protected Ensemble m_parentEnsemble = null;
    public ArrayList<GroupInfo> GroupList = new ArrayList();

    public String description(int index) {
        try {
            return this.GroupList.get((int)index).GroupDescription;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "error";
        }
    }

    public void prepareNoGrouping() throws Exception {
        try {
            this.Label = "Grouping off";
            this.GroupList.clear();
            if (this.m_parentEnsemble == null) {
                return;
            }
            GroupInfo groupInfo = new GroupInfo();
            groupInfo.GroupEnsemble = this.m_parentEnsemble;
            groupInfo.GroupDescription = "All traces";
            this.GroupList.add(groupInfo);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepareGroupsBasedOnCount(int count) throws Exception {
        try {
            this.Label = "Count";
            this.GroupList.clear();
            if (this.m_parentEnsemble == null) {
                return;
            }
            count = Math.max(10, count);
            count = Math.min(1000, count);
            for (int start = 0; start < this.m_parentEnsemble.traceCount(); start += count) {
                GroupInfo groupInfo = new GroupInfo();
                groupInfo.GroupEnsemble = Tools_Ensemble.createChildEnsemble(this.m_parentEnsemble, start, count);
                groupInfo.GroupDescription = Integer.toString(start + 1) + "-" + Integer.toString(start + groupInfo.GroupEnsemble.traceCount());
                this.GroupList.add(groupInfo);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepareGroupsBasedOnInteger(String table, String column) throws Exception {
        try {
            this.Label = table + ":" + column;
            this.GroupList.clear();
            if (this.m_parentEnsemble == null) {
                return;
            }
            ArrayList<Integer> list = Tools_Ensemble.getUniqueHeaderArray(this.m_parentEnsemble, table, column);
            if (list.size() < 1) {
                return;
            }
            for (Integer header : list) {
                int val = header;
                GroupInfo groupInfo = new GroupInfo();
                groupInfo.GroupValue = val;
                groupInfo.GroupEnsemble = Tools_Ensemble.createChildEnsemble(this.m_parentEnsemble, table, column, val);
                groupInfo.GroupDescription = String.format("%d  (%d)", val, groupInfo.GroupEnsemble.traceCount());
                this.GroupList.add(groupInfo);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Ensemble parentEnsemble() {
        return this.m_parentEnsemble;
    }

    public void setParentEnsemble(Ensemble ensemble) {
        try {
            this.GroupList.clear();
            this.m_parentEnsemble = ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public class GroupInfo {
        public Ensemble GroupEnsemble = null;
        public String GroupDescription = "";
        public int GroupValue = -999;
    }
}

