/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.TraceTable.Huge;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Map.HashKey_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

public class TraceTable_Huge_SingleColumnIndexer {
    protected HashMap<HashKey_Integer, EntryNew> m_map_new = new HashMap();
    public boolean NewCode = false;
    protected String m_fileName_Buffer = "";
    protected String m_fileName_Entry = "";
    protected String m_path;
    protected String m_columnName;
    protected HashKey_Integer m_tempKey = new HashKey_Integer(0);
    protected HashMap<HashKey_Integer, Entry> m_map = new HashMap();
    protected long m_rowCount = 0L;
    protected DataType m_indexDataType = DataType.Int;
    protected boolean m_valid = false;
    protected static final int OldMagic = 434324;

    public boolean valid() {
        return this.m_map.size() > 0 || this.m_map_new.size() > 0;
    }

    public TraceTable_Huge_SingleColumnIndexer(String path, String colName) throws Exception {
        try {
            this.m_columnName = colName;
            this.m_path = path;
            this.m_fileName_Buffer = TraceTable_Huge_SingleColumnIndexer.fileNameBuffer(path, colName);
            this.m_fileName_Entry = TraceTable_Huge_SingleColumnIndexer.fileNameEntry(path, colName);
            if (Tools_FileSystem.exists_file(this.m_fileName_Buffer) || Tools_FileSystem.exists_file(this.m_fileName_Entry)) {
                this.readEntries();
                this.m_valid = true;
            } else {
                this.clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clear() throws Exception {
        try {
            this.m_map.clear();
            this.m_map_new.clear();
            Tools_FileSystem.deleteFile(this.m_fileName_Buffer);
            Tools_FileSystem.deleteFile(this.m_fileName_Entry);
            this.m_valid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readEntries() throws Exception {
        try {
            this.m_map.clear();
            this.m_map_new.clear();
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            this.m_indexDataType = DataType.Int;
            int magic = file.readInt();
            int version = file.readInt();
            if (magic != 434324) {
                file.close();
                throw new Exception("tempMagic != magic");
            }
            if (version == 5000) {
                this.NewCode = true;
                this.m_indexDataType = DataType.Long;
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    EntryNew e = new EntryNew(0);
                    e.Funky = file.readBoolean();
                    e.Value = file.readInt();
                    e.Count = file.readInt();
                    int ns = file.readInt();
                    for (int k = 0; k < ns; ++k) {
                        long start = file.readLong();
                        Segment s = new Segment(start);
                        s.Count = file.readLong();
                        e.Segments.add(s);
                    }
                    this.m_map_new.put(new HashKey_Integer(e.Value), e);
                }
                file.close();
                return;
            }
            if (version == 1002) {
                this.m_indexDataType = DataType.Long;
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry(0);
                    e.Value = file.readInt();
                    e.Count = file.readInt();
                    e.BufferOffset = file.readLong();
                    this.m_map.put(new HashKey_Integer(e.Value), e);
                }
                file.close();
                return;
            }
            if (version == 1001) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry(0);
                    e.Value = file.readInt();
                    e.Count = file.readInt();
                    e.BufferOffset = file.readLong();
                    this.m_map.put(new HashKey_Integer(e.Value), e);
                }
                file.close();
                return;
            }
            if (version == 1000) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry(0);
                    e.Value = file.readInt();
                    e.Count = file.readInt();
                    e.BufferOffset = file.readInt();
                    this.m_map.put(new HashKey_Integer(e.Value), e);
                }
                file.close();
                return;
            }
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String fileNameBuffer(String path, String column) {
        return path + "/Index_" + column + ".buffer";
    }

    public static String fileNameEntry(String path, String column) {
        return path + "/Index_" + column + ".entry";
    }

    public boolean valid(int id) {
        try {
            if (!this.m_valid) {
                return false;
            }
            if (!this.NewCode) {
                return true;
            }
            this.m_tempKey.Key = id;
            if (!this.m_map_new.containsKey(this.m_tempKey)) {
                return false;
            }
            return !this.m_map_new.get((Object)this.m_tempKey).Funky;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public int get(int value, int startIndexInColumn, Column_Abstract column) throws Exception {
        try {
            this.m_tempKey.Key = value;
            if (this.NewCode) {
                if (!this.m_map_new.containsKey(this.m_tempKey)) {
                    return startIndexInColumn;
                }
                EntryNew e = this.m_map_new.get(this.m_tempKey);
                if (e.Funky) {
                    return startIndexInColumn;
                }
                for (Segment s : e.Segments) {
                    for (long n = 0L; n < s.Count; ++n) {
                        column.putLong(startIndexInColumn, n + s.Start);
                        ++startIndexInColumn;
                    }
                }
                return startIndexInColumn;
            }
            if (!this.m_map.containsKey(this.m_tempKey)) {
                return startIndexInColumn;
            }
            Entry entry = this.m_map.get(this.m_tempKey);
            if (this.m_indexDataType == DataType.Long) {
                int numBytes = 4 + 8 * entry.Count;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
                file.seek(entry.BufferOffset);
                file.read(buff.array(), 0, numBytes);
                file.close();
                int qcValue = buff.getInt();
                if (qcValue != value) {
                    throw new Exception("qcValue != value");
                }
                int row = startIndexInColumn;
                for (int n = 0; n < entry.Count; ++n) {
                    long traceTableRow = buff.getLong();
                    column.putLong(row, traceTableRow);
                    ++row;
                }
                return startIndexInColumn += entry.Count;
            }
            if (this.m_indexDataType == DataType.Int) {
                int numBytes = 4 + 4 * entry.Count;
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
                file.seek(entry.BufferOffset);
                file.read(buff.array(), 0, numBytes);
                file.close();
                int qcValue = buff.getInt();
                if (qcValue != value) {
                    throw new Exception("qcValue != value");
                }
                int row = startIndexInColumn;
                for (int n = 0; n < entry.Count; ++n) {
                    int traceTableRow = buff.getInt();
                    column.putInt(row, traceTableRow);
                    ++row;
                }
                return startIndexInColumn += entry.Count;
            }
            return startIndexInColumn;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_new() throws Exception {
        try {
            this.clear();
            this.m_map_new.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_new(int id, long row) throws Exception {
        try {
            this.m_tempKey.Key = id;
            if (!this.m_map_new.containsKey(this.m_tempKey)) {
                this.m_map_new.put(new HashKey_Integer(id), new EntryNew(id));
            }
            EntryNew entry = this.m_map_new.get(this.m_tempKey);
            ++entry.Count;
            if (entry.Funky) {
                return;
            }
            entry.add(row);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finish_new() throws Exception {
        try {
            this.NewCode = true;
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            int magic = 434324;
            int version = 5000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 5000) {
                file.writeInt(this.m_map_new.size());
                for (EntryNew entry : this.m_map_new.values()) {
                    file.writeBoolean(entry.Funky);
                    file.writeInt(entry.Value);
                    file.writeInt(entry.Count);
                    file.writeInt(entry.Segments.size());
                    for (Segment s : entry.Segments) {
                        file.writeLong(s.Start);
                        file.writeLong(s.Count);
                    }
                }
                this.m_indexDataType = DataType.Long;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_FirstPass(long rowCount) throws Exception {
        try {
            this.clear();
            this.m_rowCount = rowCount;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_FirstPass(int value) throws Exception {
        try {
            this.m_tempKey.Key = value;
            if (!this.m_map.containsKey(this.m_tempKey)) {
                this.m_map.put(new HashKey_Integer(value), new Entry(value));
            }
            Entry entry = this.m_map.get(this.m_tempKey);
            ++entry.Count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_SecondPass() throws Exception {
        try {
            for (Entry entry : this.m_map.values()) {
                entry.NumAdded = 0;
                entry.Row = new long[entry.Count];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_SecondPass(int value, long row) throws Exception {
        try {
            this.m_tempKey.Key = value;
            Entry entry = this.m_map.get(this.m_tempKey);
            entry.Row[entry.NumAdded] = row;
            ++entry.NumAdded;
            if (entry.NumAdded > entry.Count) {
                throw new Exception("entry.NumAdded > entry.Count");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finished_SecondPass() throws Exception {
        try {
            long totalCount = 0L;
            int maxCount = 0;
            for (Entry entry : this.m_map.values()) {
                if (entry.Count != entry.NumAdded) {
                    throw new Exception("entry.Count != entry.NumAdded");
                }
                totalCount += (long)entry.Count;
                maxCount = Math.max(maxCount, entry.Count);
            }
            if (totalCount != this.m_rowCount) {
                throw new Exception("totalCount != m_rowCount");
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 + 8 * maxCount);
            for (Entry entry : this.m_map.values()) {
                entry.BufferOffset = file.getFilePointer();
                buff.putInt(0, entry.Value);
                for (int n = 0; n < entry.Count; ++n) {
                    buff.putLong(4 + n * 8, entry.Row[n]);
                }
                int numBytes = 4 + 8 * entry.Count;
                file.write(buff.array(), 0, numBytes);
                entry.Row = null;
            }
            file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            int magic = 434324;
            int version = 1002;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_map.size());
                for (Entry entry : this.m_map.values()) {
                    file.writeInt(entry.Value);
                    file.writeInt(entry.Count);
                    file.writeInt((int)entry.BufferOffset);
                }
                this.m_indexDataType = DataType.Int;
            }
            if (version == 1001) {
                file.writeInt(this.m_map.size());
                for (Entry entry : this.m_map.values()) {
                    file.writeInt(entry.Value);
                    file.writeInt(entry.Count);
                    file.writeLong(entry.BufferOffset);
                }
                this.m_indexDataType = DataType.Long;
            }
            if (version == 1002) {
                file.writeInt(this.m_map.size());
                for (Entry entry : this.m_map.values()) {
                    file.writeInt(entry.Value);
                    file.writeInt(entry.Count);
                    file.writeLong(entry.BufferOffset);
                }
                this.m_indexDataType = DataType.Long;
            }
            file.close();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static class EntryNew {
        public boolean Funky = false;
        public int Count = 0;
        public int Value = -9999;
        public Segment CurrentSegment;
        public ArrayList<Segment> Segments = new ArrayList();

        public EntryNew(int value) {
            this.Value = value;
        }

        public void add(long row) {
            if (this.Funky) {
                return;
            }
            if (this.Count == 1) {
                this.CurrentSegment = new Segment(row);
                this.Segments.add(this.CurrentSegment);
                return;
            }
            long predicted_row = this.CurrentSegment.Start + this.CurrentSegment.Count;
            if (row < predicted_row) {
                this.Funky = true;
                this.Segments.clear();
                return;
            }
            if (predicted_row == row) {
                ++this.CurrentSegment.Count;
                return;
            }
            if (this.Segments.size() > 10) {
                this.Funky = true;
                this.Segments.clear();
                return;
            }
            this.CurrentSegment = new Segment(row);
            this.Segments.add(this.CurrentSegment);
        }
    }

    public static class Segment {
        public long Start = -9999L;
        public long Count = 0L;

        public Segment(long start) {
            this.Start = start;
            this.Count = 1L;
        }
    }

    protected class Entry {
        public int Value;
        public int Count = 0;
        public int NumAdded = 0;
        public long BufferOffset = 0L;
        public long[] Row;

        public Entry(int value) {
            this.Value = value;
        }
    }
}

