/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Seismic;

import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;

public class CompressedTrace {
    public int ReceiverID;
    public int ShotID;
    public long TraceTableIndex;
    public float Time;
    public float Digi;
    public int WindowCount = 0;
    public int SamplesPerWindow = 0;
    public float[] WindowScalar;
    public byte[] Data;

    public CompressedTrace(int shotID, int recID, long tableIndex, float time, float digi, int windowCount, int sampPerWindow, float[] data) {
        try {
            this.ShotID = shotID;
            this.ReceiverID = recID;
            this.TraceTableIndex = tableIndex;
            this.Time = time;
            this.Digi = digi;
            this.WindowCount = windowCount;
            this.SamplesPerWindow = sampPerWindow;
            this.WindowScalar = new float[this.WindowCount];
            this.Data = new byte[this.WindowCount * this.SamplesPerWindow];
            int dataIndex = 0;
            for (int w = 0; w < this.WindowCount; ++w) {
                float max = 1.0E-25f;
                int shift = w * this.SamplesPerWindow;
                for (int s = 0; s < this.SamplesPerWindow; ++s) {
                    dataIndex = s + shift;
                    if (dataIndex >= data.length) continue;
                    max = Math.max(max, Math.abs(data[dataIndex]));
                }
                float scalar = 125.0f / max;
                for (int s = 0; s < this.SamplesPerWindow; ++s) {
                    dataIndex = s + shift;
                    this.Data[dataIndex] = 0;
                    if (dataIndex >= data.length) continue;
                    this.Data[dataIndex] = (byte)(scalar * data[dataIndex]);
                }
                this.WindowScalar[w] = scalar;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public CompressedTrace(RandomAccessFile reader) throws Exception {
        try {
            this.read(reader);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void getData(float[] data) throws Exception {
        try {
            for (int w = 0; w < this.WindowCount; ++w) {
                float scalar = 1.0f / this.WindowScalar[w];
                for (int s = 0; s < this.SamplesPerWindow; ++s) {
                    int index = s + w * this.SamplesPerWindow;
                    if (index >= data.length) continue;
                    data[index] = scalar * (float)this.Data[index];
                }
            }
            for (int s = this.Data.length; s < data.length; ++s) {
                data[s] = 0.0f;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void read(RandomAccessFile reader) throws Exception {
        block11: {
            try {
                int magic = reader.readInt();
                if (magic != 24671) {
                    throw new Exception("magic != 24671");
                }
                int version = reader.readInt();
                if (version == 1001) {
                    this.ShotID = reader.readInt();
                    this.ReceiverID = reader.readInt();
                    this.TraceTableIndex = reader.readLong();
                    int windowCount = reader.readInt();
                    int samplesPerWindow = reader.readInt();
                    this.Time = reader.readFloat();
                    this.Digi = reader.readFloat();
                    if (this.WindowScalar == null || this.WindowCount != windowCount) {
                        this.Data = null;
                        this.WindowCount = windowCount;
                        this.WindowScalar = new float[this.WindowCount];
                    }
                    if (this.Data == null || samplesPerWindow != this.SamplesPerWindow) {
                        this.SamplesPerWindow = samplesPerWindow;
                        this.Data = new byte[this.WindowCount * this.SamplesPerWindow];
                    }
                    for (int w = 0; w < this.WindowCount; ++w) {
                        this.WindowScalar[w] = reader.readFloat();
                    }
                    reader.read(this.Data, 0, this.Data.length);
                    break block11;
                }
                if (version == 1000) {
                    this.ShotID = reader.readInt();
                    this.ReceiverID = reader.readInt();
                    this.TraceTableIndex = reader.readInt();
                    int windowCount = reader.readInt();
                    int samplesPerWindow = reader.readInt();
                    this.Time = reader.readFloat();
                    this.Digi = reader.readFloat();
                    if (this.WindowScalar == null || this.WindowCount != windowCount) {
                        this.Data = null;
                        this.WindowCount = windowCount;
                        this.WindowScalar = new float[this.WindowCount];
                    }
                    if (this.Data == null || samplesPerWindow != this.SamplesPerWindow) {
                        this.SamplesPerWindow = samplesPerWindow;
                        this.Data = new byte[this.WindowCount * this.SamplesPerWindow];
                    }
                    for (int w = 0; w < this.WindowCount; ++w) {
                        this.WindowScalar[w] = reader.readFloat();
                    }
                    reader.read(this.Data, 0, this.Data.length);
                    break block11;
                }
                throw new Exception("Bad version");
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                throw error;
            }
        }
    }

    public void write(RandomAccessFile writer) {
        try {
            int magic = 24671;
            int version = 1001;
            writer.writeInt(magic);
            writer.writeInt(version);
            if (version == 1001) {
                writer.writeInt(this.ShotID);
                writer.writeInt(this.ReceiverID);
                writer.writeLong(this.TraceTableIndex);
                writer.writeInt(this.WindowCount);
                writer.writeInt(this.SamplesPerWindow);
                writer.writeFloat(this.Time);
                writer.writeFloat(this.Digi);
                for (int w = 0; w < this.WindowCount; ++w) {
                    writer.writeFloat(this.WindowScalar[w]);
                }
                writer.write(this.Data, 0, this.Data.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

