/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.NumPy;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class NumPy {
    protected static float[] Offsets = null;
    protected static long[] TraceID = null;
    protected static long[] ShotLine = null;
    protected static long[] ShotPoint = null;
    protected static long[] ShotIndex = null;
    protected static long[] RecLine = null;
    protected static long[] RecPoint = null;
    protected static long[] RecIndex = null;
    private static final ByteBuffer LONGBUFFER = ByteBuffer.allocate(8);
    private static final ByteBuffer FLOATBUFFER = ByteBuffer.allocate(4);

    public static void addNumpy(ZipOutputStream stream, float[] data, int count) {
        try {
            String magicString = "NUMPY";
            int magicFirstByte = -109;
            byte[] magic = magicString.getBytes(StandardCharsets.UTF_8);
            int major = 1;
            int minor = 0;
            String descrString = "{'descr': 'Float32', ";
            byte[] descr = descrString.getBytes(StandardCharsets.UTF_8);
            String fortranString = "'fortran_order': False, ";
            byte[] fortran = fortranString.getBytes(StandardCharsets.UTF_8);
            String shapeString = "'shape': (" + count + ",1), }";
            byte[] shape = shapeString.getBytes(StandardCharsets.UTF_8);
            String endLine = "\n";
            byte[] endl = endLine.getBytes(StandardCharsets.UTF_8);
            int lengthPadding = 0;
            int bytesUsed = 1 + magic.length + 4 + descr.length + fortran.length + shape.length + endl.length;
            if (bytesUsed % 16 != 0) {
                lengthPadding = 16 - bytesUsed % 16;
            }
            byte[] headerLenByte = new byte[2];
            short headerLength = (short)(bytesUsed + lengthPadding - 10);
            headerLenByte[0] = (byte)headerLength;
            headerLenByte[1] = (byte)(headerLength >> 8);
            stream.write(magicFirstByte);
            stream.write(magic);
            stream.write(major);
            stream.write(minor);
            stream.write(headerLenByte);
            stream.write(descr);
            stream.write(fortran);
            stream.write(shape);
            if (lengthPadding > 0) {
                byte[] padding = new byte[lengthPadding];
                for (int i = 0; i < lengthPadding; ++i) {
                    padding[i] = 32;
                }
                stream.write(padding);
            }
            stream.write(endl);
            for (int n = 0; n < count; ++n) {
                stream.write(NumPy.float2ByteArray(data[n]));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void addNumpy(ZipOutputStream stream, long[] data, int count) {
        try {
            String magicString = "NUMPY";
            int magicFirstByte = -109;
            byte[] magic = magicString.getBytes(StandardCharsets.UTF_8);
            int major = 1;
            int minor = 0;
            String descrString = "{'descr': 'Int64', ";
            byte[] descr = descrString.getBytes(StandardCharsets.UTF_8);
            String fortranString = "'fortran_order': False, ";
            byte[] fortran = fortranString.getBytes(StandardCharsets.UTF_8);
            String shapeString = "'shape': (" + count + ",1), }";
            byte[] shape = shapeString.getBytes(StandardCharsets.UTF_8);
            String endLine = "\n";
            byte[] endl = endLine.getBytes(StandardCharsets.UTF_8);
            int lengthPadding = 0;
            int bytesUsed = 1 + magic.length + 4 + descr.length + fortran.length + shape.length + endl.length;
            if (bytesUsed % 16 != 0) {
                lengthPadding = 16 - bytesUsed % 16;
            }
            byte[] headerLenByte = new byte[2];
            short headerLength = (short)(bytesUsed + lengthPadding - 10);
            headerLenByte[0] = (byte)headerLength;
            headerLenByte[1] = (byte)(headerLength >> 8);
            stream.write(magicFirstByte);
            stream.write(magic);
            stream.write(major);
            stream.write(minor);
            stream.write(headerLenByte);
            stream.write(descr);
            stream.write(fortran);
            stream.write(shape);
            if (lengthPadding > 0) {
                byte[] padding = new byte[lengthPadding];
                for (int i = 0; i < lengthPadding; ++i) {
                    padding[i] = 32;
                }
                stream.write(padding);
            }
            stream.write(endl);
            for (int n = 0; n < count; ++n) {
                stream.write(NumPy.long2ByteArray(data[n]));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void addTraceDataNumpy(ZipOutputStream stream, Ensemble ensemble) {
        try {
            String magicString = "NUMPY";
            int magicFirstByte = -109;
            byte[] magic = magicString.getBytes(StandardCharsets.UTF_8);
            int major = 1;
            int minor = 0;
            String descrString = "{'descr': 'Float32', ";
            byte[] descr = descrString.getBytes(StandardCharsets.UTF_8);
            String fortranString = "'fortran_order': False, ";
            byte[] fortran = fortranString.getBytes(StandardCharsets.UTF_8);
            String shapeString = "'shape': (" + ensemble.traceCount() + "," + ensemble.trace(0).data().length() + "), }";
            byte[] shape = shapeString.getBytes(StandardCharsets.UTF_8);
            String endLine = "\n";
            byte[] endl = endLine.getBytes(StandardCharsets.UTF_8);
            int lengthPadding = 0;
            int bytesUsed = 1 + magic.length + 4 + descr.length + fortran.length + shape.length + endl.length;
            if (bytesUsed % 16 != 0) {
                lengthPadding = 16 - bytesUsed % 16;
            }
            byte[] headerLenByte = new byte[2];
            short headerLength = (short)(bytesUsed + lengthPadding - 10);
            headerLenByte[0] = (byte)headerLength;
            headerLenByte[1] = (byte)(headerLength >> 8);
            stream.write(magicFirstByte);
            stream.write(magic);
            stream.write(major);
            stream.write(minor);
            stream.write(headerLenByte);
            stream.write(descr);
            stream.write(fortran);
            stream.write(shape);
            if (lengthPadding > 0) {
                byte[] padding = new byte[lengthPadding];
                for (int i = 0; i < lengthPadding; ++i) {
                    padding[i] = 32;
                }
                stream.write(padding);
            }
            stream.write(endl);
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexTraceID = ensemble.dictionary().getEntryIndex("Trace", "TraceID");
            int indexShotLine = ensemble.dictionary().getEntryIndex("Shot", "LineNumber");
            int indexShotPoint = ensemble.dictionary().getEntryIndex("Shot", "PointNumber");
            int indexShotIndex = ensemble.dictionary().getEntryIndex("Shot", "PointIndex");
            int indexRecLine = ensemble.dictionary().getEntryIndex("Receiver", "LineNumber");
            int indexRecPoint = ensemble.dictionary().getEntryIndex("Receiver", "PointNumber");
            int indexRecIndex = ensemble.dictionary().getEntryIndex("Receiver", "PointIndex");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                float offset = trace.header().getFloat(indexOffset);
                long traceID = trace.header().getLong(indexTraceID);
                long shotLine = trace.header().getLong(indexShotLine);
                long shotPoint = trace.header().getLong(indexShotPoint);
                long shotIndex = trace.header().getLong(indexShotIndex);
                long recLine = trace.header().getLong(indexRecLine);
                long recPoint = trace.header().getLong(indexRecPoint);
                long recIndex = trace.header().getLong(indexRecIndex);
                NumPy.Offsets[n] = offset;
                NumPy.TraceID[n] = traceID;
                NumPy.ShotLine[n] = shotLine;
                NumPy.ShotPoint[n] = shotPoint;
                NumPy.ShotIndex[n] = shotIndex;
                NumPy.RecLine[n] = recLine;
                NumPy.RecPoint[n] = recPoint;
                NumPy.RecIndex[n] = recIndex;
                for (int s = 0; s < trace.data().length(); ++s) {
                    float sample = trace.data().getSample(n);
                    stream.write(NumPy.float2ByteArray(sample));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static byte[] gatherToNpz(Ensemble ensemble) {
        try {
            int traceCount = ensemble.traceCount();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ZipOutputStream zipStream = new ZipOutputStream(byteStream);
            Offsets = new float[traceCount];
            ShotLine = new long[traceCount];
            ShotPoint = new long[traceCount];
            ShotIndex = new long[traceCount];
            RecLine = new long[traceCount];
            RecPoint = new long[traceCount];
            RecIndex = new long[traceCount];
            ZipEntry npyData = new ZipEntry("trace");
            zipStream.putNextEntry(npyData);
            NumPy.addTraceDataNumpy(zipStream, ensemble);
            zipStream.closeEntry();
            ZipEntry npyOffset = new ZipEntry("offset");
            zipStream.putNextEntry(npyOffset);
            NumPy.addNumpy(zipStream, Offsets, traceCount);
            zipStream.closeEntry();
            ZipEntry npyTraceID = new ZipEntry("counter");
            zipStream.putNextEntry(npyTraceID);
            NumPy.addNumpy(zipStream, TraceID, traceCount);
            zipStream.closeEntry();
            ZipEntry npyShotLine = new ZipEntry("shotLine");
            zipStream.putNextEntry(npyShotLine);
            NumPy.addNumpy(zipStream, ShotLine, traceCount);
            zipStream.closeEntry();
            ZipEntry npyShotPoint = new ZipEntry("shotPoint");
            zipStream.putNextEntry(npyShotPoint);
            NumPy.addNumpy(zipStream, ShotPoint, traceCount);
            zipStream.closeEntry();
            ZipEntry npyShotIndex = new ZipEntry("shotIndex");
            zipStream.putNextEntry(npyShotIndex);
            NumPy.addNumpy(zipStream, ShotIndex, traceCount);
            zipStream.closeEntry();
            ZipEntry npyRecLine = new ZipEntry("recieverLine");
            zipStream.putNextEntry(npyRecLine);
            NumPy.addNumpy(zipStream, RecLine, traceCount);
            zipStream.closeEntry();
            ZipEntry npyRecPoint = new ZipEntry("recieverPoint");
            zipStream.putNextEntry(npyRecPoint);
            NumPy.addNumpy(zipStream, RecPoint, traceCount);
            zipStream.closeEntry();
            ZipEntry npyRecIndex = new ZipEntry("recieverIndex");
            zipStream.putNextEntry(npyRecIndex);
            NumPy.addNumpy(zipStream, RecIndex, traceCount);
            zipStream.closeEntry();
            byte[] npz = byteStream.toByteArray();
            return npz;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static byte[] float2ByteArray(float value) {
        return FLOATBUFFER.putFloat(value).array();
    }

    public static byte[] long2ByteArray(long value) {
        return LONGBUFFER.putLong(value).array();
    }
}

