/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Model;

import java.util.HashMap;
import java.util.Set;

public class Model3D_Profile {
    protected double m_originZ = 0.0;
    protected double m_nodeSpacing = 25.0;
    protected int m_nodeCountH = 1;
    protected int m_nodeCountZ = 1;
    public int[] LowerIndexX = new int[3];
    public int[] UpperIndexX = new int[3];
    public float[] LowerWeightX = new float[3];
    public float[] UpperWeightX = new float[3];
    public int[] LowerIndexY = new int[3];
    public int[] UpperIndexY = new int[3];
    public float[] LowerWeightY = new float[3];
    public float[] UpperWeightY = new float[3];
    public double[] X;
    public double[] Y;
    public int NumNodesH;
    protected double m_x1;
    protected double m_y1;
    protected double m_x2;
    protected double m_y2;
    protected double m_azimuth;
    protected double m_offset;
    protected int m_maximumIndexH;
    protected HashMap<String, float[][]> m_hash = new HashMap();
    protected int m_lowerIndex;
    protected int m_upperIndex;
    protected float m_lowerWeight;
    protected float m_upperWeight;

    public double originZ() {
        return this.m_originZ;
    }

    public double nodeSpacing() {
        return this.m_nodeSpacing;
    }

    public void setNodeSpacing(double nodeSpacing) {
        this.m_nodeSpacing = Math.max(nodeSpacing, 1.0);
    }

    public int nodeCountZ() {
        return this.m_nodeCountZ;
    }

    public void setNodeCountZ(int nodeCountZ) {
        if (this.m_nodeCountZ != (nodeCountZ = Math.max(nodeCountZ, 2))) {
            this.freeMemory();
        }
        this.m_nodeCountZ = nodeCountZ;
    }

    public void setOriginZ(double originZ) {
        this.m_originZ = originZ;
    }

    public int maximumIndexH() {
        return this.m_maximumIndexH;
    }

    public double x1() {
        return this.m_x1;
    }

    public double y1() {
        return this.m_y1;
    }

    public double x2() {
        return this.m_x2;
    }

    public double y2() {
        return this.m_y2;
    }

    public double offset() {
        return this.m_offset;
    }

    public double azimuth() {
        return this.m_azimuth;
    }

    public void setEndPointCoords(double x1, double y1, double x2, double y2) {
        try {
            this.m_x1 = x1;
            this.m_y1 = y1;
            this.m_x2 = x2;
            this.m_y2 = y2;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.m_offset = Math.sqrt(1.0E-20 + dx * dx + dy * dy);
            this.m_azimuth = Math.atan2(dy, dx);
            this.NumNodesH = 2 + (int)(this.m_offset / this.m_nodeSpacing);
            if (this.NumNodesH >= this.m_nodeCountH) {
                this.freeMemory();
                this.m_nodeCountH = this.NumNodesH + 20;
                this.X = new double[this.m_nodeCountH];
                this.Y = new double[this.m_nodeCountH];
                this.LowerIndexX = new int[this.m_nodeCountH];
                this.UpperIndexX = new int[this.m_nodeCountH];
                this.LowerIndexY = new int[this.m_nodeCountH];
                this.UpperIndexY = new int[this.m_nodeCountH];
                this.LowerWeightX = new float[this.m_nodeCountH];
                this.UpperWeightX = new float[this.m_nodeCountH];
                this.LowerWeightY = new float[this.m_nodeCountH];
                this.UpperWeightY = new float[this.m_nodeCountH];
            }
            for (int n = 0; n < this.NumNodesH; ++n) {
                this.X[n] = x1 + this.m_nodeSpacing * Math.cos(this.m_azimuth);
                this.Y[n] = y1 + this.m_nodeSpacing * Math.sin(this.m_azimuth);
            }
            this.m_maximumIndexH = this.NumNodesH - 1;
            double temp = (double)this.m_maximumIndexH * this.m_nodeSpacing;
            while (temp > this.m_offset - 0.1 * this.m_nodeSpacing) {
                --this.m_maximumIndexH;
                temp = (double)this.m_maximumIndexH * this.m_nodeSpacing;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void freeMemory() {
        try {
            this.m_hash.clear();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public float[][] getDataArray(String key) throws Exception {
        try {
            if (!this.m_hash.containsKey(key)) {
                this.m_hash.put(key, new float[this.m_nodeCountH][this.m_nodeCountZ]);
            }
            return this.m_hash.get(key);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void removeDataArray(String key) {
        try {
            if (this.m_hash.containsKey(key)) {
                this.m_hash.remove(key);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public Set<String> getDataNames() {
        return this.m_hash.keySet();
    }

    protected void prepZ(double z) {
        try {
            if (z <= this.m_originZ) {
                this.m_lowerIndex = 0;
                this.m_upperIndex = 0;
                this.m_lowerWeight = 1.0f;
                this.m_upperWeight = 0.0f;
                return;
            }
            this.m_lowerIndex = (int)((z - this.m_originZ) / this.m_nodeSpacing);
            if (this.m_lowerIndex >= this.m_nodeCountZ - 1) {
                this.m_lowerIndex = this.m_nodeCountZ - 1;
                this.m_upperIndex = this.m_nodeCountZ - 1;
                this.m_lowerWeight = 1.0f;
                this.m_upperWeight = 0.0f;
                return;
            }
            this.m_upperIndex = this.m_lowerIndex + 1;
            double lowerZ = this.m_originZ + (double)this.m_lowerIndex * this.m_nodeSpacing;
            this.m_upperWeight = (float)((z - lowerZ) / this.m_nodeSpacing);
            this.m_lowerWeight = 1.0f - this.m_upperWeight;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void propagate_RayTracing(double fromZ, double toZ) throws Exception {
        try {
            this.prepZ(fromZ);
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }
}

