/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Model;

import com.PecosCore.Shared.Range_Double;
import java.io.RandomAccessFile;

public class Model3D_CoordinateConversion {
    public double m_originX = 0.0;
    public double m_originY = 0.0;
    public double m_originZ = 0.0;
    public double m_angle = 0.0;
    protected double m_cosineAngle = 1.0;
    protected double m_sineAngle = 0.0;
    public Range_Double RangeX = new Range_Double();
    public Range_Double RangeY = new Range_Double();
    public Range_Double RangeZ = new Range_Double();
    public double WorldX;
    public double WorldY;
    public double WorldZ;
    public double GridX;
    public double GridY;
    public double GridZ;

    public void prepareRangeFinder() {
        this.RangeX.clearRange();
        this.RangeY.clearRange();
        this.RangeZ.clearRange();
    }

    public void addToRangeFinder(double x, double y, double z) {
        try {
            this.convertWorldCoordinatesToModelCoordinates(x, y, z);
            this.RangeX.expandRange(this.GridX);
            this.RangeY.expandRange(this.GridY);
            this.RangeZ.expandRange(this.GridZ);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addToRangeFinder(double x, double y, double z, double buffer) {
        this.addToRangeFinder(x - buffer, y - buffer, z - buffer);
        this.addToRangeFinder(x - buffer, y + buffer, z - buffer);
        this.addToRangeFinder(x + buffer, y - buffer, z - buffer);
        this.addToRangeFinder(x + buffer, y + buffer, z - buffer);
        this.addToRangeFinder(x - buffer, y - buffer, z + buffer);
        this.addToRangeFinder(x - buffer, y + buffer, z + buffer);
        this.addToRangeFinder(x + buffer, y - buffer, z + buffer);
        this.addToRangeFinder(x + buffer, y + buffer, z + buffer);
    }

    public double angle() {
        return this.m_angle;
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
        this.computeInternals(true);
    }

    public void setOrigin(double ox, double oy, double oz) {
        this.m_originX = ox;
        this.m_originY = oy;
        this.m_originZ = oz;
        this.computeInternals(true);
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public double originZ() {
        return this.m_originZ;
    }

    public void read(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (1000923 != magic) {
                throw new Exception("1000923 != magic");
            }
            int version = file.readInt();
            if (version != 1000) {
                throw new Exception("bad version");
            }
            this.m_originX = file.readDouble();
            this.m_originY = file.readDouble();
            this.m_originZ = file.readDouble();
            this.m_angle = file.readDouble();
            this.computeInternals(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void save(RandomAccessFile file) {
        try {
            int magic = 1000923;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.m_originX);
                file.writeDouble(this.m_originY);
                file.writeDouble(this.m_originZ);
                file.writeDouble(this.m_angle);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void computeInternals(boolean prepRangeFinder) {
        try {
            this.m_cosineAngle = Math.cos(this.m_angle);
            this.m_sineAngle = Math.sin(this.m_angle);
            if (prepRangeFinder) {
                this.prepareRangeFinder();
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public synchronized void convertModeCoordinatesToWorldCoordinates(double gridX, double gridY, double gridZ) {
        try {
            this.GridX = gridX;
            this.GridY = gridY;
            this.GridZ = gridZ;
            this.WorldX = this.m_originX + this.m_cosineAngle * gridX - this.m_sineAngle * gridY;
            this.WorldY = this.m_originY + this.m_cosineAngle * gridY - this.m_sineAngle * gridX;
            this.WorldZ = this.m_originZ + gridZ;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public synchronized void convertWorldCoordinatesToModelCoordinates(double worldX, double worldY, double worldZ) {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            this.WorldZ = worldZ;
            double dx = worldX - this.m_originX;
            double dy = worldY - this.m_originY;
            double dz = worldZ - this.m_originZ;
            this.GridY = this.m_cosineAngle * dy - this.m_sineAngle * dx;
            this.GridX = this.m_cosineAngle * dx + this.m_sineAngle * dy;
            this.GridZ = dz;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

