/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Model;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import java.io.RandomAccessFile;

public class Model2D {
    public double m_originX = 0.0;
    public double m_originY = 0.0;
    public double m_binSizeX = 25.0;
    public double m_binSizeY = 25.0;
    public double m_angle = 0.0;
    protected double m_inverseBinSizeX = 0.04;
    protected double m_inverseBinSizeY = 0.04;
    protected double m_cosineAngle = 0.0;
    protected double m_sineAngle = 0.0;
    public Range_Double RangeX = new Range_Double();
    public Range_Double RangeY = new Range_Double();
    public static final String FileName = "GridDefinition3D.xml";
    public static final String OriginX = "OriginX";
    public static final String OriginY = "OriginY";
    public static final String BinSizeX = "BinSizeX";
    public static final String BinSizeY = "BinSizeY";
    public static final String Angle = "Angle";
    public double WorldX;
    public double WorldY;
    public double GridX;
    public double GridY;
    public int IndexX;
    public int IndexY;

    public Model2D() {
        this.computeInternals(true);
        this.prepareRangeFinder();
    }

    public void prepareRangeFinder() {
        this.RangeX.clearRange();
        this.RangeY.clearRange();
    }

    public void addToRangeFinder(double x, double y) {
        try {
            this.setWorldLocation(x, y);
            this.RangeX.expandRange(this.GridX);
            this.RangeY.expandRange(this.GridY);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addToRangeFinder(double x, double y, double buffer) {
        this.addToRangeFinder(x - buffer, y - buffer);
        this.addToRangeFinder(x - buffer, y + buffer);
        this.addToRangeFinder(x + buffer, y - buffer);
        this.addToRangeFinder(x + buffer, y + buffer);
    }

    public Model2D clone() {
        Model2D grid = new Model2D();
        grid.m_originX = this.m_originX;
        grid.m_originY = this.m_originY;
        grid.m_binSizeX = this.m_binSizeX;
        grid.m_binSizeY = this.m_binSizeY;
        grid.m_angle = this.m_angle;
        grid.computeInternals(true);
        return grid;
    }

    public double angle() {
        return this.m_angle;
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
        this.computeInternals(true);
    }

    public void setBinSize(double sizeX, double sizeY) {
        this.m_binSizeX = sizeX;
        this.m_binSizeY = sizeY;
        this.computeInternals(true);
    }

    public double binSizeY() {
        return this.m_binSizeY;
    }

    public double binSizeX() {
        return this.m_binSizeX;
    }

    public void setOrigin(double ox, double oy) {
        this.m_originX = ox;
        this.m_originY = oy;
        this.computeInternals(true);
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public void read(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (1000923 != magic) {
                throw new Exception("1000923 != magic");
            }
            int version = file.readInt();
            if (version != 1000) {
                throw new Exception("bad version");
            }
            this.m_originX = file.readDouble();
            this.m_originY = file.readDouble();
            this.m_binSizeX = file.readDouble();
            this.m_binSizeY = file.readDouble();
            this.m_angle = file.readDouble();
            this.computeInternals(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(RandomAccessFile file) {
        try {
            int magic = 1000923;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.m_originX);
                file.writeDouble(this.m_originY);
                file.writeDouble(this.m_binSizeX);
                file.writeDouble(this.m_binSizeY);
                file.writeDouble(this.m_angle);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName) {
        try {
            ParameterTree tree = new ParameterTree();
            tree.double_put(OriginX, this.m_originX);
            tree.double_put(OriginY, this.m_originY);
            tree.double_put(BinSizeX, this.m_binSizeX);
            tree.double_put(BinSizeY, this.m_binSizeY);
            tree.double_put(Angle, this.m_angle);
            tree.save(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            ParameterTree tree = new ParameterTree();
            tree.read(fileName);
            this.m_originX = tree.double_get(OriginX, 0.0);
            this.m_originY = tree.double_get(OriginY, 0.0);
            this.m_binSizeX = tree.double_get(BinSizeX, 0.0);
            this.m_binSizeY = tree.double_get(BinSizeY, 0.0);
            this.m_angle = tree.double_get(Angle, 0.0);
            this.computeInternals(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeInternals(boolean prepRangeFinder) {
        try {
            this.m_cosineAngle = Math.cos(this.m_angle);
            this.m_sineAngle = Math.sin(this.m_angle);
            this.m_inverseBinSizeX = 1.0 / this.m_binSizeX;
            this.m_inverseBinSizeY = 1.0 / this.m_binSizeY;
            if (prepRangeFinder) {
                this.prepareRangeFinder();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setWorldLocation(double worldX, double worldY) {
        try {
            this.WorldX = worldX;
            this.WorldY = worldY;
            double dx = worldX - this.m_originX;
            double dy = worldY - this.m_originY;
            this.GridY = this.m_cosineAngle * dy - this.m_sineAngle * dx;
            this.GridX = this.m_cosineAngle * dx + this.m_sineAngle * dy;
            this.IndexX = (int)Math.round(this.GridX * this.m_inverseBinSizeX);
            this.IndexY = (int)Math.round(this.GridY * this.m_inverseBinSizeY);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

