/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class Column_Text
extends Column_Abstract
implements Serializable {
    protected ArrayList<String> m_array = new ArrayList();

    public Column_Text() {
    }

    @Override
    public String uniqueID() {
        return "Column_Text";
    }

    public Column_Text(String name) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Column_Text(String name, int minLength) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            for (int n = 0; n < minLength; ++n) {
                this.m_array.add("");
            }
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void remove(int row) {
        try {
            this.m_array.remove(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void sort(int count) {
        try {
            Collections.sort(this.m_array);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void save(RandomAccessFile writer) throws Exception {
        try {
            writer.writeInt(92876464);
            writer.writeInt(1000);
            writer.writeUTF(this.m_name);
            writer.writeInt(this.m_array.size());
            for (int n = 0; n < this.m_array.size(); ++n) {
                writer.writeUTF(this.m_array.get(n));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void read(RandomAccessFile reader) throws Exception {
        block5: {
            try {
                this.m_array.clear();
                int magic = reader.readInt();
                if (magic != 92876464) {
                    throw new Exception("magic != Magic");
                }
                int version = reader.readInt();
                if (version == 1000) {
                    this.m_name = reader.readUTF();
                    int len = reader.readInt();
                    for (int n = 0; n < len; ++n) {
                        this.m_array.add(reader.readUTF());
                    }
                    break block5;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    @Override
    public Column_Abstract createExactCopy() {
        try {
            Column_Text col = new Column_Text(this.m_name, this.m_array.size());
            for (int n = 0; n < this.m_array.size(); ++n) {
                col.putString(n, this.m_array.get(n));
            }
            col.clearModificationFlag();
            return col;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public DataType type() {
        return DataType.Text;
    }

    protected void resize(int row) throws Exception {
        try {
            if (row < this.m_array.size()) {
                return;
            }
            int numNeeded = 5 + row - this.m_array.size();
            for (int n = 0; n < numNeeded; ++n) {
                this.m_array.add("");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putBool(int row, boolean value) throws Exception {
        try {
            this.putString(row, Boolean.toString(value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean getBool(int row) throws Exception {
        try {
            return Boolean.parseBoolean(this.getString(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putLong(int row, long value) throws Exception {
        try {
            this.putString(row, Long.toString(value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public long getLong(int row) throws Exception {
        try {
            return Long.parseLong(this.getString(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putInt(int row, int value) throws Exception {
        try {
            this.putString(row, Integer.toString(value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public int getInt(int row) throws Exception {
        try {
            return Integer.parseInt(this.getString(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putFloat(int row, float value) throws Exception {
        try {
            this.putString(row, Float.toString(value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getFloat(int row) throws Exception {
        try {
            return Float.parseFloat(this.getString(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putDouble(int row, double value) throws Exception {
        try {
            this.putString(row, Double.toString(value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public double getDouble(int row) throws Exception {
        try {
            return Double.parseDouble(this.getString(row));
        }
        catch (Exception ex) {
            return -9999.0;
        }
    }

    @Override
    public void putString(int row, String value) throws Exception {
        try {
            this.resize(row);
            this.m_array.set(row, value);
            this.setModified(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public String getString(int row, int numDecimals) throws Exception {
        return this.getString(row);
    }

    @Override
    public String getString(int row) throws Exception {
        try {
            this.resize(row);
            return this.m_array.get(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putIntArray(int row, int[] iVals) {
    }

    @Override
    public int[] getIntArray(int row) {
        return null;
    }

    @Override
    public void putFloatArray(int row, float[] fVals) {
    }

    @Override
    public float[] getFloatArray(int row) {
        return null;
    }

    public int getArrayLength() {
        return 0;
    }
}

