/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Column_Int
extends Column_Abstract
implements Serializable {
    protected int[] m_data = new int[100];

    public Column_Int() {
    }

    @Override
    public String uniqueID() {
        return "Column_Int";
    }

    public Column_Int(String name) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            this.m_data = new int[100];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Column_Int(String name, int minLength) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            int len = Math.max(100, minLength + 100);
            this.m_data = new int[len];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void remove(int row) {
        try {
            for (int n = row; n < this.m_data.length - 1; ++n) {
                this.m_data[n] = this.m_data[n + 1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void sort(int count) {
        try {
            count = Math.min(this.m_data.length, count);
            boolean swapMade = true;
            while (swapMade) {
                swapMade = false;
                for (int n = 0; n < count - 1; ++n) {
                    int v1 = this.m_data[n];
                    int v2 = this.m_data[n + 1];
                    if (v1 <= v2) continue;
                    swapMade = true;
                    this.m_data[n] = v2;
                    this.m_data[n + 1] = v1;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void save(RandomAccessFile writer) throws Exception {
        try {
            writer.writeInt(92876464);
            writer.writeInt(1000);
            writer.writeUTF(this.m_name);
            writer.writeInt(this.m_data.length);
            int numBytes = 4 * this.m_data.length;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            for (int n = 0; n < this.m_data.length; ++n) {
                buff.putInt(this.m_data[n]);
            }
            writer.write(buff.array(), 0, numBytes);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void read(RandomAccessFile reader) throws Exception {
        block5: {
            try {
                int magic = reader.readInt();
                if (magic != 92876464) {
                    throw new Exception("magic != Magic");
                }
                int version = reader.readInt();
                if (version == 1000) {
                    this.m_name = reader.readUTF();
                    int len = reader.readInt();
                    this.m_data = new int[len];
                    int numBytes = 4 * len;
                    ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < this.m_data.length; ++n) {
                        this.m_data[n] = buff.getInt();
                    }
                    break block5;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    @Override
    public Column_Abstract createExactCopy() {
        try {
            Column_Int col = new Column_Int(this.m_name, this.m_data.length);
            for (int n = 0; n < this.m_data.length; ++n) {
                col.putInt(n, this.m_data[n]);
            }
            col.clearModificationFlag();
            return col;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public DataType type() {
        return DataType.Int;
    }

    protected void resize(int row) throws Exception {
        try {
            if (row < this.m_data.length) {
                return;
            }
            int newLength = row + this.m_data.length / 2;
            int[] tempArray = Arrays.copyOf(this.m_data, newLength);
            for (int n = this.m_data.length; n < newLength; ++n) {
                tempArray[n] = -999999;
            }
            this.m_data = null;
            this.m_data = tempArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putBool(int row, boolean value) throws Exception {
        try {
            if (value) {
                this.putInt(row, 1);
            } else {
                this.putInt(row, 0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean getBool(int row) throws Exception {
        try {
            return this.getInt(row) != 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putLong(int row, long value) throws Exception {
        try {
            this.resize(row);
            this.m_data[row] = (int)value;
            this.setModified(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public long getLong(int row) throws Exception {
        try {
            this.resize(row);
            return this.m_data[row];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putInt(int row, int value) throws Exception {
        try {
            this.resize(row);
            this.m_data[row] = value;
            this.setModified(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public int getInt(int row) throws Exception {
        try {
            this.resize(row);
            return this.m_data[row];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putFloat(int row, float value) throws Exception {
        try {
            this.putInt(row, Math.round(value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getFloat(int row) throws Exception {
        try {
            return this.getInt(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putDouble(int row, double value) throws Exception {
        try {
            this.putInt(row, Math.round((float)value));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public double getDouble(int row) throws Exception {
        try {
            return this.getInt(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putString(int row, String value) throws Exception {
        try {
            try {
                value = Tools_Strings.removeSpace(value);
                int v = Integer.parseInt(value);
                this.putInt(row, v);
            }
            catch (Exception error) {
                this.putInt(row, -999999);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public String getString(int row, int numDecimals) throws Exception {
        return this.getString(row);
    }

    @Override
    public String getString(int row) throws Exception {
        try {
            return Integer.toString(this.getInt(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putIntArray(int row, int[] iVals) {
    }

    @Override
    public int[] getIntArray(int row) {
        return null;
    }

    @Override
    public void putFloatArray(int row, float[] fVals) {
    }

    @Override
    public float[] getFloatArray(int row) {
        return null;
    }

    public int getArrayLength() {
        return 0;
    }
}

