/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util.datavolume;

import java.io.Serializable;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;

public class VolumeParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long _ext_size = -1L;
    private String _type = null;
    private String _format = null;
    private String _name = null;
    private String _path = null;
    private String _root = null;
    private String[] _hosts = null;
    private String _location = null;
    private String _policy = null;
    private boolean _initialize = true;

    public VolumeParameters(long ext_size, DataType type, DataFormat format, String name, String path, String root, String[] hosts, String location, ExtentPolicy policy) {
        this._ext_size = ext_size;
        this._type = type.getName();
        this._format = type.getName();
        this._name = name;
        this._path = path;
        this._root = root;
        this._hosts = this.copyHosts(hosts);
        this._location = location;
        this._policy = policy.getID();
    }

    private String[] copyHosts(String[] hosts) {
        String[] retval = null;
        if (hosts != null && hosts.length > 0) {
            retval = new String[hosts.length];
            for (int k2 = 0; k2 < hosts.length; ++k2) {
                retval[k2] = hosts[k2];
            }
        }
        return retval;
    }

    public void setInitializeFlag(boolean initialize) {
        this._initialize = initialize;
    }

    public long getExtSize() {
        return this._ext_size;
    }

    public String getDataTypeName() {
        return this._type;
    }

    public String getFormatName() {
        return this._format;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public String getRoot() {
        return this._root;
    }

    public String[] getHosts() {
        return this._hosts;
    }

    public String getLocation() {
        return this._location;
    }

    public String getExtentPolicyID() {
        return this._policy;
    }

    public boolean getInitializeFlag() {
        return this._initialize;
    }
}

