/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.examples;

import edu.mines.jtk.util.ParameterSet;
import java.io.File;
import java.util.Iterator;
import org.javaseis.io.Seisio;
import org.javaseis.parset.ParameterSetIO;
import org.javaseis.util.SeisException;

public class CalculateRMSValue {
    public static void main(String[] args) throws SeisException {
        ParameterSet parset = ParameterSetIO.argsToParameters(args);
        String path = parset.getString("path", System.getProperty("user.home") + File.separator + "jsCreateTest");
        System.out.println("Calculate RMS trace value of JavaSeis dataset\nPath: " + path);
        Seisio sio = new Seisio(path);
        sio.open("r");
        float[][] trc = sio.getTraceDataArray();
        Iterator<int[]> frames = sio.frameIterator();
        double rms = 0.0;
        double sum = 0.0;
        while (frames.hasNext()) {
            frames.next();
            int ntrc = sio.getTracesInFrame();
            for (int j = 0; j < ntrc; ++j) {
                for (int i = 0; i < trc[j].length; ++i) {
                    sum += 1.0;
                    rms += (double)(trc[j][i] * trc[j][i]);
                }
            }
        }
        rms = Math.sqrt(rms / sum);
        System.out.println("RMS Value of dataset = " + rms);
    }
}

