/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.CleanHandler;
import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.javaseis.array.beta.DecompositionType;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.FrameIterator;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.array.beta.TraceIterator;
import org.javaseis.array.beta.VolumeIterator;
import org.javaseis.distributed.beta.ParallelArray;
import org.javaseis.distributed.beta.ParallelArrayPositionIterator;
import org.javaseis.iterators.beta.IPositionIterator;
import org.javaseis.parallel.UniprocessorContext;
import org.junit.Test;

public class JTestIterators {
    private static final Logger LOG = Logger.getLogger(JTestIterators.class.getName());

    @Test
    public void testFlexArrayPositionIterator() {
        int[] shape = new int[]{11, 3};
        IFlexArray<int[]> array = FlexArray.createIntArray(shape);
        IPositionIterator<int[]> it = array.newPositionIterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)3);
        Assert.assertFalse((boolean)it.hasNext());
        it.reset();
        Assert.assertTrue((boolean)it.hasNext());
        count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void testParallelArrayPositionIterator() {
        int[] shape = new int[]{11, 3, 5};
        UniprocessorContext pc = new UniprocessorContext();
        ParallelArray array = new ParallelArray(int[].class, 1, shape, DecompositionType.BLOCK, pc);
        IPositionIterator<int[]> it = array.newPositionIterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)15);
        Assert.assertFalse((boolean)it.hasNext());
        it.reset();
        Assert.assertTrue((boolean)it.hasNext());
        count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        Assert.assertEquals((int)count, (int)15);
    }

    @Test
    public void testTraceIterator() {
        int[] shape = new int[]{11, 3};
        IFlexArray<int[]> array = FlexArray.createIntArray(shape);
        TraceIterator<int[]> it = new TraceIterator<int[]>(array);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)3);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            int[] t = it.next();
            Assert.assertNotNull((Object)t);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void testTraceIterator2() {
        int[] shape = new int[]{11, 3, 1};
        UniprocessorContext pc = new UniprocessorContext();
        ParallelArray array = new ParallelArray(int[].class, 1, shape, DecompositionType.BLOCK, pc);
        TraceIterator it = new TraceIterator(array);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)3);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            int[] t = (int[])it.next();
            Assert.assertNotNull((Object)t);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void testTraceForEach() {
        int[] shape = new int[]{11, 3};
        IFlexArray<int[]> array = FlexArray.createIntArray(shape);
        TraceIterator<int[]> it = new TraceIterator<int[]>(array);
        int count = 0;
        for (int[] trace : it) {
            ++count;
            Assert.assertNotNull((Object)trace);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void testTraceForEach2() {
        int[] shape = new int[]{11, 3, 5};
        UniprocessorContext pc = new UniprocessorContext();
        ParallelArray array = new ParallelArray(int[].class, 1, shape, DecompositionType.BLOCK, pc);
        TraceIterator it = new TraceIterator(array);
        int count = 0;
        for (int[] trace : it) {
            ++count;
            Assert.assertNotNull((Object)trace);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)15);
    }

    @Test
    public void testTraceIteratorReverse() {
        int[] t;
        int[] shape = new int[]{11, 3, 6};
        IFlexArray<int[]> array = FlexArray.createIntArray(shape);
        int[] position = new int[]{0, 2, 5};
        PositionIterator positionIterator = new PositionIterator(shape, position, IPositionIterator.Direction.REVERSE, IPositionIterator.Scope.TRACE_AXIS);
        TraceIterator<int[]> it = new TraceIterator<int[]>(array, positionIterator);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            t = it.next();
            Assert.assertNotNull((Object)t);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)18);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            t = it.next();
            Assert.assertNotNull((Object)t);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)18);
    }

    @Test
    public void testTraceIteratorReverse2() {
        int[] t;
        int[] shape = new int[]{11, 3, 6};
        UniprocessorContext pc = new UniprocessorContext();
        ParallelArray array = new ParallelArray(int[].class, 1, shape, DecompositionType.BLOCK, pc);
        ParallelArrayPositionIterator positionIterator = new ParallelArrayPositionIterator(array.getDecomposition(), array.getShape(), IPositionIterator.Direction.REVERSE, IPositionIterator.Scope.TRACE_AXIS);
        TraceIterator it = new TraceIterator(array, positionIterator);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            t = (int[])it.next();
            Assert.assertNotNull((Object)t);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)18);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            t = (int[])it.next();
            Assert.assertNotNull((Object)t);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)count, (int)18);
    }

    @Test
    public void testFrameIterator() {
        int[][] frame;
        int[] shape = new int[]{11, 13, 5};
        IFlexArray<int[]> array = FlexArray.createIntArray(shape);
        FrameIterator it = new FrameIterator(array);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            frame = (int[][])it.next();
            Assert.assertNotNull((Object)frame);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)5, (int)count);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            frame = (int[][])it.next();
            Assert.assertNotNull((Object)frame);
            LOG.fine(Arrays.toString(it.getPosition()));
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)5, (int)count);
    }

    @Test
    public void testFrameIterator2() {
        int[][] frame;
        int[] shape = new int[]{11, 13, 5};
        UniprocessorContext pc = new UniprocessorContext();
        ParallelArray array = new ParallelArray(int[].class, 1, shape, DecompositionType.BLOCK, pc);
        FrameIterator it = new FrameIterator(array);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            frame = (int[][])it.next();
            Assert.assertNotNull((Object)frame);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)5, (int)count);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            frame = (int[][])it.next();
            Assert.assertNotNull((Object)frame);
            LOG.fine(Arrays.toString(it.getPosition()));
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)5, (int)count);
    }

    @Test
    public void testVolumeIterator() {
        int[][][] volume;
        int[] shape = new int[]{11, 3, 5};
        IFlexArray<int[]> array = FlexArray.createIntArray(shape);
        VolumeIterator it = new VolumeIterator(array);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            volume = (int[][][])it.next();
            Assert.assertNotNull((Object)volume);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)1, (int)count);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            volume = (int[][][])it.next();
            Assert.assertNotNull((Object)volume);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)1, (int)count);
    }

    @Test
    public void testVolumeIterator2() {
        int[][][] volume;
        int[] shape = new int[]{11, 3, 5};
        UniprocessorContext pc = new UniprocessorContext();
        ParallelArray array = new ParallelArray(int[].class, 1, shape, DecompositionType.BLOCK, pc);
        VolumeIterator it = new VolumeIterator(array);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            volume = (int[][][])it.next();
            Assert.assertNotNull((Object)volume);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)1, (int)count);
        it.reset();
        count = 0;
        while (it.hasNext()) {
            ++count;
            volume = (int[][][])it.next();
            Assert.assertNotNull((Object)volume);
            LOG.fine(Arrays.toString(it.getPosition()));
        }
        Assert.assertEquals((int)1, (int)count);
    }

    static {
        CleanHandler.setDefaultHandler();
    }
}

