/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Wizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleWizardDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    public boolean Finish = false;
    public boolean FinishPageRequest = false;
    protected ArrayList<Page> m_pageList;
    protected int m_currentIndex = 0;
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected JLabel m_pageLabel = new JLabel("", 0);
    protected JLabel m_numberLabel = new JLabel("", 0);
    protected JButton m_nextButton;
    protected JButton m_prevButton;
    protected JButton m_cancelButton;

    public SimpleWizardDialog(ArrayList<Page> pageList, String title, int width, int height) {
        this(pageList, title, width, height, false);
    }

    public SimpleWizardDialog(ArrayList<Page> pageList, String title, int width, int height, boolean dispose) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_pageList = pageList;
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_pageLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_pageLabel.setForeground(Color.blue);
            Tools_FontChanger.changeSizeOfFont(this.m_pageLabel, 3, true);
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            middle.addComponent(this.m_pageLabel, 0);
            middle.addComponent(this.m_mainPanel, 10);
            for (Page page : pageList) {
                ISimpleWizardPage wp;
                this.m_mainPanel.add((Component)page.PageComponent, page.Label);
                if (!(page.PageComponent instanceof ISimpleWizardPage) || (wp = (ISimpleWizardPage)((Object)page.PageComponent)).listener() == null) continue;
                wp.listener().addListener(this);
            }
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this.m_cancelButton = bottom.createButton("Cancel", this, 0);
            bottom.addComponent(this.m_numberLabel, 10);
            this.m_prevButton = bottom.createButton("Previous <<", this, 0);
            this.m_nextButton = bottom.createButton("Next >>", this, 0);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setButtonState();
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            if (dispose) {
                this.setDefaultCloseOperation(2);
            } else {
                this.setDefaultCloseOperation(1);
            }
            this.setSize(width, height);
            this.setLocationRelativeTo(null);
            this.setTitle(title);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            ISimpleWizardPage wp;
            this.Finish = false;
            for (Page page : this.m_pageList) {
                if (!(page.PageComponent instanceof ISimpleWizardPage)) continue;
                wp = (ISimpleWizardPage)((Object)page.PageComponent);
                wp.dialogJustOpened();
            }
            this.m_currentIndex = 0;
            this.setButtonState();
            for (Page page : this.m_pageList) {
                if (!(page.PageComponent instanceof ISimpleWizardPage)) continue;
                wp = (ISimpleWizardPage)((Object)page.PageComponent);
                wp.dialogJustOpened();
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            String s;
            if (data != null && data instanceof String && (s = (String)data).equalsIgnoreCase("FinishWizard")) {
                this.Finish = true;
                this.FinishPageRequest = true;
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void setButtonState() {
        try {
            this.m_numberLabel.setText(String.format("%d of %d", this.m_currentIndex + 1, this.m_pageList.size()));
            if (this.m_currentIndex >= this.m_pageList.size() - 1) {
                this.m_nextButton.setText("Finish");
            } else {
                this.m_nextButton.setText("Next >>");
            }
            this.m_prevButton.setEnabled(this.m_currentIndex >= 1);
            this.m_pageLabel.setText(this.m_pageList.get((int)this.m_currentIndex).Title);
            this.m_cardLayout.show(this.m_mainPanel, this.m_pageList.get((int)this.m_currentIndex).Label);
            if (this.m_pageList.get((int)this.m_currentIndex).PageComponent instanceof ISimpleWizardPage) {
                ISimpleWizardPage page = (ISimpleWizardPage)((Object)this.m_pageList.get((int)this.m_currentIndex).PageComponent);
                page.activatePage();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ISimpleWizardPage page;
            if (e.getSource() == this.m_cancelButton) {
                this.Finish = false;
                this.dispose();
            }
            if (e.getSource() == this.m_nextButton && this.m_pageList.get((int)this.m_currentIndex).PageComponent instanceof ISimpleWizardPage && !(page = (ISimpleWizardPage)((Object)this.m_pageList.get((int)this.m_currentIndex).PageComponent)).okayToGoToNextPage()) {
                return;
            }
            if ((e.getSource() == this.m_nextButton || e.getSource() == this.m_prevButton) && this.m_pageList.get((int)this.m_currentIndex).PageComponent instanceof ISimpleWizardPage) {
                page = (ISimpleWizardPage)((Object)this.m_pageList.get((int)this.m_currentIndex).PageComponent);
                page.leavingPage();
            }
            if (e.getSource() == this.m_nextButton) {
                if (this.m_currentIndex < this.m_pageList.size() - 1) {
                    ++this.m_currentIndex;
                    this.setButtonState();
                    return;
                }
                this.Finish = true;
                this.dispose();
            }
            if (e.getSource() == this.m_prevButton) {
                if (this.m_currentIndex >= 1) {
                    --this.m_currentIndex;
                    this.setButtonState();
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class Page {
        public JComponent PageComponent;
        public String Title;
        public String Label;

        public Page(JComponent comp, String title, String lbl) {
            this.PageComponent = comp;
            this.Title = title;
            this.Label = lbl;
        }
    }
}

