/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Stack;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Volume.VolumeStackController;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleCdpOverlay;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Signal.ShortWindowFourierAnalysisWidget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class VolumeStack_SingleTraceAnalysisWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener {
    protected VolumeStackController m_stackController;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected Sequence_MainWidget m_workerWidget;
    protected ShortWindowFourierAnalysisWidget m_fftWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_SimpleComposite m_mapWidget = new Java2D_SimpleComposite(true);
    protected JLabel m_coordLabel = new JLabel(" ");
    protected Java2D_UserEventConsumer_ButtonPressed m_clickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_MouseMove m_moveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected JCheckBox m_chkApplyTaper = new JCheckBox("Apply taper");
    protected JTextField m_txtWindow = new JTextField("64");
    protected JTextField m_txtTaper = new JTextField("8");
    protected ComboStringListWrapper m_traceTableCombo;
    protected JButton m_btnReloadTraceTableCombo;
    protected JButton m_btnReloadMap;
    public Java2D_Paintable_EnsembleCdpOverlay EnsembleOverlay = new Java2D_Paintable_EnsembleCdpOverlay();
    public Ensemble InputEnsemble = new Ensemble();
    public Ensemble InputEnsemble_Copy = new Ensemble();
    public Ensemble ProcessedEnsemble = new Ensemble();

    public VolumeStack_SingleTraceAnalysisWidget(VolumeStackController controller) {
        super(1);
        try {
            this.m_stackController = controller;
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.m_moveUEC.addListener(this);
            this.m_clickUEC.addListener(this);
            this.loadUEC();
            this.reloadTraceTableColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            this.m_fftWidget = new ShortWindowFourierAnalysisWidget();
            tabs.addTab("SWFT", this.m_fftWidget);
            return tabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMap() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            int row = 0;
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "SWFT parameters - press ENTER to apply", 0);
            grid.addSimple(row++, new JLabel("Window length (ms)"), this.m_txtWindow);
            grid.addSimple(row++, new JLabel("Taper length (ms)"), this.m_txtTaper);
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyTaper);
            this.m_txtTaper.addActionListener(this);
            this.m_txtWindow.addActionListener(this);
            this.m_chkApplyTaper.addActionListener(this);
            this.m_traceTableCombo = new ComboStringListWrapper();
            this.m_traceTableCombo.listener().addListener(this);
            LinearLayoutWidget sub = main.createHorizontal(0, "Select column color ", 0);
            sub.addComponent(this.m_traceTableCombo, 10);
            sub = main.createHorizontal(0, null, 0);
            this.m_btnReloadTraceTableCombo = sub.createButton("Reload list of columns", this, 10);
            this.m_btnReloadMap = sub.createButton("Reload map plot", this, 10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addComponent(this.m_mapWidget, 10);
            this.m_mapWidget.setColorScaleVisible(true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("VolumeSingleTrace", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createMap(), "Basemap");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadTraceTableColumns() {
        try {
            ArrayList<String> cols = this.m_stackController.traceTable().column_listOfNames();
            this.m_traceTableCombo.setStringArray(cols);
            this.reloadMapPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadUEC() {
        try {
            Java2D_Widget w = this.m_mapWidget.mainWidget();
            w.clearEventConsumerList();
            w.addEventConsumer(this.m_moveUEC);
            w.addEventConsumer(this.m_clickUEC);
            w.addZoomer();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadMapPlot() {
        try {
            Java2D_Widget w = this.m_mapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_stackController.is3D()) {
                w.addPaintable(this.m_stackController.grid(), -9999);
            }
            String col = this.m_traceTableCombo.getSelectedString();
            Java2D_Paintable_Table p = new Java2D_Paintable_Table();
            p.Symbol = Java2D_PointSymbol.FilledOval;
            p.Size_Pixel = 3;
            p.Size_UsePixel = true;
            p.setTable(this.m_stackController.traceTable());
            p.setAxisC(col);
            p.setAxisX("CdpX");
            p.setAxisY("CdpY");
            w.addPaintable(p, -9999);
            this.EnsembleOverlay.m_ensemble = this.ProcessedEnsemble;
            this.EnsembleOverlay.AlwaysDrawDot = true;
            w.addPaintable(this.EnsembleOverlay, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.repaint();
            this.loadUEC();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void reloadEnsemble3D(int inline, int crossline) {
        try {
            this.m_stackController.ensemble_InlineCrossline(this.InputEnsemble, inline, crossline, true);
            this.processEnsemble(true);
            this.reloadMapPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadEnsemble2D(int cdp) {
        try {
            this.m_stackController.ensemble_CDP(this.InputEnsemble, cdp, true);
            this.processEnsemble(true);
            this.reloadMapPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void processEnsemble(boolean unzoom) {
        try {
            this.InputEnsemble.copyToOtherEnsemble(this.InputEnsemble_Copy);
            this.ProcessedEnsemble = this.m_sequence.work(this.InputEnsemble_Copy);
            this.m_fftWidget.WindowLength = (float)Tools_Widget.extractDouble(this.m_txtWindow, 64.0, 16.0, 2000.0);
            this.m_fftWidget.TaperLength = (float)Tools_Widget.extractDouble(this.m_txtTaper, 8.0, 8.0, 2000.0);
            this.m_fftWidget.ApplyTaper = this.m_chkApplyTaper.isSelected();
            this.m_fftWidget.setEnsemble(this.ProcessedEnsemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_traceTableCombo) {
                this.reloadMapPlot();
                return;
            }
            if (sender == this.m_clickUEC) {
                if (this.m_stackController.is3D()) {
                    int inline = this.m_stackController.grid().getInline(this.m_moveUEC.WorldX, this.m_moveUEC.WorldY);
                    int crossline = this.m_stackController.grid().getCrossline(this.m_moveUEC.WorldX, this.m_moveUEC.WorldY);
                    String s = String.format("Inline: %d  Crossline: %d", inline, crossline);
                    this.reloadEnsemble3D(inline, crossline);
                    this.m_coordLabel.setText(s);
                } else {
                    int cdp = this.m_stackController.getNearestCDP(this.m_moveUEC.WorldX, this.m_moveUEC.WorldY);
                    String s = String.format("CDP: %d", cdp);
                    this.reloadEnsemble2D(cdp);
                    this.m_coordLabel.setText(s);
                }
            }
            if (sender == this.m_moveUEC) {
                // empty if block
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    this.processEnsemble(false);
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkApplyTaper || e.getSource() == this.m_txtWindow || e.getSource() == this.m_txtTaper) {
                this.processEnsemble(true);
                return;
            }
            if (e.getSource() == this.m_btnReloadTraceTableCombo) {
                this.reloadTraceTableColumns();
                return;
            }
            if (e.getSource() == this.m_btnReloadMap) {
                this.reloadMapPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

