/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume.Stack;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Stack.VolumeStackManager;
import com.PecosLibrary.Volume.VolumeProject;
import com.PecosLibrary.Well.Tools_WellTop;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class VolumeStackHorizonWidget
extends JSplitPane
implements Messenger.Listener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    protected Java2D_SimpleComposite m_widget;
    protected LinearLayoutWidget m_leftWidget;
    protected ComboStringListWrapper m_whichPlotCombo = new ComboStringListWrapper();
    protected String m_plot_Hor1 = "Horizon of the first stack";
    protected String m_plot_Diff = "First stack horizon minus second stack horizon";
    protected String m_plot_WellTop = "Zero-mean well top surface";
    protected String m_plot_DiffWT = "First stack horizon minus well top surface";
    protected ArrayList<String> m_plotList = new ArrayList();
    protected GridLayoutWidget m_stack1Widget;
    protected ComboStringListWrapper m_stack1Combo = new ComboStringListWrapper();
    protected JComboBox<String> m_hor1Combo = new JComboBox();
    protected GridLayoutWidget m_stack2Widget;
    protected ComboStringListWrapper m_stack2Combo = new ComboStringListWrapper();
    protected JComboBox<String> m_hor2Combo = new JComboBox();
    protected JButton m_reloadPlotButton;
    protected JButton m_reloadStacksButton;
    protected boolean m_stacksOkay = false;
    protected GridLayoutWidget m_exportGridWidget;
    protected JTextField m_exportGridText = new JTextField("Grid");
    protected JButton m_exportGridButton = new JButton("Export");
    protected GridLayoutWidget m_residualActionWidget;
    protected JTextField m_residualColumnText = new JTextField("Statics_Residual");
    protected JCheckBox m_residualAddCheck = new JCheckBox("Add existing statics field");
    protected ComboStringListWrapper m_residualExistingCombo = new ComboStringListWrapper();
    protected JButton m_residualLaunchButton = new JButton("Launch computation");
    protected GridLayoutWidget m_wellTopWidget;
    protected ComboStringListWrapper m_wellTopTableCombo = new ComboStringListWrapper();
    protected JButton m_reloadWellTopTableButton = new JButton("Reload tables");
    protected ComboStringListWrapper m_xWellTopCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_yWellTopCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_cWellTopCombo = new ComboStringListWrapper();
    protected JTextField m_wellTopVelText = new JTextField("10000");
    protected Grid3D m_grid;

    public VolumeStackHorizonWidget() {
        super(1);
        try {
            this.m_widget = new Java2D_SimpleComposite(false);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.m_widget);
            this.reloadWellTopTables();
            this.reloadStaticsColumns();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            for (int n = 1; n <= 4; ++n) {
                this.m_hor1Combo.addItem(Integer.toString(n));
                this.m_hor2Combo.addItem(Integer.toString(n));
            }
            this.m_hor1Combo.setSelectedIndex(0);
            this.m_hor2Combo.setSelectedIndex(0);
            this.m_leftWidget = LinearLayoutWidget.vert(0, null);
            this.m_reloadStacksButton = this.m_leftWidget.createButton("Reload list of stacks", this, 0);
            this.m_plotList.add(this.m_plot_Hor1);
            this.m_plotList.add(this.m_plot_Diff);
            this.m_plotList.add(this.m_plot_WellTop);
            this.m_plotList.add(this.m_plot_DiffWT);
            this.m_whichPlotCombo.setPreferredSelected(this.m_plot_Hor1);
            this.m_whichPlotCombo.setStringArray(this.m_plotList);
            this.m_whichPlotCombo.listener().addListener(this);
            LinearLayoutWidget subPlot = this.m_leftWidget.createVertical(0, "Select plot", 0);
            subPlot.addComponent(this.m_whichPlotCombo, 0);
            this.m_stack1Widget = this.m_leftWidget.createGridLayoutWidget(0, "First horizon", 0);
            int row = 0;
            this.m_stack1Widget.addSimple(row++, new JLabel("Select stack"), this.m_stack1Combo);
            this.m_stack1Widget.addSimple(row++, new JLabel("Select horizon"), this.m_hor1Combo);
            this.m_stack2Widget = this.m_leftWidget.createGridLayoutWidget(0, "Second horizon", 0);
            row = 0;
            this.m_stack2Widget.addSimple(row++, new JLabel("Select stack"), this.m_stack2Combo);
            this.m_stack2Widget.addSimple(row++, new JLabel("Select horizon"), this.m_hor2Combo);
            this.m_stack2Widget.setVisible(false);
            this.m_wellTopWidget = this.m_leftWidget.createGridLayoutWidget(0, "Well top", 0);
            row = 0;
            this.m_wellTopWidget.addSimple(row++, new JLabel(" "), this.m_reloadWellTopTableButton);
            this.m_wellTopWidget.addSimple(row++, new JLabel("Well top table"), this.m_wellTopTableCombo);
            this.m_wellTopWidget.addSimple(row++, new JLabel("X coordinate"), this.m_xWellTopCombo);
            this.m_wellTopWidget.addSimple(row++, new JLabel("Y coordinate"), this.m_yWellTopCombo);
            this.m_wellTopWidget.addSimple(row++, new JLabel("Surface"), this.m_cWellTopCombo);
            this.m_wellTopWidget.addSimple(row++, new JLabel("Velocity"), this.m_wellTopVelText);
            this.m_reloadWellTopTableButton.addActionListener(this);
            this.m_wellTopWidget.setVisible(false);
            this.m_xWellTopCombo.setPreferredSelected("SURFACEX");
            this.m_yWellTopCombo.setPreferredSelected("SURFACEY");
            this.m_cWellTopCombo.setPreferredSelected("KCTYGRP");
            this.m_reloadPlotButton = this.m_leftWidget.createButton("Reload plot", this, 0);
            this.m_exportGridWidget = this.m_leftWidget.createGridLayoutWidget(0, "Export plot to shot / receiver tables", 0);
            row = 0;
            this.m_exportGridWidget.addSimple(row++, new JLabel("Output name"), this.m_exportGridText);
            this.m_exportGridWidget.addSimple(row++, new JLabel(" "), this.m_exportGridButton);
            this.m_exportGridButton.addActionListener(this);
            this.m_exportGridWidget.setVisible(false);
            this.m_residualActionWidget = this.m_leftWidget.createGridLayoutWidget(0, "Compute residuals using current grid", 0);
            row = 0;
            this.m_residualActionWidget.addSimple(row++, new JLabel("Output name"), this.m_residualColumnText);
            this.m_residualActionWidget.addSimple(row++, new JLabel(" "), this.m_residualAddCheck);
            this.m_residualActionWidget.addSimple(row++, new JLabel("Existing statics field"), this.m_residualExistingCombo);
            this.m_residualActionWidget.addSimple(row++, new JLabel(" "), this.m_residualLaunchButton);
            this.m_residualLaunchButton.addActionListener(this);
            this.m_residualActionWidget.setVisible(false);
            this.m_leftWidget.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this.m_leftWidget, -2, null, true);
            this.reloadStacks();
            return this.m_leftWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadStaticsColumns() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().geometryDatabase();
            ArrayList<String> recColList = database.listOfColumnNames("Receiver");
            ArrayList<String> shotColList = database.listOfColumnNames("Shot");
            database = null;
            System.gc();
            ArrayList<String> intersection = new ArrayList<String>();
            for (String rec : recColList) {
                boolean ok = false;
                for (String shot : shotColList) {
                    if (!rec.equalsIgnoreCase(shot)) continue;
                    ok = true;
                }
                if (!ok || !rec.startsWith("STATICS_")) continue;
                intersection.add(rec);
            }
            Collections.sort(intersection);
            this.m_residualExistingCombo.setStringArray(intersection);
            this.m_residualExistingCombo.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadWellTopTables() {
        try {
            ArrayList<String> table = this.getWellTopDatabase().getTableNames();
            this.m_wellTopTableCombo.setStringArray(table);
            this.reloadWellTopColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadWellTopColumns() {
        try {
            String name = this.m_wellTopTableCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            ArrayList<String> cols = this.getWellTopDatabase().listOfColumnNames(name);
            this.m_xWellTopCombo.setStringArray(cols);
            this.m_yWellTopCombo.setStringArray(cols);
            this.m_cWellTopCombo.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection getWellTopDatabase() {
        return VolumeProject.singleton().getWellTopDatabase();
    }

    protected Grid3D getHorizonGrid(String stack, int h) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
            String path = parentPath + "/" + stack;
            if (!Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Horizon not valid", "Cannot create display", 0);
                return null;
            }
            VolumeStackManager vsm1 = new VolumeStackManager();
            vsm1.setPath(path);
            Grid3D grid = vsm1.getHorizonGrid(h);
            if (grid == null) {
                JOptionPane.showMessageDialog(null, "Horizon not picked", "Cannot create display", 0);
                return null;
            }
            return grid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Grid3D loadWellTop() {
        try {
            String table = this.m_wellTopTableCombo.getSelectedString();
            String colX = this.m_xWellTopCombo.getSelectedString();
            String colY = this.m_yWellTopCombo.getSelectedString();
            String colC = this.m_cWellTopCombo.getSelectedString();
            double v = Tools_Widget.extractDouble(this.m_wellTopVelText, 10000.0, 1000.0, 30000.0);
            return Tools_WellTop.getTimeGrid(table, colX, colY, colC, v);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Grid3D reloadPlot_FirstHorizon() {
        try {
            String stack1 = this.m_stack1Combo.getSelectedString();
            int h1 = this.m_hor1Combo.getSelectedIndex();
            return this.getHorizonGrid(stack1, h1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Grid3D reloadPlot_Diff() {
        try {
            String stack1 = this.m_stack1Combo.getSelectedString();
            String stack2 = this.m_stack2Combo.getSelectedString();
            int h1 = this.m_hor1Combo.getSelectedIndex();
            int h2 = this.m_hor2Combo.getSelectedIndex();
            Grid3D grid1 = this.getHorizonGrid(stack1, h1);
            if (grid1 == null) {
                return null;
            }
            Grid3D grid2 = this.getHorizonGrid(stack2, h2);
            if (grid2 == null) {
                return null;
            }
            float[][] d1 = grid1.data();
            float[][] d2 = grid2.data();
            int len1 = d1.length;
            int len2 = d1[0].length;
            for (int a = 0; a < len1; ++a) {
                for (int b = 0; b < len2; ++b) {
                    d1[a][b] = d1[a][b] - d2[a][b];
                }
            }
            return grid1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Grid3D reloadPlot_WellTop() {
        try {
            return this.loadWellTop();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Grid3D reloadPlot_WellTopDiff() {
        try {
            String stack1 = this.m_stack1Combo.getSelectedString();
            int h1 = this.m_hor1Combo.getSelectedIndex();
            Grid3D grid1 = this.getHorizonGrid(stack1, h1);
            if (grid1 == null) {
                return null;
            }
            Grid3D grid2 = this.loadWellTop();
            if (grid2 == null) {
                return null;
            }
            float[][] d1 = grid1.data();
            float[][] d2 = grid2.data();
            int len1 = d1.length;
            int len2 = d1[0].length;
            double sum = 0.0;
            for (int a = 0; a < len1; ++a) {
                for (int b = 0; b < len2; ++b) {
                    d1[a][b] = d1[a][b] - d2[a][b];
                    sum += (double)d1[a][b];
                }
            }
            double avg = sum / (double)(len1 * len2);
            for (int a = 0; a < len1; ++a) {
                for (int b = 0; b < len2; ++b) {
                    d1[a][b] = d1[a][b] - (float)avg;
                }
            }
            return grid1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadPlot() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearPaintableList();
            this.m_residualActionWidget.setVisible(false);
            this.m_exportGridWidget.setVisible(false);
            if (!this.m_stacksOkay) {
                w.mooz();
                return;
            }
            String plot = this.m_whichPlotCombo.getSelectedString();
            if (plot.equalsIgnoreCase(this.m_plot_Hor1)) {
                this.m_grid = this.reloadPlot_FirstHorizon();
            }
            if (plot.equalsIgnoreCase(this.m_plot_Diff)) {
                this.m_grid = this.reloadPlot_Diff();
            }
            if (plot.equalsIgnoreCase(this.m_plot_WellTop)) {
                this.m_grid = this.reloadPlot_WellTop();
            }
            if (plot.equalsIgnoreCase(this.m_plot_DiffWT)) {
                this.m_grid = this.reloadPlot_WellTopDiff();
                this.m_residualActionWidget.setVisible(this.m_grid != null);
            }
            if (this.m_grid != null) {
                w.addPaintable(this.m_grid, -9999);
            }
            this.m_exportGridWidget.setVisible(this.m_grid != null);
            w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot"), -9999);
            w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.forceImageRepaint();
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadStacks() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
            ArrayList<String> list = Tools_FileSystem.subdirectories(parentPath, false);
            this.m_stacksOkay = list.size() >= 1;
            this.m_stack1Combo.setStringArray(list);
            this.m_stack2Combo.setStringArray(list);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_whichPlotCombo) {
                String plot = this.m_whichPlotCombo.getSelectedString();
                this.m_residualActionWidget.setVisible(false);
                this.m_exportGridWidget.setVisible(false);
                boolean stack1Vis = plot.equalsIgnoreCase(this.m_plot_Diff) || plot.equalsIgnoreCase(this.m_plot_Hor1) || plot.equalsIgnoreCase(this.m_plot_DiffWT);
                this.m_stack1Widget.setVisible(stack1Vis);
                boolean stack2Vis = plot.equalsIgnoreCase(this.m_plot_Diff);
                this.m_stack2Widget.setVisible(stack2Vis);
                boolean wellVis = plot.equalsIgnoreCase(this.m_plot_DiffWT) || plot.equalsIgnoreCase(this.m_plot_WellTop);
                this.m_wellTopWidget.setVisible(wellVis);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportGrid(Table_Abstract table) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String colName = this.m_exportGridText.getText();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_append(colName, DataType.Double);
            for (int row = 0; row < table.row_count(); ++row) {
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                double v = this.m_grid.getNearestValue(x, y);
                table.putDouble(row, indexV, v);
            }
            project.geometryDatabase().writeColumnContentsToDatabase(table, colName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportGrid() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.exportGrid(project.receiverTable());
            this.exportGrid(project.shotTable());
            project.reloadAllData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_exportGridButton) {
                this.exportGrid();
                return;
            }
            if (e.getSource() == this.m_reloadWellTopTableButton) {
                this.reloadWellTopTables();
                return;
            }
            if (e.getSource() == this.m_reloadPlotButton) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadStacksButton) {
                this.reloadStacks();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

