/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Synthetic;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.ParameterManager;
import com.PecosCore.Windows.Parameter.Parameter_Grid;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Synthetic.SyntheticModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class Synthetic2DWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener {
    protected ParameterManager m_pm;
    protected String m_paramNameInit = "Initial";
    protected JButton m_btnInitial;
    protected ParameterManager m_pmLayer;
    protected String m_paramNameLayer = "Layer";
    protected JButton m_btnLayer;
    protected ParameterManager m_pmSmooth;
    protected String m_paramNameSmooth = "Smooth";
    protected JButton m_btnSmoothAll;
    protected JButton m_btnSmoothInsidePolygon;
    protected JButton m_btnClearPolygon;
    protected JButton m_btnSetVelInsidePolygon;
    protected JButton m_btnOpen;
    protected JButton m_btnSave;
    protected ParameterManager m_pmShoot;
    protected String m_paramNameShoot = "Shoot";
    protected JButton m_btnShoot;
    protected Java2D_SimpleComposite m_widget;
    protected SyntheticModel m_model = new SyntheticModel();
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEC;
    protected Java2D_Polygon m_polygon;

    public Synthetic2DWidget() {
        super(1);
        try {
            JTabbedPane tabs = new JTabbedPane();
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = left.createVertical(0, "Initial model", 0);
            this.m_pm = new ParameterManager(null);
            Parameter_Grid grid = this.m_pm.create_Parameter_Grid(this.m_paramNameInit, "Default");
            grid.addRow("Width", "Total width(m)", "10000");
            grid.addRow("Height", "Total height(m)", "4000");
            grid.addRow("v0", "Top velocity", "1500");
            grid.addRow("v1", "Bottom velocity", "6000");
            sub.addComponent(this.m_pm.editor(), 0);
            this.m_btnInitial = sub.createButton("Create initial model", this, 0);
            sub = left.createVertical(0, "Define rectangular layer", 0);
            this.m_pmLayer = new ParameterManager(null);
            grid = this.m_pmLayer.create_Parameter_Grid(this.m_paramNameLayer, "Default");
            grid.addRow("Top", "Top", "50");
            grid.addRow("Bottom", "Bottom", "100");
            grid.addRow("Left", "West", "0");
            grid.addRow("Right", "East", "10000");
            grid.addRow("Velocity", "Velocity", "2000");
            sub.addComponent(this.m_pmLayer.editor(), 0);
            this.m_btnLayer = sub.createButton("Set layer", this, 0);
            sub = left.createVertical(0, "Smooth model", 0);
            this.m_pmSmooth = new ParameterManager(null);
            grid = this.m_pmSmooth.create_Parameter_Grid(this.m_paramNameSmooth, "Default");
            grid.addRow("Radius", "Smooth radius(m)", "10");
            sub.addComponent(this.m_pmSmooth.editor(), 0);
            this.m_btnSmoothAll = sub.createButton("Smooth the entire model", this, 0);
            this.m_btnSmoothInsidePolygon = sub.createButton("Just smooth inside polygon", this, 0);
            this.m_btnSetVelInsidePolygon = left.createButton("Set velocity inside polygon", this, 0);
            this.m_btnClearPolygon = left.createButton("Clear polygon", this, 0);
            left.addStretch(10);
            this.m_btnOpen = left.createButton("Open model", this, 0);
            this.m_btnSave = left.createButton("Save model", this, 0);
            left.addStretch(10);
            tabs.addTab("Model", left);
            LinearLayoutWidget shoot = LinearLayoutWidget.vert(0, null);
            sub = shoot.createVertical(0, "Shooting options", 0);
            this.m_pmShoot = new ParameterManager(null);
            grid = this.m_pmShoot.create_Parameter_Grid(this.m_paramNameShoot, "Default");
            grid.addRow("Offset", "Maximum offset(m)", "3000");
            grid.addRow("Time", "Time (ms)", "2000");
            sub.addComponent(this.m_pmShoot.editor(), 0);
            this.m_btnShoot = sub.createButton("Create model", this, 0);
            shoot.addStretch(10);
            tabs.addTab("Shoot", shoot);
            this.setLeftComponent(tabs);
            this.m_widget = new Java2D_SimpleComposite(false);
            this.setRightComponent(this.m_widget);
            this.m_polygonUEC = new Java2D_UserEventConsumer_MultiLineSegments();
            this.m_polygonUEC.addListener(this);
            this.m_polygonUEC.DefiningPolygon = true;
            this.reloadPlot();
            this.reloadMouse();
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_polygonUEC) {
                if (this.m_polygonUEC.Dragging) {
                    return;
                }
                if (!this.m_polygonUEC.Finished) {
                    return;
                }
                int num = this.m_polygonUEC.numPoints();
                if (this.m_polygonUEC.numPoints() < 3) {
                    return;
                }
                this.m_polygon = new Java2D_Polygon();
                this.m_polygon.X = new double[num];
                this.m_polygon.Y = new double[num];
                this.m_polygon.FillColor = new Color(100, 100, 100, 100);
                for (int n = 0; n < num; ++n) {
                    this.m_polygon.X[n] = this.m_polygonUEC.getX(n);
                    this.m_polygon.Y[n] = this.m_polygonUEC.getY(n);
                }
                this.reloadPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMouse() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_polygonUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearPaintableList();
            w.addPaintable(this.m_model, -9999);
            if (this.m_polygon != null) {
                w.addPaintable(this.m_polygon, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String fileName;
            if (e.getSource() == this.m_btnOpen) {
                fileName = Tools_Chooser.getFileName();
                if (fileName == null) {
                    return;
                }
                this.m_model.read(fileName);
                this.reloadPlot();
            }
            if (e.getSource() == this.m_btnSave) {
                fileName = Tools_Chooser.getSaveFileName("2dmodel");
                if (fileName == null) {
                    return;
                }
                this.m_model.save(fileName);
                this.reloadPlot();
            }
            if (e.getSource() == this.m_btnSmoothInsidePolygon) {
                if (this.m_polygon == null) {
                    return;
                }
                double rad = this.m_pmSmooth.getGridDouble(this.m_paramNameSmooth, "Radius", 0.0, 0.0, 50.0);
                this.m_model.smoothInsidePolygon(this.m_polygon, rad);
                this.reloadPlot();
            }
            if (e.getSource() == this.m_btnSmoothAll) {
                double rad = this.m_pmSmooth.getGridDouble(this.m_paramNameSmooth, "Radius", 0.0, 0.0, 50.0);
                this.m_model.smooth(rad);
                this.reloadPlot();
            }
            if (e.getSource() == this.m_btnShoot) {
                double off = this.m_pmShoot.getGridDouble(this.m_paramNameShoot, "Offset", 2000.0, 500.0, 5000.0);
                double time = this.m_pmShoot.getGridDouble(this.m_paramNameShoot, "Time", 2000.0, 500.0, 5000.0);
                String segyFileName = "/Users/matt/Data/Model2D/test.sgy";
                int maxShots = 1111;
                this.m_model.shoot(segyFileName, off, 0.001 * time, 25.0, 50.0, maxShots);
                this.reloadPlot();
            }
            if (e.getSource() == this.m_btnSetVelInsidePolygon) {
                if (this.m_polygon == null) {
                    return;
                }
                String newVel = JOptionPane.showInputDialog(null, "Velocity inside the polygon", "Velocity", -1);
                if (newVel == null) {
                    return;
                }
                double v = Tools_Widget.extractDouble(newVel, 2000.0, 1000.0, 6000.0);
                this.m_model.setPolygon(this.m_polygon, v);
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_btnClearPolygon) {
                this.m_polygon = null;
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_btnLayer) {
                double t = this.m_pmLayer.getGridDouble(this.m_paramNameLayer, "Top", 0.0, 0.0, 20000.0);
                double b = this.m_pmLayer.getGridDouble(this.m_paramNameLayer, "Bottom", t + 10.0, t + 5.0, t + 100000.0);
                double west = this.m_pmLayer.getGridDouble(this.m_paramNameLayer, "Left", 0.0, 0.0, 6000.0);
                double east = this.m_pmLayer.getGridDouble(this.m_paramNameLayer, "Right", west + 10.0, west + 10.0, 226000.0);
                double v = this.m_pmLayer.getGridDouble(this.m_paramNameLayer, "Velocity", 2000.0, 1000.0, 6000.0);
                this.m_model.setRectangle(t, b, west, east, v);
                this.reloadPlot();
            }
            if (e.getSource() == this.m_btnInitial) {
                double w = this.m_pm.getGridDouble(this.m_paramNameInit, "Width", 5000.0, 1000.0, 20000.0);
                double h = this.m_pm.getGridDouble(this.m_paramNameInit, "Height", 3000.0, 600.0, 20000.0);
                double v0 = this.m_pm.getGridDouble(this.m_paramNameInit, "v0", 1500.0, 1000.0, 5000.0);
                double v1 = this.m_pm.getGridDouble(this.m_paramNameInit, "v1", 5000.0, 1000.0, 5000.0);
                this.m_model.createModel(w, h, v0, v1);
                this.reloadPlot();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

