/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyLinearMoveout;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_TimeGrid;
import com.PecosLibrary.Windows.Stack.ProfileSelectorWidget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StackProfileManagerWidget
extends JSplitPane
implements ItemListener,
GenericObjectListener.Listener,
Messenger.Listener,
ActionListener,
ChangeListener {
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
    protected ProfileSelectorWidget m_profileWidget;
    protected Java2D_SimpleComposite m_velProfileWidget = new Java2D_SimpleComposite(true);
    protected JButton m_reloadVelButton;
    protected Java2D_VertStackedEnsembleDisplayWidget m_ensembleWidget = new Java2D_VertStackedEnsembleDisplayWidget(1);
    protected Java2D_AxisLocker m_axisLockTime = new Java2D_AxisLocker("Time axis", "Lock time axis");
    protected Java2D_AxisLocker m_axisLockOffset = new Java2D_AxisLocker("Offset axis", "Lock offset axis");
    protected JSlider m_slider = new JSlider();
    protected boolean m_ignoreSlider = true;
    protected JTextField m_binText = new JTextField("0");
    protected Ensemble m_ensemble = new Ensemble();
    protected StackGizmo m_stackGizmo = new StackGizmo();
    protected EnsembleWorker_ApplyLinearMoveout m_lmo = new EnsembleWorker_ApplyLinearMoveout();
    protected Java2D_EnsembleDisplayOptionsWidget m_optionsWidget;
    protected VelocityManager m_velManager;
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public SeismicProfile selectedProfile() {
        try {
            return this.m_profileWidget.selectedProfile();
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    public StackProfileManagerWidget() {
        super(1);
        try {
            this.m_velManager = RefractionStaticsProject.singleton().getVelocityManager();
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.reloadPlot();
            this.loadUEC();
            Messenger.singleton().addListener(this);
            this.handleProfileChanged();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createEnsemble() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget top = main.createHorizontal(0, null, 0);
            top.addComponent(this.m_lmo.editorWidget(true), 0);
            this.m_lmo.addListener(this);
            top.addComponent(this.m_axisLockOffset, 0);
            top.addComponent(this.m_axisLockTime, 0);
            this.m_axisLockOffset.listener().addListener(this);
            this.m_axisLockTime.listener().addListener(this);
            top.addComponent(this.m_wiggleOptionsWidget, 0);
            this.m_wiggleOptionsWidget.listener().addListener(this);
            top.addStretch(10);
            this.m_binText.setPreferredSize(new Dimension(50, 24));
            this.m_binText.setMinimumSize(new Dimension(50, 24));
            LinearLayoutWidget sliderwidget = main.createHorizontal(0, null, 0);
            sliderwidget.addComponent(this.m_binText, 0);
            sliderwidget.addComponent(this.m_slider, 10);
            this.m_slider.addChangeListener(this);
            this.m_binText.addActionListener(this);
            main.addComponent(this.m_ensembleWidget, 10);
            this.m_ensembleWidget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            this.m_ensembleWidget.addZoomer();
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createVelProfile() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createHorizontal(0, null, 0);
            this.m_reloadVelButton = sub.createButton("Reload velocity profile", this, 0);
            sub.addStretch(10);
            main.addComponent(this.m_velProfileWidget, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Profile ensemble", this.createEnsemble());
            tabs.addTab("Velocity along profile", this.createVelProfile());
            return tabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeftProfiles() {
        try {
            this.m_profileWidget = new ProfileSelectorWidget(false, this, 0);
            return this.m_profileWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String sequenceFileName = p.guiOptionsPath() + "/Stack_Pro.SequenceXML";
            return this.createLeftProfiles();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.m_slider) {
                if (this.m_ignoreSlider) {
                    return;
                }
                this.m_binText.setText(Integer.toString(this.m_slider.getValue()));
                this.loadEnsemble();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createProfileUsingCDP() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (!p.traceTableWrapper().traceTable().column_exists("CDP")) {
                JOptionPane.showMessageDialog(null, "CDP information not imported", "Cannot create slice", 0);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadVelButton) {
                this.reloadVelProfile();
                return;
            }
            if (e.getSource() == this.m_binText) {
                this.loadEnsemble();
                return;
            }
            this.loadUEC();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadEnsemble() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_profileWidget.selectedProfile();
            String velName = "Default";
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection();
            if (sp == null) {
                return;
            }
            sp.setVelocityLocationCollection(velField);
            int index = Tools_Widget.extractInteger(this.m_binText, 0, 0, sp.binCount() - 1);
            if (index < 0 || index >= sp.binCount()) {
                return;
            }
            this.m_ignoreSlider = true;
            this.m_slider.setValue(index);
            this.m_ignoreSlider = false;
            this.m_ensemble.clearDictionary();
            this.m_ensemble.clearTraces(true);
            sp.populateSeismicProfileEnsemble(index, this.m_ensemble);
            System.out.println("m_ensemble count = " + Integer.toString(this.m_ensemble.traceCount()));
            p.prepGeometryHeaders(this.m_ensemble, false, false);
            p.inputDataProcessor_Run(this.m_ensemble);
            this.m_lmo.performWork(this.m_ensemble);
            this.m_ensembleWidget.setEnsemble(0, this.m_ensemble);
            this.m_ensembleWidget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_ensembleWidget.setAxisTableColumn("Trace", "Offset");
            this.m_ensembleWidget.clearAndLoadWigglePaintables();
            this.m_ensembleWidget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadProfiles() {
    }

    public void getSelectedProfile() {
    }

    public void handleProfileChanged() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_profileWidget.selectedProfile();
            String velName = "Default";
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection();
            if (sp != null && velField != null) {
                sp.setVelocityLocationCollection(velField);
            }
            this.reloadVelProfile();
            this.m_slider.setEnabled(sp != null);
            this.m_binText.setEnabled(sp != null);
            if (sp != null) {
                this.m_slider.setMaximum(sp.binCount() - 1);
                this.m_slider.setValue(0);
            }
            this.loadEnsemble();
            this.m_listener.broadcast(this, sp);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected void handleClick() {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_profileWidget) {
                this.handleProfileChanged();
                return;
            }
            if (sender == this.m_lmo) {
                this.loadEnsemble();
                return;
            }
            if (sender == this.m_axisLockOffset) {
                this.m_ensembleWidget.setAxisLocked_X(this.m_axisLockOffset.locked(), this.m_axisLockOffset.min(), this.m_axisLockOffset.max());
                return;
            }
            if (sender == this.m_axisLockTime) {
                this.m_ensembleWidget.setAxisLocked_Time(this.m_axisLockTime.locked(), this.m_axisLockTime.min(), this.m_axisLockTime.max());
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.loadUEC();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadUEC() {
    }

    protected void reloadVelProfile() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_profileWidget.selectedProfile();
            VelocityLocationCollection velField = this.m_velManager.getVelocityLocationCollection();
            if (sp != null && velField != null) {
                sp.setVelocityLocationCollection(velField);
            }
            this.m_velProfileWidget.setHorizontalTitle("Profile bin number");
            Java2D_Widget w = this.m_velProfileWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (sp != null) {
                Java2D_Paintable_TimeGrid grid = sp.getVelocityProfile();
                w.addPaintable(grid, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w.mooz();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadPlot() {
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

