/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AGC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Tools.Tools_FontLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_BufferedImageWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableObjectData;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Color;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class SlidingStackComparisonWidget
extends JSplitPane
implements Messenger.Listener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    public static final int LeftPlot = 0;
    public static final int RightPlot = 1;
    protected ImageWidget m_imageWidget;
    protected JButton m_btnReloadListOfStacks;
    protected ComboStringListWrapper m_leftStackCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_rightStackCombo = new ComboStringListWrapper();
    protected JLabel m_profileLabel = new JLabel("NOT SELECTED", 0);
    protected Java2D_AxisLocker m_axisLockerTime;
    protected JCheckBox m_chkApplyAGC;
    protected JTextField m_txtAgcLen;
    protected JCheckBox m_chkGreyscale;
    protected EnsembleWorker_AGC m_agcWorker = new EnsembleWorker_AGC();
    protected JRadioButton m_radToggle = new JRadioButton("Toggle between left and right");
    protected JRadioButton m_radSideBySide = new JRadioButton("Display stacks side-by-side");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JButton m_btnToggle = new JButton("Showing left (click to show right)");
    protected SeismicProfile m_selectedProfile = null;

    public SeismicProfile selectedProfile() {
        return this.m_selectedProfile;
    }

    public void setSeismicProfile(SeismicProfile sp) {
        try {
            this.m_selectedProfile = sp;
            this.reloadProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public SlidingStackComparisonWidget() {
        super(1);
        try {
            this.m_imageWidget = new ImageWidget();
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.m_imageWidget);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createVertical(0, "Selected profile", 0);
            this.m_profileLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            sub.addComponent(this.m_profileLabel, 10);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Stack selection", 0);
            int row = 0;
            this.m_btnReloadListOfStacks = new JButton("Reload list of stacks");
            this.m_btnReloadListOfStacks.addActionListener(this);
            grid.addComponent(this.m_btnReloadListOfStacks, row, 1, 0.0, 10.0);
            grid.addComponent(new JLabel("Left"), ++row, 0, 0.0, 0.0);
            grid.addComponent(this.m_leftStackCombo, row, 1, 0.0, 10.0);
            grid.addComponent(new JLabel("Right"), ++row, 0, 0.0, 0.0);
            grid.addComponent(this.m_rightStackCombo, row, 1, 0.0, 10.0);
            ++row;
            this.m_leftStackCombo.listener().addListener(this);
            this.m_rightStackCombo.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(250.0, 600.0);
            main.addComponent(this.m_axisLockerTime, 0);
            this.m_chkApplyAGC = new JCheckBox("Apply AGC");
            this.m_chkApplyAGC.addActionListener(this);
            this.m_txtAgcLen = new JTextField("80");
            this.m_txtAgcLen.addActionListener(this);
            sub = main.createHorizontal(3, "Apply AGC to stack", 0);
            sub.addComponent(this.m_chkApplyAGC, 0);
            sub.addComponent(new JLabel("Window (ms)"), 0);
            sub.addComponent(this.m_txtAgcLen, 10);
            sub = main.createVertical(0, "Display method", 0);
            sub.addComponent(this.m_radToggle, 0);
            sub.addComponent(this.m_btnToggle, 0);
            sub.createGapLabel(12);
            sub.addComponent(this.m_radSideBySide, 0);
            this.m_radToggle.addActionListener(this);
            this.m_btnToggle.addActionListener(this);
            this.m_radSideBySide.addActionListener(this);
            this.m_radToggle.setSelected(true);
            this.m_group.add(this.m_radToggle);
            this.m_group.add(this.m_radSideBySide);
            this.m_chkGreyscale = new JCheckBox("Use greyscale");
            sub = main.createHorizontal(0, "Greyscale", 0);
            sub.addComponent(this.m_chkGreyscale, 0);
            this.m_chkGreyscale.addActionListener(this);
            Messenger.singleton().addListener(this);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public Ensemble loadEnsemble(String stack) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                return null;
            }
            Ensemble ensemble = sp.getStack(stack);
            if (ensemble != null) {
                if (this.m_chkApplyAGC.isSelected()) {
                    double window = Tools_Widget.extractDouble(this.m_txtAgcLen, 40.0, 20.0, 1000.0);
                    this.m_agcWorker.setWindow(window);
                    this.m_agcWorker.performWork(ensemble);
                    ensemble = this.m_agcWorker.output(0);
                    this.m_agcWorker.performWork(ensemble);
                    ensemble = this.m_agcWorker.output(0);
                }
                if (this.m_chkGreyscale.isSelected()) {
                    for (Element e : this.m_imageWidget.DataList) {
                        e.Wiggles.UseGrayScale = true;
                    }
                } else {
                    for (Element e : this.m_imageWidget.DataList) {
                        e.Wiggles.UseGrayScale = false;
                    }
                }
            }
            return ensemble;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadPlotData() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                this.m_imageWidget.clearAll();
                return;
            }
            String leftName = this.m_leftStackCombo.getSelectedString();
            this.m_imageWidget.setData(0, leftName, this.loadEnsemble(leftName));
            String rightName = this.m_rightStackCombo.getSelectedString();
            this.m_imageWidget.setData(1, rightName, this.loadEnsemble(rightName));
            this.m_imageWidget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadListOfStacks() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                this.m_leftStackCombo.setStringArray(new ArrayList<String>());
                this.m_rightStackCombo.setStringArray(new ArrayList<String>());
                return;
            }
            ArrayList<String> stacks = sp.stackNames();
            this.m_leftStackCombo.setStringArray(stacks);
            this.m_rightStackCombo.setStringArray(stacks);
            this.reloadPlotData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadProfile() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = this.m_selectedProfile;
            if (sp == null) {
                this.m_profileLabel.setForeground(Color.red);
                this.m_profileLabel.setText("No profile selected");
                return;
            }
            this.m_profileLabel.setForeground(Color.blue);
            this.m_profileLabel.setText(sp.name());
            this.reloadListOfStacks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnReloadListOfStacks) {
                this.reloadListOfStacks();
                return;
            }
            if (this.m_radToggle == e.getSource()) {
                this.m_btnToggle.setEnabled(true);
                this.m_imageWidget.PlotMethod = ImagePlotMethod.Toggle;
                this.m_imageWidget.repaint();
                return;
            }
            if (this.m_radSideBySide == e.getSource()) {
                this.m_btnToggle.setEnabled(false);
                this.m_imageWidget.PlotMethod = ImagePlotMethod.SideBySide;
                this.m_imageWidget.repaint();
                return;
            }
            if (this.m_btnToggle == e.getSource()) {
                if (this.m_imageWidget.TogglePlotIndex == 0) {
                    this.m_imageWidget.TogglePlotIndex = 1;
                    this.m_btnToggle.setText("Showing right (click to show left)");
                } else {
                    this.m_imageWidget.TogglePlotIndex = 0;
                    this.m_btnToggle.setText("Showing left (click to show right)");
                }
                this.m_imageWidget.repaint();
                return;
            }
            this.reloadPlotData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_axisLockerTime) {
                this.m_imageWidget.Transform.setAxisLockedY(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                this.m_imageWidget.repaint();
                return;
            }
            this.reloadPlotData();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.reloadPlotData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    protected class ImageWidget
    extends JPanel
    implements ComponentListener,
    MouseMotionListener,
    MouseListener {
        public Java2D_ColorArrayWrapper ColorArrayWrapper = new Java2D_ColorArrayWrapper(30);
        public Java2D_Transform Transform = new Java2D_Transform();
        public ArrayList<Element> DataList = new ArrayList();
        public ImagePlotMethod PlotMethod = ImagePlotMethod.Toggle;
        public int TogglePlotIndex = 0;
        public int SplitPixel = 0;

        public ImageWidget() {
            try {
                this.Transform.setTechnique(Java2D_Transform.Technique.Inverted);
                this.DataList.add(new Element(this.ColorArrayWrapper, this.Transform));
                this.DataList.add(new Element(this.ColorArrayWrapper, this.Transform));
                this.addComponentListener(this);
                this.addMouseMotionListener(this);
                this.addMouseListener(this);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            try {
                this.requestFocus();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            try {
                if (this.PlotMethod == ImagePlotMethod.SideBySide) {
                    this.SplitPixel = event.getX();
                    this.repaint();
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void clearAll() {
            try {
                for (Element elem : this.DataList) {
                    elem.Wiggles.setEnsemble(null);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setData(int index, String name, Ensemble ens) {
            try {
                if (name == null) {
                    name = "";
                }
                Element elem = this.DataList.get(index);
                elem.Name = name;
                elem.Wiggles.setEnsemble(ens);
                elem.Image.recomputeAllRanges();
                elem.Image.setRequireDisplay();
                if (elem.Image.rangeX().rangeValid()) {
                    this.Transform.setDesiredWorldX(elem.Image.rangeX().rangeMin(), elem.Image.rangeX().rangeMax());
                    this.Transform.setDesiredWorldY(elem.Image.rangeY().rangeMin(), elem.Image.rangeY().rangeMax());
                }
                this.Transform.setSize(this.getSize().width, this.getSize().height);
                this.Transform.computeTransform();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                this.Transform.computeTransform();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setFont(Tools_FontLibrary.Font20);
                int stringHeight = g2d.getFontMetrics().getHeight();
                if (this.PlotMethod == ImagePlotMethod.Toggle) {
                    Element elem = this.DataList.get(this.TogglePlotIndex);
                    g2d.drawImage((Image)elem.Image.image(), 0, 0, null);
                    int ix = this.Transform.sizeX() / 2 - g2d.getFontMetrics().stringWidth(elem.Name) / 2;
                    g2d.setColor(Color.BLACK);
                    g2d.drawString(elem.Name, ix, 20);
                    return;
                }
                int h = this.getSize().height;
                int w = this.getSize().width;
                int pixel = Math.max(this.SplitPixel, 0);
                pixel = Math.min(this.SplitPixel, w - 1);
                BufferedImage leftImage = this.DataList.get((int)0).Image.image();
                BufferedImage rightImage = this.DataList.get((int)1).Image.image();
                if (pixel > 1) {
                    g2d.drawImage(leftImage, 0, 0, pixel - 1, h - 1, 0, 0, pixel - 1, h - 1, null);
                }
                if (pixel < w - 1) {
                    g2d.drawImage(rightImage, pixel, 0, w - 1, h - 1, pixel, 0, w - 1, h - 1, null);
                }
                g2d.setColor(Color.yellow);
                g2d.drawLine(pixel, 0, pixel, h);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                this.Transform.setSize(this.getSize().width, this.getSize().height);
                this.Transform.computeTransform();
                this.repaint();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    protected class Element {
        public Java2D_BufferedImageWrapper Image;
        public String Name = "";
        public Java2D_Paintable_Ensemble_Color Wiggles = new Java2D_Paintable_Ensemble_Color();
        public Java2D_PaintableObjectData Pod = new Java2D_PaintableObjectData();
        public Java2D_Paintable_AxisLines AxisLines = new Java2D_Paintable_AxisLines();

        public Element(Java2D_ColorArrayWrapper caw, Java2D_Transform t) {
            this.Image = new Java2D_BufferedImageWrapper(t, caw);
            this.Pod.Paintable = this.Wiggles;
            this.Pod.Supplemental = 0;
            this.Image.displayList().add(this.Pod);
            this.AxisLines.DrawLeftText = true;
            this.AxisLines.DrawRightText = true;
            Java2D_PaintableObjectData tp = new Java2D_PaintableObjectData();
            tp.Paintable = this.AxisLines;
            tp.Supplemental = 9999;
            this.Image.displayList().add(tp);
        }
    }

    public static enum ImagePlotMethod {
        Toggle,
        SideBySide;

    }
}

