/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Lines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ParallelLines;
import com.PecosLibrary.Windows.Refraction.Picking.AzimuthSelectorWidget;
import com.PecosLibrary.Windows.Stack.ProfileCreationDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProfileSelectorWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
DocumentListener,
ItemListener,
Messenger.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected ButtonGroup m_group = new ButtonGroup();
    protected JRadioButton m_addSingleProfileButton;
    protected JRadioButton m_selectProfileButton;
    protected JRadioButton m_addMultipleProfileButton;
    protected JButton m_btnReloadProfiles;
    protected JTextField m_txtLineSpacing = new JTextField("5000");
    protected JComboBox<String> m_comboLineCount = new JComboBox();
    protected Java2D_SimpleComposite m_stackWidget = new Java2D_SimpleComposite(false);
    protected Java2D_UserEventConsumer_Line m_lineUEC = new Java2D_UserEventConsumer_Line();
    protected Java2D_UserEventConsumer_ButtonPressed m_clickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_ParallelLines m_parallelUEC = new Java2D_UserEventConsumer_ParallelLines();
    protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected boolean m_multiPanelPicker;
    protected JProgressBar m_progress = new JProgressBar();
    protected JComboBox<String> m_combo_OffsetBin = new JComboBox();
    protected JButton m_btnNextOffsetBin = null;
    protected JButton m_btnPrevOffsetBin = null;
    protected JCheckBox m_chkLoadTwoOffsetBins;
    protected SeismicProfile m_selectedProfile = null;
    protected AzimuthSelectorWidget m_azimuthSelectorWidget;
    protected JComboBox<String> m_comboNumPlots;
    protected JComboBox<String> m_comboNumHeaders;
    protected JComboBox<String> m_comboNumHeaderPlot;
    protected JTabbedPane m_tabs = new JTabbedPane();
    public MultiPanelMessage MultiMessage = MultiPanelMessage.AllProfilesChanged;
    public int MultiPanelIndex = 0;
    protected SelectedProfileData[] m_selectedProfileData;
    protected int m_maxPlots;
    protected boolean m_binningChanged = false;
    protected boolean m_ignoreOffsetCombo = true;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public SeismicProfile selectedProfile() throws Exception {
        if (this.m_multiPanelPicker) {
            throw new Exception("m_multiPanelPicker");
        }
        return this.m_selectedProfile;
    }

    public AzimuthSelectorWidget azimuthSelectorWidget() {
        return this.m_azimuthSelectorWidget;
    }

    public JComboBox<String> comboNumPlots() {
        return this.m_comboNumPlots;
    }

    public JComboBox<String> comboNumHeaders() {
        return this.m_comboNumHeaders;
    }

    public JComboBox<String> comboNumHeaderPlot() {
        return this.m_comboNumHeaderPlot;
    }

    public void setNumberOfProfiles(int num) {
        try {
            this.m_selectedProfileData = new SelectedProfileData[num];
            for (int n = 0; n < this.m_selectedProfileData.length; ++n) {
                this.m_selectedProfileData[n] = new SelectedProfileData();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public SeismicProfile getMultiPanelProfile(int index) {
        try {
            return this.m_selectedProfileData[index].Profile;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void setProfileColor(int index, Color c) {
        try {
            this.m_selectedProfileData[index].ProfileColor = c;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean getMultiPanelLoadTwoOffsetBins() {
        try {
            return this.m_chkLoadTwoOffsetBins.isSelected();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public int getMultiPanelOffsetBinIndex() {
        try {
            return this.m_combo_OffsetBin.getSelectedIndex();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected void createSingleTopCrap() {
        try {
            LinearLayoutWidget sub = this.createVertical(0, "Mouse mode", 0);
            this.m_selectProfileButton = sub.createRadioButton("Select a profile: left-click", this.m_group, this, 0);
            this.m_addSingleProfileButton = sub.createRadioButton("Create one new profile: left-click and drag", this.m_group, this, 0);
            this.m_addMultipleProfileButton = sub.createRadioButton("Create multiple new profiles: left-click and drag", this.m_group, this, 0);
            this.m_selectProfileButton.setSelected(true);
            for (int n = 3; n < 25; n += 2) {
                this.m_comboLineCount.addItem(String.format("%d", n));
            }
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Multiple new profiles options", 0);
            grid.addSimple(0, new JLabel("Number of profiles"), this.m_comboLineCount);
            grid.addSimple(1, new JLabel("Profile spacing (ft/m)"), this.m_txtLineSpacing);
            this.m_comboLineCount.setEnabled(this.m_addMultipleProfileButton.isSelected());
            this.m_txtLineSpacing.setEnabled(this.m_addMultipleProfileButton.isSelected());
            this.m_txtLineSpacing.getDocument().addDocumentListener(this);
            this.m_comboLineCount.addItemListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createMultiTopCrap() {
        try {
            LinearLayoutWidget main = this.createVertical(0, null, 0);
            LinearLayoutWidget sub = main.createVertical(0, "Mouse mode", 0);
            this.m_selectProfileButton = new JRadioButton("");
            this.m_addSingleProfileButton = sub.createRadioButton("Create one new profile: left-click and drag", this.m_group, this, 0);
            this.m_addMultipleProfileButton = sub.createRadioButton("Create multiple new profiles: left-click and drag", this.m_group, this, 0);
            this.m_addSingleProfileButton.setSelected(true);
            for (int n = 3; n < 25; n += 2) {
                this.m_comboLineCount.addItem(String.format("%d", n));
            }
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Multiple new profiles options", 0);
            grid.addSimple(0, new JLabel("Number of profiles"), this.m_comboLineCount);
            grid.addSimple(1, new JLabel("Profile spacing (ft/m)"), this.m_txtLineSpacing);
            this.m_comboLineCount.setEnabled(this.m_addMultipleProfileButton.isSelected());
            this.m_txtLineSpacing.setEnabled(this.m_addMultipleProfileButton.isSelected());
            this.m_txtLineSpacing.getDocument().addDocumentListener(this);
            this.m_comboLineCount.addItemListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createPlotCount() {
        try {
            int n;
            this.m_comboNumPlots = new JComboBox();
            for (n = 1; n <= this.m_maxPlots; ++n) {
                this.m_comboNumPlots.addItem(Integer.toString(n));
            }
            this.m_comboNumPlots.setSelectedIndex(2);
            this.m_comboNumPlots.addItemListener(this);
            this.m_comboNumHeaders = new JComboBox();
            this.m_comboNumHeaders.addItem("None");
            for (n = 1; n < 5; ++n) {
                this.m_comboNumHeaders.addItem(Integer.toString(n));
            }
            this.m_comboNumHeaders.setSelectedIndex(1);
            this.m_comboNumHeaders.addItemListener(this);
            this.m_comboNumHeaderPlot = new JComboBox();
            this.m_comboNumHeaderPlot.addItem("None");
            for (n = 1; n <= 4; ++n) {
                this.m_comboNumHeaderPlot.addItem(String.format("%d", n));
            }
            this.m_comboNumHeaderPlot.setSelectedIndex(1);
            this.m_comboNumHeaderPlot.addItemListener(this);
            GridLayoutWidget headerGrid = new GridLayoutWidget(0, null);
            headerGrid.addSimple(0, new JLabel("Number of plots"), this.m_comboNumPlots);
            headerGrid.addSimple(1, new JLabel("# text headers"), this.m_comboNumHeaders);
            headerGrid.addSimple(2, new JLabel("# plot headers"), this.m_comboNumHeaderPlot);
            return headerGrid;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public ProfileSelectorWidget(boolean multiPanelPicker, GenericObjectListener.Listener listener, int maxPlots) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_maxPlots = maxPlots;
            this.m_multiPanelPicker = multiPanelPicker;
            if (listener != null) {
                this.m_listener.addListener(listener);
            }
            if (!this.m_multiPanelPicker) {
                this.createSingleTopCrap();
            } else {
                this.m_tabs.addTab("Profile creation options", this.createMultiTopCrap());
                this.m_tabs.addTab("Plot count", this.createPlotCount());
                this.m_azimuthSelectorWidget = new AzimuthSelectorWidget();
                this.m_tabs.addTab("Azimuth selection", this.m_azimuthSelectorWidget);
                this.addComponent(this.m_tabs, 0);
            }
            this.m_btnReloadProfiles = this.createButton("Reload list of profiles", this, 0);
            LinearLayoutWidget sub = this.createVertical(0, "Binning progress", 0);
            sub.addComponent(this.m_progress, 10);
            if (this.m_multiPanelPicker) {
                this.m_chkLoadTwoOffsetBins = new JCheckBox("Load two offset bins (allows overlap)");
                sub = this.createHorizontal(0, "Offset bin selection", 0);
                sub.addComponent(this.m_combo_OffsetBin, 5);
                this.m_combo_OffsetBin.addItemListener(this);
                this.m_btnPrevOffsetBin = sub.createButton("<<", this, 0);
                this.m_btnNextOffsetBin = sub.createButton(">>", this, 0);
                sub.addComponent(this.m_chkLoadTwoOffsetBins, 0);
                this.m_chkLoadTwoOffsetBins.addActionListener(this);
                JLabel lbl = new JLabel("Press 1 to select first profile, 2 to select second, etc", 0);
                lbl.setForeground(Color.blue);
                this.addComponent(lbl, 0);
            }
            this.m_stackWidget.setAxesVisible(false, false);
            this.m_stackWidget.setColorScaleVisible(false);
            this.addComponent(this.m_stackWidget, 10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_lineUEC.addListener(this);
            this.m_clickUEC.addListener(this);
            this.m_parallelUEC.addListener(this);
            if (this.m_multiPanelPicker) {
                this.m_keyUEC.addListener(this);
            }
            this.reloadPlot();
            this.loadUEC();
            this.reloadOffsetCombo();
            this.performOffsetBinning();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.OffsetBinSizeChanged) {
                int bin;
                if (this.m_multiPanelPicker) {
                    this.reloadOffsetCombo();
                    this.performOffsetBinning();
                    this.MultiMessage = MultiPanelMessage.AllProfilesChanged;
                    this.listener().broadcast(this, null);
                } else if (this.m_selectedProfile != null && this.m_selectedProfile.needToCreateGathers(bin = RefractionStaticsProject.singleton().offsetBinSize())) {
                    this.m_selectedProfile.createOffsetGathers(bin, this.m_progress);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void performOffsetBinning() {
        try {
            this.m_binningChanged = false;
            if (this.m_selectedProfileData == null) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int maxOffset = 40000;
            if (!p.units_feet()) {
                maxOffset = 15000;
            }
            int bin = RefractionStaticsProject.singleton().offsetBinSize();
            for (int n = 0; n < this.m_selectedProfileData.length; ++n) {
                if (this.m_selectedProfileData[n].Profile == null || !this.m_selectedProfileData[n].Profile.needToCreateGathers(bin)) continue;
                this.m_selectedProfileData[n].Profile.createOffsetGathers(bin, this.m_progress);
                this.m_binningChanged = true;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadOffsetCombo() {
        try {
            this.m_ignoreOffsetCombo = true;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int maxOffset = 40000;
            if (!p.units_feet()) {
                maxOffset = 15000;
            }
            int bin = RefractionStaticsProject.singleton().offsetBinSize();
            this.m_combo_OffsetBin.removeAllItems();
            int num = maxOffset / bin;
            for (int n = 0; n < num; ++n) {
                int min = n * bin;
                int max = min + bin;
                String s = String.format("%d - %d", min, max);
                this.m_combo_OffsetBin.addItem(s);
            }
            this.m_combo_OffsetBin.setSelectedIndex(0);
            this.m_ignoreOffsetCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadPlot() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Widget w = this.m_stackWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            Java2D_Paintable_Table painter = Tools_RefractionStaticsProject.loadGeomPO("Shot");
            painter.FixedColor = Color.LIGHT_GRAY;
            w.addPaintable(painter, -9999);
            painter = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
            painter.FixedColor = Color.LIGHT_GRAY;
            w.addPaintable(painter, -9999);
            w.addPaintable(p.getProfileManager(), -999);
            if (!this.m_multiPanelPicker && this.m_selectedProfile != null) {
                Java2D_Paintable_Lines line = new Java2D_Paintable_Lines();
                line.addLine(this.m_selectedProfile.startX(), this.m_selectedProfile.startY(), this.m_selectedProfile.endX(), this.m_selectedProfile.endY());
                w.addPaintable(line, -999);
            }
            if (this.m_multiPanelPicker && this.m_selectedProfileData != null) {
                for (int n = 0; n < this.m_selectedProfileData.length; ++n) {
                    SeismicProfile profile = this.m_selectedProfileData[n].Profile;
                    if (profile == null) continue;
                    Java2D_Paintable_Lines line = new Java2D_Paintable_Lines();
                    line.addLine(profile.startX(), profile.startY(), profile.endX(), profile.endY());
                    line.LineColor = this.m_selectedProfileData[n].ProfileColor;
                    w.addPaintable(line, -999);
                }
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.loadUEC();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getStateChange() != 1) {
                return;
            }
            if (e.getSource() == this.m_combo_OffsetBin) {
                System.out.println("ProfileSelectorWidget --> m_combo_OffsetBin itemStateChanged");
                if (this.m_ignoreOffsetCombo) {
                    return;
                }
                this.MultiMessage = MultiPanelMessage.AllProfilesChanged;
                this.listener().broadcast(this, null);
                return;
            }
            this.loadUEC();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadUEC() {
        try {
            Java2D_Widget w = this.m_stackWidget.mainWidget();
            w.clearEventConsumerList();
            if (this.m_multiPanelPicker) {
                w.addEventConsumer(this.m_keyUEC);
            }
            if (this.m_addSingleProfileButton.isSelected()) {
                w.addEventConsumer(this.m_lineUEC);
            }
            if (this.m_selectProfileButton.isSelected()) {
                w.addEventConsumer(this.m_clickUEC);
            }
            boolean okay = true;
            try {
                String s = this.m_txtLineSpacing.getText();
                this.m_parallelUEC.LineSpacing = Double.parseDouble(s);
                this.m_parallelUEC.TotalLines = 3 + 2 * this.m_comboLineCount.getSelectedIndex();
                this.m_txtLineSpacing.setForeground(Color.black);
            }
            catch (Exception err) {
                okay = false;
                this.m_txtLineSpacing.setForeground(Color.red);
            }
            if (okay && this.m_addMultipleProfileButton.isSelected()) {
                w.addEventConsumer(this.m_parallelUEC);
            }
            w.addZoomer();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleClick() {
        try {
            if (this.m_multiPanelPicker) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = p.getProfileManager().selectProfile(this.m_clickUEC.WorldX, this.m_clickUEC.WorldY);
            if (sp != this.m_selectedProfile) {
                int bin;
                this.m_selectedProfile = sp;
                if (this.m_selectedProfile != null && this.m_selectedProfile.needToCreateGathers(bin = RefractionStaticsProject.singleton().offsetBinSize())) {
                    this.m_selectedProfile.createOffsetGathers(bin, this.m_progress);
                }
                this.reloadPlot();
                this.m_listener.broadcast(this, sp);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleKeyUEC() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            SeismicProfile sp = p.getProfileManager().selectProfile(this.m_keyUEC.WorldX, this.m_keyUEC.WorldY);
            if (sp == null) {
                return;
            }
            int index = -9999;
            if (this.m_keyUEC.KeyCode >= 49 && this.m_keyUEC.KeyCode <= 57) {
                index = this.m_keyUEC.KeyCode - 49;
            }
            if (index < 0 || index >= this.m_selectedProfileData.length) {
                return;
            }
            for (int n = 0; n < this.m_selectedProfileData.length; ++n) {
                if (this.m_selectedProfileData[n].Profile != sp) continue;
                this.m_selectedProfileData[n].Profile = null;
            }
            this.m_selectedProfileData[index].Profile = sp;
            this.performOffsetBinning();
            this.reloadPlot();
            this.MultiMessage = MultiPanelMessage.AllProfilesChanged;
            this.listener().broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            ProfileCreationDialog dlg;
            if (sender == this.m_keyUEC) {
                this.handleKeyUEC();
                return;
            }
            if (sender == this.m_clickUEC) {
                this.handleClick();
                return;
            }
            if (sender == this.m_parallelUEC) {
                if (this.m_parallelUEC.Dragging) {
                    return;
                }
                if (this.m_parallelUEC.TinyLine) {
                    return;
                }
                dlg = new ProfileCreationDialog(this.m_parallelUEC.StartWorldX, this.m_parallelUEC.StartWorldY, this.m_parallelUEC.EndWorldX, this.m_parallelUEC.EndWorldY, true, this.m_parallelUEC.LineSpacing, this.m_parallelUEC.TotalLines);
                if (!this.m_multiPanelPicker && dlg.NewProfile != null) {
                    this.m_selectedProfile = dlg.NewProfile;
                    this.m_listener.broadcast(this, this.m_selectedProfile);
                }
                this.reloadPlot();
            }
            if (sender == this.m_lineUEC) {
                if (this.m_lineUEC.Dragging) {
                    return;
                }
                if (this.m_lineUEC.TinyLine) {
                    return;
                }
                dlg = new ProfileCreationDialog(this.m_lineUEC.StartWorldX, this.m_lineUEC.StartWorldY, this.m_lineUEC.EndWorldX, this.m_lineUEC.EndWorldY, false, 0.0, 0);
                if (!this.m_multiPanelPicker && dlg.NewProfile != null) {
                    this.m_selectedProfile = dlg.NewProfile;
                    this.m_listener.broadcast(this, this.m_selectedProfile);
                }
                this.reloadPlot();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void priorOffsetBin() {
        try {
            int index;
            if (this.m_multiPanelPicker && (index = this.m_combo_OffsetBin.getSelectedIndex()) >= 1) {
                this.m_combo_OffsetBin.setSelectedIndex(index - 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void nextOffsetBin() {
        try {
            int index;
            if (this.m_multiPanelPicker && (index = this.m_combo_OffsetBin.getSelectedIndex()) < this.m_combo_OffsetBin.getItemCount() - 1) {
                this.m_combo_OffsetBin.setSelectedIndex(index + 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_comboLineCount.setEnabled(this.m_addMultipleProfileButton.isSelected());
            this.m_txtLineSpacing.setEnabled(this.m_addMultipleProfileButton.isSelected());
            if (e.getSource() == this.m_chkLoadTwoOffsetBins) {
                this.MultiMessage = MultiPanelMessage.AllProfilesChanged;
                this.listener().broadcast(this, null);
                return;
            }
            if (e.getSource() == this.m_btnNextOffsetBin) {
                this.nextOffsetBin();
                return;
            }
            if (e.getSource() == this.m_btnPrevOffsetBin) {
                this.priorOffsetBin();
                return;
            }
            if (e.getSource() == this.m_btnReloadProfiles) {
                this.reloadPlot();
                return;
            }
            this.loadUEC();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.loadUEC();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.loadUEC();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.loadUEC();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class SelectedProfileData {
        public SeismicProfile Profile = null;
        public Color ProfileColor = Color.RED;

        protected SelectedProfileData() {
        }
    }

    public static enum MultiPanelMessage {
        ProfileSelected,
        AllProfilesChanged;

    }
}

