/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Signal;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.FFT.FFT_ShortWindowAnalysis;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisImage;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ShortWindowFourierAnalysisWidget
extends JPanel
implements MouseMotionListener,
MouseListener {
    protected Java2D_YAxisImage m_timeAxisImage = new Java2D_YAxisImage();
    protected Java2D_XAxisImage m_frequencyAxisImage = new Java2D_XAxisImage();
    protected BufferedImage m_imageTrace = null;
    protected BufferedImage m_imageMain = null;
    protected BufferedImage m_imageResponse = null;
    protected FFT_ShortWindowAnalysis m_analyzer = new FFT_ShortWindowAnalysis();
    protected Ensemble m_ensemble;
    protected float[] m_inputData = new float[2];
    public float WindowLength = 120.0f;
    public float TaperLength = 16.0f;
    public boolean ApplyTaper = true;
    protected boolean m_valid = false;
    protected Java2D_ColorArrayWrapper m_colorArray;
    protected boolean m_plotOK = false;
    protected int m_numFrequencySamples;
    protected int m_mainLeft;
    protected int m_mainWidth;
    protected int m_mainTop;
    protected int m_mainHeight;
    protected int m_responseHeight;
    protected int m_responseTop;
    protected int m_traceWidth;
    protected int m_axisWidth;
    protected int m_axisHeight;
    protected double m_minTime;
    protected double m_maxTime;
    protected double m_scaleTime;
    protected double m_shiftTime;
    protected double m_minFreq;
    protected double m_maxFreq;
    protected double m_scaleFreq;
    protected double m_shiftFreq;
    protected boolean JustPaintResponse = false;
    protected boolean m_mouseInMain = false;
    protected int m_mouseMainPixelX;
    protected int m_mouseMainPixelY;

    public FFT_ShortWindowAnalysis analyzer() {
        return this.m_analyzer;
    }

    public ShortWindowFourierAnalysisWidget() {
        try {
            this.m_frequencyAxisImage.setTitle("Frequency");
            int num = 100;
            this.m_colorArray = new Java2D_ColorArrayWrapper(num);
            int third = this.m_colorArray.colorCount() / 3;
            this.m_colorArray.setColor(0, Color.black);
            this.m_colorArray.setColor(third, Color.green);
            this.m_colorArray.setColor(2 * third, Color.yellow);
            this.m_colorArray.setColor(num - 1, Color.red);
            this.m_colorArray.interpolateColors(0, third);
            this.m_colorArray.interpolateColors(third, 2 * third);
            this.m_colorArray.interpolateColors(2 * third, num - 1);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void compute() {
        try {
            this.m_valid = false;
            if (this.m_ensemble == null) {
                return;
            }
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            EnsembleTrace trace = this.m_ensemble.trace(0);
            FloatArrayWrapper data = trace.data();
            if (data.length() < 10) {
                return;
            }
            if (this.m_inputData.length != data.length()) {
                this.m_inputData = new float[data.length()];
            }
            data.copyToArray(this.m_inputData);
            this.m_analyzer.insertTraceData(this.m_inputData, data.getFirstSampleCoord_WithShifts(), data.getSampleInterval());
            this.m_analyzer.computeResampledTrace();
            this.m_analyzer.computeAllData(this.WindowLength, this.TaperLength, this.ApplyTaper);
            this.m_valid = true;
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            this.compute();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            this.m_plotOK = false;
            if (!this.m_analyzer.computedValid()) {
                return;
            }
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            this.m_axisWidth = 60;
            this.m_axisHeight = 50;
            this.m_traceWidth = 80;
            this.m_responseHeight = 100;
            this.m_responseTop = this.m_axisHeight;
            this.m_mainLeft = this.m_axisWidth + this.m_traceWidth;
            this.m_mainWidth = size.width - this.m_mainLeft;
            this.m_mainTop = this.m_responseHeight + this.m_axisHeight;
            this.m_mainHeight = size.height - this.m_mainTop;
            if (this.m_mainHeight < 20 || this.m_mainWidth < 20) {
                return;
            }
            float[][] amp = this.m_analyzer.fftAmp();
            float nyquist = 1.0f / (0.002f * this.m_analyzer.inputSampleInterval());
            double frequencyInterval = this.m_analyzer.frequencyIncrement();
            int numFrequencySamples = (int)(0.5 + (double)nyquist / frequencyInterval);
            this.m_minFreq = 0.0 - 0.5 * frequencyInterval;
            this.m_maxFreq = this.m_minFreq + frequencyInterval * (double)numFrequencySamples;
            this.m_scaleFreq = (double)this.m_mainWidth / (this.m_maxFreq - this.m_minFreq);
            this.m_shiftFreq = 0.0 - this.m_minFreq * this.m_scaleFreq;
            double sampleInterval = this.m_analyzer.inputSampleInterval();
            this.m_minTime = 0.0 - 0.5 * sampleInterval;
            this.m_maxTime = this.m_minTime + sampleInterval * (double)this.m_analyzer.inputTrace().length;
            this.m_scaleTime = (double)this.m_mainHeight / (this.m_maxTime - this.m_minTime);
            this.m_shiftTime = 0.0 - this.m_minTime * this.m_scaleTime;
            if (this.m_imageResponse == null) {
                this.m_imageResponse = new BufferedImage(this.m_mainWidth, this.m_responseHeight, 2);
            }
            if (this.m_imageResponse.getWidth() != this.m_mainWidth || this.m_imageResponse.getHeight() != this.m_responseHeight) {
                this.m_imageResponse = new BufferedImage(this.m_mainWidth, this.m_responseHeight, 2);
            }
            Graphics2D g2dResp = this.m_imageResponse.createGraphics();
            g2dResp.setColor(Color.LIGHT_GRAY);
            g2dResp.fillRect(0, 0, this.m_mainWidth, this.m_responseHeight);
            if (this.m_mouseInMain) {
                int f;
                double timeMain = ((double)this.m_mouseMainPixelY - this.m_shiftTime) / this.m_scaleTime;
                int timeIndex = (int)(0.5 + timeMain / sampleInterval);
                timeIndex = Math.max(0, timeIndex);
                timeIndex = Math.min(amp.length - 1, timeIndex);
                double scaleY = (double)this.m_responseHeight / (double)this.m_analyzer.maxAmplitude();
                g2dResp.setColor(Color.DARK_GRAY);
                for (f = 1; f < numFrequencySamples; ++f) {
                    double freq1 = (double)(f - 1) * frequencyInterval;
                    double freq2 = (double)f * frequencyInterval;
                    int x1 = (int)(freq1 * this.m_scaleFreq + this.m_shiftFreq);
                    int y1 = this.m_responseHeight - (int)((double)amp[timeIndex][f - 1] * scaleY);
                    int x2 = (int)(freq2 * this.m_scaleFreq + this.m_shiftFreq);
                    int y2 = this.m_responseHeight - (int)((double)amp[timeIndex][f] * scaleY);
                    g2dResp.drawLine(x1, y1, x2, y2);
                }
                g2dResp.setColor(Color.RED);
                for (f = 0; f < numFrequencySamples; ++f) {
                    double freq = (double)f * frequencyInterval;
                    int x = (int)(freq * this.m_scaleFreq + this.m_shiftFreq);
                    int y = this.m_responseHeight - (int)((double)amp[timeIndex][f] * scaleY);
                    g2dResp.fillOval(x - 2, y - 2, 5, 5);
                }
            }
            g2d.drawImage((Image)this.m_imageResponse, this.m_mainLeft, this.m_responseTop, null);
            BufferedImage image = this.m_frequencyAxisImage.image(this.m_mainWidth, this.m_axisHeight, this.m_minFreq, this.m_maxFreq);
            g2d.drawImage((Image)image, this.m_mainLeft, 0, null);
            image = this.m_timeAxisImage.image(this.m_axisWidth, this.m_mainHeight, this.m_minTime, this.m_maxTime);
            g2d.drawImage((Image)image, 0, this.m_mainTop, null);
            if (this.m_imageMain == null) {
                this.m_imageMain = new BufferedImage(this.m_mainWidth, this.m_mainHeight, 2);
            }
            if (this.m_imageMain.getWidth() != this.m_mainWidth || this.m_imageMain.getHeight() != this.m_mainHeight) {
                this.m_imageMain = new BufferedImage(this.m_mainWidth, this.m_mainHeight, 2);
            }
            float max = Math.max(1.0E-5f, this.m_analyzer.maxAmplitude());
            this.m_colorArray.setColorScaleRange(0.0, max + 1.0E-6f);
            double pixPerTime = (double)this.m_mainHeight / (double)this.m_analyzer.inputTrace().length;
            int pixY = 1 + (int)pixPerTime;
            double pixPerFreq = (double)this.m_mainWidth / (double)numFrequencySamples;
            int pixX = 1 + (int)pixPerFreq;
            Graphics2D g2dMain = this.m_imageMain.createGraphics();
            for (int s = 0; s < amp.length; ++s) {
                int y = (int)((double)s * pixPerTime);
                for (int f = 0; f < numFrequencySamples; ++f) {
                    int x = (int)((double)f * pixPerFreq);
                    Color c = this.m_colorArray.colorUsingValue(amp[s][f]);
                    g2dMain.setColor(c);
                    g2dMain.fillRect(x, y, pixX, pixY);
                }
            }
            g2d.drawImage((Image)this.m_imageMain, this.m_mainLeft, this.m_mainTop, null);
            if (this.m_imageTrace == null) {
                this.m_imageTrace = new BufferedImage(this.m_traceWidth, this.m_mainHeight, 2);
            }
            if (this.m_imageTrace.getWidth() != this.m_traceWidth || this.m_imageTrace.getHeight() != this.m_mainHeight) {
                this.m_imageTrace = new BufferedImage(this.m_traceWidth, this.m_mainHeight, 2);
            }
            float[] input = this.m_analyzer.inputTrace();
            float inputMax = 1.0E-6f;
            for (int n = 0; n < input.length; ++n) {
                inputMax = Math.max(inputMax, Math.abs(input[n]));
            }
            float traceScalar = (float)(0.5 * (double)this.m_traceWidth / (double)inputMax);
            Graphics2D g2dTrace = this.m_imageTrace.createGraphics();
            g2dTrace.setColor(Color.white);
            g2dTrace.fillRect(0, 0, this.m_traceWidth, this.m_mainHeight);
            g2dTrace.setColor(Color.black);
            for (int n = 1; n < input.length; ++n) {
                int y1 = (int)((double)(n - 1) * pixPerTime);
                int y2 = (int)((double)n * pixPerTime);
                int x1 = this.m_traceWidth / 2 + (int)(input[n - 1] * traceScalar);
                int x2 = this.m_traceWidth / 2 + (int)(input[n] * traceScalar);
                g2dTrace.drawLine(x1, y1, x2, y2);
            }
            g2d.drawImage((Image)this.m_imageTrace, this.m_axisWidth, this.m_mainTop, null);
            this.m_plotOK = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            this.m_mouseInMain = false;
            if (!this.m_plotOK) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            if (x >= this.m_mainLeft && y >= this.m_mainTop) {
                this.m_mouseMainPixelX = x - this.m_mainLeft;
                this.m_mouseMainPixelY = y - this.m_mainTop;
                this.m_mouseInMain = true;
                this.repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }
}

