/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shear;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shear.HodorGramWidget;
import com.PecosLibrary.Windows.Shear.ShearRotationData;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShearRotationWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
INumberedWidget,
ItemListener,
ChangeListener {
    protected FileWidget m_fileP;
    protected FileWidget m_fileH1;
    protected FileWidget m_fileH2;
    protected FileWidget m_fileMap;
    protected JTextField m_txtOrientationH1 = new JTextField("90");
    protected JTextField m_txtOrientationH2 = new JTextField("0");
    protected JLabel m_lblP = new JLabel("", 0);
    protected JLabel m_lblH1 = new JLabel("", 0);
    protected JLabel m_lblH2 = new JLabel("", 0);
    protected JLabel m_lblMap = new JLabel("", 0);
    protected JLabel m_lblStatus = new JLabel("", 0);
    protected ShearRotationData m_data = new ShearRotationData();
    protected String m_fileName = "";
    protected ParameterTree m_tree = new ParameterTree();
    protected Sequence_MainWidget m_workerWidget;
    protected JComboBox<String> m_comboNumHeaders;
    protected JComboBox<String> m_comboNumHeaderPlot;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected int m_maxPlots = 6;
    protected int m_numVisible = 4;
    protected JTextField m_firstTraceText = new JTextField("1");
    protected JTextField m_traceCountText = new JTextField("100");
    protected JSlider m_firstTraceSlider = new JSlider();
    protected boolean m_bIgnoreSlider = false;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected HodorGramWidget m_hodorGramWidget_P_H1;
    protected HodorGramWidget m_hodorGramWidget_P_H2;
    protected HodorGramWidget m_hodorGramWidget_H1_H2;
    protected JTextField m_txtOutput = new JTextField("");
    protected JButton m_btnSelectExport = new JButton("Export");
    protected JButton m_btnBeginExport = new JButton("Export");
    protected JProgressBar m_progress = new JProgressBar();
    protected int m_widgetNumber = 1;

    public ShearRotationWidget() {
        super(1);
        try {
            this.m_fileName = RefractionStaticsProject.singleton().projectPath() + "/RotateShear.xml";
            this.m_tree.read(this.m_fileName);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.m_fileP.setText(this.m_tree.string_get("SEGYP", ""));
            this.m_fileH1.setText(this.m_tree.string_get("SEGYH1", ""));
            this.m_fileH2.setText(this.m_tree.string_get("SEGYH2", ""));
            this.m_fileMap.setText(this.m_tree.string_get("SEGYMAP", ""));
            this.m_txtOrientationH1.setText(this.m_tree.string_get("H1ANGLE", "90"));
            this.m_txtOrientationH2.setText(this.m_tree.string_get("H2ANGLE", "0"));
            this.reloadFiles();
            this.m_data.Sequence.addListener(this);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("PH1,PH2 ==> PH rotation", this.createRightViewInput());
            return tabs;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected JComponent createRightViewInput() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget top = main.createHorizontal(0, null, 0);
            top.addComponent(new JLabel("Count"), 0);
            top.addComponent(this.m_traceCountText, 2);
            top.addComponent(new JLabel("First"), 0);
            top.addComponent(this.m_firstTraceText, 2);
            top.addComponent(this.m_firstTraceSlider, 7);
            this.m_firstTraceText.addActionListener(this);
            this.m_traceCountText.addActionListener(this);
            this.m_firstTraceSlider.addChangeListener(this);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(this.m_maxPlots);
            this.m_widget.setVisibleCount(this.m_numVisible);
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            return main;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Files", this.createLeftFile());
            this.m_workerWidget = new Sequence_MainWidget("ShearRotate", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_data.Sequence = this.m_workerWidget.sequence();
            tabs.addTab("Flow", this.m_workerWidget);
            tabs.addTab("Display", this.createLeftOptions());
            tabs.addTab("Hodograms", this.createHodor());
            return tabs;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected JComponent createHodor() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_hodorGramWidget_P_H1 = new HodorGramWidget();
            this.m_hodorGramWidget_P_H2 = new HodorGramWidget();
            this.m_hodorGramWidget_H1_H2 = new HodorGramWidget();
            main.addComponent(this.m_hodorGramWidget_P_H1, 5);
            main.addComponent(this.m_hodorGramWidget_P_H2, 5);
            main.addComponent(this.m_hodorGramWidget_H1_H2, 5);
            return main;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected JComponent createLeftOptions() {
        try {
            int n;
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            main.addComponent(this.m_wiggleOptionsWidget, 0);
            this.m_comboNumHeaders = new JComboBox();
            this.m_comboNumHeaders.addItem("None");
            for (n = 1; n < 5; ++n) {
                this.m_comboNumHeaders.addItem(Integer.toString(n));
            }
            this.m_comboNumHeaders.setSelectedIndex(1);
            this.m_comboNumHeaders.addItemListener(this);
            this.m_comboNumHeaderPlot = new JComboBox();
            this.m_comboNumHeaderPlot.addItem("None");
            for (n = 1; n <= 4; ++n) {
                this.m_comboNumHeaderPlot.addItem(String.format("%d", n));
            }
            this.m_comboNumHeaderPlot.setSelectedIndex(1);
            this.m_comboNumHeaderPlot.addItemListener(this);
            GridLayoutWidget headerGrid = new GridLayoutWidget(0, "Plot headers");
            headerGrid.addSimple(1, new JLabel("# text headers"), this.m_comboNumHeaders);
            headerGrid.addSimple(2, new JLabel("# plot headers"), this.m_comboNumHeaderPlot);
            main.addComponent(headerGrid, 0);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(-70.0, 100.0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(9);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true, true);
            return main;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            int numTextHeaders = this.m_comboNumHeaders.getSelectedIndex();
            int numPlotHeaders = this.m_comboNumHeaderPlot.getSelectedIndex();
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_widget.setHeaderPlotVisibleCount(n, numPlotHeaders);
                this.m_widget.HeaderTextRowCount = numTextHeaders;
            }
            this.m_widget.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createLeftFile() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_fileP = new FileWidget(false, true, 0, "Select P SEGY file", this);
            this.m_fileH1 = new FileWidget(false, true, 0, "Select H1 SEGY file", this);
            this.m_fileH2 = new FileWidget(false, true, 0, "Select H2 SEGY file", this);
            this.m_fileMap = new FileWidget(false, false, 0, "Select SEGY dictionary", this);
            main.addComponent(this.m_fileP, 0);
            main.addComponent(this.m_fileH1, 0);
            main.addComponent(this.m_fileH2, 0);
            main.addComponent(this.m_fileMap, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Status", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("P file:"), this.m_lblP);
            grid.addSimple(row++, new JLabel("H1 file:"), this.m_lblH1);
            grid.addSimple(row++, new JLabel("H2 file:"), this.m_lblH2);
            grid.addSimple(row++, new JLabel("Dictionary file:"), this.m_lblMap);
            main.addComponent(this.m_lblStatus, 0);
            this.m_lblStatus.setBorder(BorderFactory.createRaisedBevelBorder());
            String s = "Geophone orientation - degrees counter-clockwise from easting";
            grid = main.createGridLayoutWidget(0, s, 0);
            row = 0;
            grid.addSimple(row++, new JLabel("H1 orientation"), this.m_txtOrientationH1);
            grid.addSimple(row++, new JLabel("H2 orientation"), this.m_txtOrientationH2);
            this.m_txtOrientationH1.addActionListener(this);
            this.m_txtOrientationH2.addActionListener(this);
            LinearLayoutWidget sub = main.createVertical(0, "P-SV file export", 0);
            LinearLayoutWidget sub1 = sub.createHorizontal(0, null, 0);
            sub1.addComponent(new JLabel("P-SV file name"), 0);
            sub1.addComponent(this.m_txtOutput, 10);
            this.m_btnSelectExport = sub1.createButton("Select...", this, 0);
            this.m_txtOutput.setText("/Users/matt/Data/psv.sgy");
            sub1 = sub.createHorizontal(0, null, 0);
            sub1.addComponent(this.m_progress, 10);
            this.m_btnBeginExport = sub1.createButton("Create", this, 0);
            main.addStretch(9);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true, true);
            return main;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
    }

    protected void reloadFiles() {
        try {
            this.m_lblStatus.setText("");
            this.m_data.EnsemblesP.ProcessedEnsemble.clearTraces(false);
            this.m_data.EnsemblesH1.ProcessedEnsemble.clearTraces(false);
            this.m_data.EnsemblesH2.ProcessedEnsemble.clearTraces(false);
            this.m_widget.setEnsemble(0, this.m_data.EnsemblesP.ProcessedEnsemble);
            this.m_widget.setEnsemble(1, this.m_data.EnsemblesP.ProcessedEnsemble);
            this.m_widget.setEnsemble(2, this.m_data.EnsemblesP.ProcessedEnsemble);
            this.m_data.Valid = false;
            this.m_data.SegyP.setFileName(this.m_fileP.getText(), false);
            this.m_data.SegyH1.setFileName(this.m_fileH1.getText(), false);
            this.m_data.SegyH2.setFileName(this.m_fileH2.getText(), false);
            this.m_data.Dict.setOpenFileName(this.m_fileMap.getText());
            this.m_tree.string_put("SEGYP", this.m_fileP.getText());
            this.m_tree.string_put("SEGYH1", this.m_fileH1.getText());
            this.m_tree.string_put("SEGYH2", this.m_fileH2.getText());
            this.m_tree.string_put("SEGYMAP", this.m_fileMap.getText());
            this.m_tree.save(this.m_fileName);
            if (!this.m_data.SegyH1.isFileOK()) {
                this.m_lblH1.setText("File not valid");
                this.m_lblH1.setForeground(Color.red);
            } else {
                this.m_lblH1.setText(Integer.toString((int)this.m_data.SegyH1.traceCount()) + " traces");
                this.m_lblH1.setForeground(Color.blue);
            }
            if (!this.m_data.SegyH2.isFileOK()) {
                this.m_lblH2.setText("File not valid");
                this.m_lblH2.setForeground(Color.red);
            } else {
                this.m_lblH2.setText(Integer.toString((int)this.m_data.SegyH2.traceCount()) + " traces");
                this.m_lblH2.setForeground(Color.blue);
            }
            if (!this.m_data.SegyP.isFileOK()) {
                this.m_lblP.setText("File not valid");
                this.m_lblP.setForeground(Color.red);
            } else {
                this.m_lblP.setText(Integer.toString((int)this.m_data.SegyP.traceCount()) + " traces");
                this.m_lblP.setForeground(Color.blue);
            }
            boolean bl = this.m_data.Valid = this.m_data.SegyP.isFileOK() && this.m_data.SegyH1.isFileOK() && this.m_data.SegyH2.isFileOK();
            if (!this.m_data.Valid) {
                this.m_lblStatus.setText("Not all SEGY files are valid!");
                this.m_lblStatus.setForeground(Color.red);
                this.enableStuff();
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                return;
            }
            boolean bl2 = this.m_data.Valid = this.m_data.SegyP.traceCount() == this.m_data.SegyH1.traceCount() && this.m_data.SegyP.traceCount() == this.m_data.SegyH2.traceCount();
            if (!this.m_data.Valid) {
                this.m_lblStatus.setText("Trace counts must match!");
                this.m_lblStatus.setForeground(Color.red);
                this.enableStuff();
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                return;
            }
            this.m_lblStatus.setText("Trace files appear to be valid");
            this.m_lblStatus.setForeground(Color.blue);
            this.enableStuff();
            this.m_firstTraceSlider.setValue(1);
            this.m_firstTraceSlider.setMinimum(1);
            this.m_firstTraceSlider.setMaximum((int)this.m_data.SegyH2.traceCount());
            this.m_firstTraceText.setText("1");
            this.loadEnsemble();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void loadEnsemble() {
        try {
            this.m_widget.clearUserEventConsumerList();
            int count = Tools_Widget.extractInteger(this.m_traceCountText, 100, 10, 1000);
            int first = Tools_Widget.extractInteger(this.m_firstTraceText, 1, 1, 100000000);
            double angle1 = Tools_Widget.extractDouble(this.m_txtOrientationH1, 90.0, -360.0, 360.0);
            double angle2 = Tools_Widget.extractDouble(this.m_txtOrientationH2, 90.0, -360.0, 360.0);
            this.m_tree.double_put("ANGLEH1", angle1);
            this.m_tree.double_put("ANGLEH2", angle2);
            this.m_tree.save(this.m_fileName);
            this.m_data.Angle1 = Math.PI * angle1 / 180.0;
            this.m_data.Angle2 = Math.PI * angle2 / 180.0;
            this.m_data.loadEnsembles(this.m_widget, first, count);
            try {
                this.m_hodorGramWidget_P_H1.setTraces(this.m_data.EnsemblesP.ProcessedEnsemble.trace(0), this.m_data.EnsemblesH1.ProcessedEnsemble.trace(0));
                this.m_hodorGramWidget_P_H2.setTraces(this.m_data.EnsemblesP.ProcessedEnsemble.trace(0), this.m_data.EnsemblesH2.ProcessedEnsemble.trace(0));
                this.m_hodorGramWidget_H1_H2.setTraces(this.m_data.EnsemblesH1.ProcessedEnsemble.trace(0), this.m_data.EnsemblesH2.ProcessedEnsemble.trace(0));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.unzoom();
            this.m_widget.addZoomer();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void enableStuff() {
        try {
            this.m_firstTraceSlider.setEnabled(this.m_data.Valid);
            this.m_firstTraceText.setEnabled(this.m_data.Valid);
            this.m_traceCountText.setEnabled(this.m_data.Valid);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.m_firstTraceSlider) {
                if (this.m_bIgnoreSlider) {
                    return;
                }
                int v = this.m_firstTraceSlider.getValue();
                this.m_firstTraceText.setText(Integer.toString(v));
                this.loadEnsemble();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void export() {
        try {
            this.m_data.OutFilename = this.m_txtOutput.getText();
            this.m_data.export(this.m_progress);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String s;
            if (e.getSource() == this.m_btnBeginExport) {
                this.export();
                return;
            }
            if (e.getSource() == this.m_btnSelectExport && (s = Tools_Chooser.getFileName()) != null) {
                this.m_txtOutput.setText(s);
            }
            if (e.getSource() == this.m_firstTraceText) {
                int n = Tools_Widget.extractInteger(this.m_firstTraceText, 1, 1, (int)this.m_data.SegyH2.traceCount() - 2);
                this.m_firstTraceSlider.setValue(n);
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_firstTraceText) {
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_traceCountText) {
                this.loadEnsemble();
                return;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        block8: {
            try {
                boolean fileChanged;
                boolean bl = fileChanged = sender == this.m_fileH1 || sender == this.m_fileH2 || sender == this.m_fileP || sender == this.m_fileMap;
                if (fileChanged) {
                    this.reloadFiles();
                    return;
                }
                if (sender == this.m_data.Sequence) {
                    if (this.m_data.Sequence.MessageData.SequenceModified) {
                        this.loadEnsemble();
                    }
                    return;
                }
                if (sender == this.m_wiggleOptionsWidget) {
                    this.loadEnsemble();
                    return;
                }
                if (sender != this.m_axisLockerTime) break block8;
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                try {
                    this.m_hodorGramWidget_P_H1.setTimes(this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                    this.m_hodorGramWidget_P_H2.setTimes(this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                    this.m_hodorGramWidget_H1_H2.setTimes(this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }
}

