/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TestSplitter
extends JPanel
implements ComponentListener,
KeyListener,
MouseWheelListener,
MouseMotionListener,
MouseListener {
    protected ArrayList<Wrapper> m_list = new ArrayList();
    protected int m_barSize = 5;
    protected int m_numBars = 0;
    protected int m_totalBarPixels = 0;
    protected int m_availablePixels = 0;
    protected int m_minWidthSum = 0;
    protected int m_stretchSum = 0;
    protected int[] m_barPixelLeft = new int[20];
    protected int m_dragBar = -999;
    protected int m_dragX;
    protected int m_dragMinX;
    protected int m_dragMaxX;

    public int count() {
        return this.m_list.size();
    }

    public JComponent removeComponent(int index) {
        try {
            if (index >= 0 && index < this.m_list.size()) {
                Wrapper w = this.m_list.get(index);
                this.remove(w.m_component);
                this.m_list.remove(w);
                return w.m_component;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public JComponent removeComponent(JComponent c) {
        try {
            for (Wrapper w : this.m_list) {
                if (w.m_component != c) continue;
                this.remove(c);
                this.m_list.remove(w);
                return c;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void appendComponent(JComponent c, int stretch, int minWidth) {
        try {
            if (c == null) {
                return;
            }
            this.m_list.add(new Wrapper(c, stretch, minWidth));
            this.add(c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TestSplitter() {
        try {
            this.setLayout(null);
            this.addComponentListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
            for (int n = 0; n < 2; ++n) {
                String root = Integer.toString(n);
                JTabbedPane tabs = new JTabbedPane();
                tabs.addTab(root + " Test 1", new JPanel());
                tabs.addTab(root + " Test 2", new JPanel());
                this.appendComponent(tabs, 1 + n % 2, 200);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            if (this.m_dragBar >= 0) {
                int x = Math.max(this.m_dragX, this.m_dragMinX);
                this.m_dragX = x = Math.min(x, this.m_dragMaxX);
                g2d.setColor(Color.blue);
                g2d.drawLine(x, 0, x, size.height);
                g2d.setColor(Color.red);
                g2d.drawLine(this.m_dragMaxX, 0, this.m_dragMaxX, size.height);
                g2d.drawLine(this.m_dragMinX, 0, this.m_dragMinX, size.height);
            }
            g2d.setColor(Color.GRAY);
            for (int n = 0; n < this.m_numBars; ++n) {
                int left = this.m_barPixelLeft[n];
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.fillRect(left, 0, this.m_barSize, size.height);
                g2d.setColor(Color.GRAY);
                g2d.drawLine(left, 0, left, size.height);
                g2d.drawLine(left + this.m_barSize - 1, 0, left + this.m_barSize - 1, size.height);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void manualWidgetLayout() {
        try {
            this.m_numBars = 0;
            Dimension size = this.getSize();
            if (this.m_list.size() < 1) {
                return;
            }
            if (this.m_list.size() == 1) {
                Wrapper w = this.m_list.get(0);
                w.m_component.setBounds(0, 0, size.width, size.height);
                return;
            }
            this.m_numBars = this.m_list.size() - 1;
            this.m_totalBarPixels = this.m_numBars * this.m_barSize;
            this.m_availablePixels = size.width - this.m_totalBarPixels;
            if (this.m_availablePixels < 2 * this.m_list.size()) {
                return;
            }
            if (this.m_numBars > this.m_barPixelLeft.length) {
                this.m_barPixelLeft = new int[this.m_numBars + 10];
            }
            this.m_minWidthSum = 0;
            this.m_stretchSum = 0;
            for (Wrapper w : this.m_list) {
                this.m_minWidthSum += w.m_minWidth;
                this.m_stretchSum += w.m_stretch;
            }
            if (this.m_stretchSum < 1 || this.m_minWidthSum >= this.m_availablePixels) {
                this.layout_notEnoughPixels();
            } else {
                this.layout_enoughPixels();
            }
            int left = 0;
            int bar = 0;
            for (Wrapper w : this.m_list) {
                w.m_left = left;
                w.m_right = left + w.m_actualWidth;
                if (bar < this.m_numBars) {
                    this.m_barPixelLeft[bar] = w.m_right;
                    ++bar;
                }
                w.m_component.setBounds(left, 0, w.m_actualWidth, size.height);
                w.m_component.setVisible(true);
                left = w.m_right + this.m_barSize;
            }
            this.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void layout_notEnoughPixels() {
        try {
            int numUsed = 0;
            for (Wrapper w : this.m_list) {
                double width = (double)this.m_availablePixels * (double)w.m_minWidth / (double)this.m_minWidthSum;
                w.m_actualWidth = (int)width;
                w.m_actualWidth = Math.max(2, w.m_actualWidth);
                numUsed += w.m_actualWidth;
            }
            while (numUsed > this.m_availablePixels) {
                Wrapper largest = null;
                int max = 0;
                for (Wrapper w : this.m_list) {
                    if (w.m_actualWidth <= max) continue;
                    max = w.m_actualWidth;
                    largest = w;
                }
                --largest.m_actualWidth;
                --numUsed;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void layout_enoughPixels() {
        try {
            int numExtra = this.m_availablePixels - this.m_minWidthSum;
            int numUsed = 0;
            for (Wrapper w : this.m_list) {
                double width = (double)numExtra * (double)w.m_stretch / (double)this.m_stretchSum;
                w.m_actualWidth = w.m_minWidth + (int)width;
                w.m_actualWidth = Math.max(2, w.m_actualWidth);
                numUsed += w.m_actualWidth;
            }
            while (numUsed > this.m_availablePixels) {
                Wrapper largest = null;
                int max = 0;
                for (Wrapper w : this.m_list) {
                    if (w.m_actualWidth <= max) continue;
                    max = w.m_actualWidth;
                    largest = w;
                }
                --largest.m_actualWidth;
                --numUsed;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        try {
            this.manualWidgetLayout();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        try {
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        try {
            Tools_Widget.setCursor(0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (this.m_dragBar < 0) {
                return;
            }
            this.requestFocusInWindow(true);
            System.out.println("mousePressed");
            Wrapper left = this.m_list.get(this.m_dragBar);
            Wrapper right = this.m_list.get(this.m_dragBar + 1);
            this.m_dragMinX = left.m_left + 10;
            this.m_dragMaxX = right.m_right - 10;
            this.m_dragX = event.getX();
            left.m_component.setVisible(false);
            right.m_component.setVisible(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        try {
            boolean rightStretch;
            System.out.println("mouseReleased");
            if (this.m_dragBar < 0) {
                return;
            }
            Wrapper left = this.m_list.get(this.m_dragBar);
            Wrapper right = this.m_list.get(this.m_dragBar + 1);
            int leftExtra = left.m_actualWidth - left.m_minWidth;
            int rightExtra = right.m_actualWidth - right.m_minWidth;
            boolean leftStretch = left.m_stretch >= 1;
            boolean bl = rightStretch = right.m_stretch >= 1;
            if (!leftStretch && rightStretch) {
                left.m_minWidth = this.m_dragX - left.m_left;
                left.m_minWidth = Math.max(2, left.m_minWidth);
            }
            if (leftStretch && !rightStretch) {
                right.m_minWidth = right.m_left + right.m_actualWidth - this.m_dragX;
                right.m_minWidth = Math.max(2, right.m_minWidth);
            }
            if (leftStretch && rightStretch) {
                right.m_minWidth = right.m_left + right.m_actualWidth - this.m_dragX;
                right.m_minWidth = Math.max(2, right.m_minWidth);
            }
            this.manualWidgetLayout();
            this.m_dragBar = -9999;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        try {
            if (this.m_dragBar < 0) {
                return;
            }
            this.m_dragX = event.getX();
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        try {
            if (this.m_dragBar >= 0) {
                return;
            }
            int x = event.getX();
            this.m_dragBar = -9999;
            for (int n = 0; n < this.m_numBars; ++n) {
                int left = this.m_barPixelLeft[n];
                if (x < left || x >= left + this.m_barSize) continue;
                this.m_dragBar = n;
                Tools_Widget.setCursor(11);
            }
            if (this.m_dragBar < 0) {
                Tools_Widget.setCursor(0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
    }

    protected class Wrapper {
        public JComponent m_component = null;
        public int m_stretch = 0;
        public int m_minWidth = 0;
        public int m_left;
        public int m_right;
        public int m_actualWidth;

        public Wrapper(JComponent comp, int stretch, int minWidth) {
            this.m_stretch = Math.max(stretch, 0);
            this.m_minWidth = Math.max(minWidth, 2);
            this.m_component = comp;
        }
    }
}

