/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class MultipleFileSelectionWidget
extends LinearLayoutWidget
implements ActionListener {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected JButton m_addFilesButton;
    protected JButton m_clearFilesButton;
    protected JButton m_clearSelectedFilesButton;
    protected JList<String> m_list = new JList();
    protected ArrayList<String> m_files = new ArrayList();
    public boolean RequireSegy = false;
    public boolean ShowSegyWarning = false;

    public MultipleFileSelectionWidget(String label) {
        super(LinearLayoutWidget.Direction.Vertical, 0, label);
        try {
            LinearLayoutWidget top = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            this.m_addFilesButton = top.createButton("Add file(s)", this, 0);
            top.addStretch(10);
            this.m_clearFilesButton = top.createButton("Clear all", this, 0);
            this.m_clearSelectedFilesButton = top.createButton("Clear selected", this, 0);
            JScrollPane scroller = new JScrollPane(this.m_list, 22, 32);
            this.addComponent(scroller, 10);
            this.reloadList(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public ArrayList<String> fileList() {
        return this.m_files;
    }

    public void setFileList(ArrayList<String> files, boolean broadcast) {
        try {
            this.m_files.clear();
            if (files != null) {
                for (String s : files) {
                    this.m_files.add(s);
                }
            }
            this.reloadList(broadcast);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadList(boolean broadcast) {
        try {
            DefaultListModel<String> model = new DefaultListModel<String>();
            if (this.m_files.size() >= 1) {
                for (String s : this.m_files) {
                    model.addElement(s);
                }
            }
            this.m_list.setModel(model);
            if (broadcast) {
                this.m_listenerManager.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void addFiles() {
        try {
            ArrayList<String> newFiles = Tools_Chooser.getFileNames(null);
            if (newFiles == null) {
                return;
            }
            for (String s : newFiles) {
                boolean present = false;
                for (String name : this.m_files) {
                    present = present || name.equalsIgnoreCase(s);
                }
                if (present) continue;
                String fixed = Tools_FileSystem.convertToUnixFileName(s);
                boolean ok = true;
                if (ok && this.RequireSegy) {
                    Segy segy = new Segy();
                    segy.setFileName(fixed);
                    ok = segy.isFileOK();
                    if (!ok && this.ShowSegyWarning) {
                        JOptionPane.showMessageDialog(null, fixed + " is not a valid SEG-Y file, reason = : " + segy.reasonObjectNotValid(), "Not a valid SEG-Y file", 0);
                    }
                }
                if (!ok) continue;
                this.m_files.add(fixed);
            }
            this.reloadList(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void clearSelected() {
        try {
            int[] sel = this.m_list.getSelectedIndices();
            if (sel == null) {
                return;
            }
            Arrays.sort(sel);
            for (int n = sel.length - 1; n >= 0; --n) {
                int index = sel[n];
                if (index < 0 || index >= this.m_files.size()) continue;
                this.m_files.remove(index);
            }
            this.reloadList(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_clearSelectedFilesButton) {
                this.clearSelected();
                return;
            }
            if (e.getSource() == this.m_addFilesButton) {
                this.addFiles();
                return;
            }
            if (e.getSource() == this.m_clearFilesButton) {
                this.m_files.clear();
                this.reloadList(true);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

