/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

public class HtmlBuilder {
    protected StringBuilder m_builder;
    protected boolean m_bCreatingOrderedList = false;

    public HtmlBuilder() {
        try {
            this.reset();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void reset() {
        try {
            this.m_builder = new StringBuilder();
            this.m_builder.append("<html>");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addLine() {
        try {
            this.m_builder.append("<hr>");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void beginOrderedList(String type) {
        try {
            this.m_bCreatingOrderedList = true;
            String s = String.format("<ol type=\"%s\">", type);
            this.m_builder.append(s);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addItemToOrderedList(String s) {
        try {
            if (!this.m_bCreatingOrderedList) {
                return;
            }
            this.m_builder.append(String.format("<li>%s</li>", s));
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void endOrderedList() {
        try {
            this.m_bCreatingOrderedList = false;
            this.m_builder.append("</ol>");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public String createUnorderedList(String ... items) {
        try {
            StringBuilder b = new StringBuilder();
            b.append("<ol>");
            for (String s : items) {
                String line = String.format("<li>%s</li>", s);
                b.append(line);
            }
            b.append("</ol>");
            return b.toString();
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    public String createOrderedList(String ... items) {
        try {
            StringBuilder b = new StringBuilder();
            b.append("<ol>");
            for (String s : items) {
                String line = String.format("<li>%s</li>", s);
                b.append(line);
            }
            b.append("</ol>");
            return b.toString();
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    public void addOrderedList(String ... items) {
        try {
            this.m_builder.append("<ol>");
            for (String s : items) {
                String line = String.format("<li>%s</li>", s);
                this.m_builder.append(line);
            }
            this.m_builder.append("</ol>");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addItem(String s, String color, Size fs) {
        try {
            String str = String.format("<li><font size = \"%d\" color=%s>%s</font></li>", fs.Value, color, s);
            this.m_builder.append(str);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addItem(String s, Size fs) {
        try {
            this.addItem(s, "black", fs);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addItem(String s, String color) {
        try {
            this.addItem(s, color, Size.Normal);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void addItem(String s) {
        try {
            this.addItem(s, "black");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void add(String s, String color, Size size) {
        try {
            String str = String.format("<font size=\"%d\" color=%s>%s</font><br>", size.Value, color, s);
            this.m_builder.append(str);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void add(String s, String color) {
        try {
            this.add(s, color, Size.Normal);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void add(String s) {
        try {
            this.add(s, "black", Size.Normal);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public String finish() {
        try {
            if (this.m_builder == null) {
                this.reset();
            }
            this.m_builder.append("</html>");
            return this.m_builder.toString();
        }
        catch (Exception error) {
            error.printStackTrace();
            return "";
        }
    }

    public static enum Size {
        Smaller(1),
        Small(2),
        Normal(3),
        Big(4),
        Bigger(5),
        Biggest(6);

        public final int Value;

        private Size(int val) {
            this.Value = val;
        }
    }
}

