/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;

public class FileWidget
extends LinearLayoutWidget
implements ActionListener {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected JTextField m_textField;
    protected JButton m_button;
    protected JButton m_buttonChunk;
    protected JButton m_buttonChunkNE;
    protected boolean m_directories = false;
    public boolean OpenFile = true;
    public String SaveSuffix = "";
    public static String SegyChunks = "SegyChunks";
    public static String SegyChunksNE = "SegyChunksNE";

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public FileWidget(boolean directories, boolean segy, int insets, String title, GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Horizontal, insets, title);
        try {
            if (listener != null) {
                this.m_listenerManager.addListener(listener);
            }
            this.m_directories = directories;
            this.m_textField = this.createTextField("", null, 10);
            this.m_textField.setEditable(false);
            this.m_button = Tools_Bitmap.makeButton(this, BitmapEnum.FileOpen, "", (ActionListener)this);
            this.m_button.setToolTipText("Open a file");
            if (segy) {
                this.m_buttonChunk = Tools_Bitmap.makeButton(this, BitmapEnum.Snapshot, "", (ActionListener)this);
                this.m_buttonChunk.setToolTipText("Create a file containing the first 1,000 traces - include EBCDIC");
                this.m_buttonChunkNE = Tools_Bitmap.makeButton(this, BitmapEnum.Snapshot, "", (ActionListener)this);
                this.m_buttonChunkNE.setToolTipText("Create a file containing the first 1,000 traces - clear EBCDIC");
                this.m_button.setToolTipText("Open a SEG-Y file");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public FileWidget(boolean directories, int insets, String title, GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Horizontal, insets, title);
        try {
            if (listener != null) {
                this.m_listenerManager.addListener(listener);
            }
            this.m_directories = directories;
            this.m_textField = this.createTextField("", null, 10);
            this.m_textField.setEditable(false);
            this.m_button = Tools_Bitmap.makeButton(this, BitmapEnum.FileOpen, "", (ActionListener)this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEditable() {
        this.m_textField.setEditable(true);
    }

    public void setText(String s) {
        try {
            if (s != null) {
                String fixed = Tools_FileSystem.convertToUnixFileName(s);
                this.m_textField.setText(fixed);
            } else {
                this.m_textField.setText("");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String getText() {
        return this.m_textField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_buttonChunk) {
                this.m_listenerManager.broadcast(this, SegyChunks);
                return;
            }
            if (e.getSource() == this.m_buttonChunkNE) {
                this.m_listenerManager.broadcast(this, SegyChunksNE);
                return;
            }
            if (e.getSource() == this.m_button) {
                if (this.m_directories) {
                    String path = Tools_Chooser.getDirectory("");
                    if (path != null) {
                        this.setText(path);
                        this.m_listenerManager.broadcast(this, path);
                    }
                } else if (this.OpenFile) {
                    String file = Tools_Chooser.getFileName();
                    if (file != null) {
                        this.setText(file);
                        this.m_listenerManager.broadcast(this, file);
                    }
                } else {
                    String file = Tools_Chooser.getSaveFileName(this.SaveSuffix);
                    if (file != null) {
                        file = Tools_Strings.confirmSuffix(file, this.SaveSuffix);
                        this.setText(file);
                        this.m_listenerManager.broadcast(this, file);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

